/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineLookUpTable {
    HashSet<LineRecord> lineRecords = new HashSet();

    public void getIntersectsEntity() {
    }

    public void getOverlapsOtherLine() {
    }

    private Point[] getIntersections(LineRecord localLineRecord) {
        HashSet<Point> intersectionPoints = new HashSet<Point>();
        for (LineRecord lineRecord : this.lineRecords) {
            Point intersectionPoint = localLineRecord.getIntersection(lineRecord);
            if (lineRecord == null) continue;
            intersectionPoints.add(intersectionPoint);
        }
        return intersectionPoints.toArray(new Point[0]);
    }

    public Point[] adjustLineToObstructions(String lineIdString, ArrayList<Point> pointsList) {
        LineRecord localLineRecord = new LineRecord(lineIdString, pointsList);
        this.getIntersections(localLineRecord);
        this.lineRecords.add(localLineRecord);
        return localLineRecord.pointsList.toArray(new Point[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LineRecord {
        private String lineIdSring;
        private ArrayList<Point> pointsList;

        public LineRecord(String lineIdString, ArrayList<Point> pointsList) {
            this.lineIdSring = lineIdString;
            this.pointsList = pointsList;
        }

        protected Point getIntersection(LineRecord lineRecord) {
            return null;
        }

        private void insertLoop(int linePart) {
            Point startPoint = this.pointsList.get(linePart);
            Point endPoint = this.pointsList.get(linePart + 1);
            int centerX = (startPoint.x + endPoint.x) / 2;
            int centerY = (startPoint.y + endPoint.y) / 2;
            int startOffset = -5;
            int endOffset = 5;
            int loopHeight = -10;
            if (startPoint.x == endPoint.x) {
                if (startPoint.y < endPoint.y) {
                    startOffset = 5;
                    endOffset = -5;
                }
                this.pointsList.add(linePart + 1, new Point(centerX, centerY + startOffset));
                this.pointsList.add(linePart + 1, new Point(centerX + loopHeight, centerY + startOffset));
                this.pointsList.add(linePart + 1, new Point(centerX + loopHeight, centerY + endOffset));
                this.pointsList.add(linePart + 1, new Point(centerX, centerY + endOffset));
            } else {
                if (startPoint.x < endPoint.x) {
                    startOffset = 5;
                    endOffset = -5;
                }
                this.pointsList.add(linePart + 1, new Point(centerX + startOffset, centerY));
                this.pointsList.add(linePart + 1, new Point(centerX + startOffset, centerY + loopHeight));
                this.pointsList.add(linePart + 1, new Point(centerX + endOffset, centerY + loopHeight));
                this.pointsList.add(linePart + 1, new Point(centerX + endOffset, centerY));
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineRecord other = (LineRecord)obj;
            return !(this.lineIdSring == null ? other.lineIdSring != null : !this.lineIdSring.equals(other.lineIdSring));
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.lineIdSring != null ? this.lineIdSring.hashCode() : 0);
            return hash;
        }
    }
}

