/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class DiagramOptionsMenu
extends JMenu {
    public DiagramOptionsMenu(final AbstractDiagramManager diagramWindowManager) {
        this.setText("Diagram Options");
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                SavePanel currentSavePanel = diagramWindowManager.getCurrentSavePanel();
                DiagramOptionsMenu.this.removeAll();
                if (currentSavePanel != null) {
                    DiagramOptionsMenu.this.setupMenuItems(currentSavePanel, currentSavePanel.getGraphPanel());
                } else {
                    JMenuItem noItemsMenu = new JMenuItem("<no items available in this context>");
                    noItemsMenu.setEnabled(false);
                    DiagramOptionsMenu.this.add(noItemsMenu);
                }
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void setupMenuItems(SavePanel currentSavePanel, final GraphPanel graphPanel) {
        JCheckBoxMenuItem snapToGridMenuItem = new JCheckBoxMenuItem("Snap To Grid");
        snapToGridMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.snapToGrid = !graphPanel.dataStoreSvg.snapToGrid;
            }
        });
        this.add(snapToGridMenuItem);
        JCheckBoxMenuItem highlightRelationsMenuItem = new JCheckBoxMenuItem("Highlight Selected Relations");
        highlightRelationsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.highlightRelationLines = !graphPanel.dataStoreSvg.highlightRelationLines;
                graphPanel.drawNodes();
            }
        });
        this.add(highlightRelationsMenuItem);
        JCheckBoxMenuItem showBorderMenuItem = new JCheckBoxMenuItem("Show Diagram Border");
        showBorderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showDiagramBorder = !graphPanel.dataStoreSvg.showDiagramBorder;
                graphPanel.drawNodes();
            }
        });
        this.add(showBorderMenuItem);
        JCheckBoxMenuItem showSanguineLinesMenuItem = new JCheckBoxMenuItem("Show Sanguin Lines");
        showSanguineLinesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showSanguineLines = !graphPanel.dataStoreSvg.showSanguineLines;
                graphPanel.drawNodes();
            }
        });
        this.add(showSanguineLinesMenuItem);
        JCheckBoxMenuItem showLabelssMenuItem = new JCheckBoxMenuItem("Show Labels");
        showLabelssMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showLabels = !graphPanel.dataStoreSvg.showLabels;
                graphPanel.drawNodes();
            }
        });
        this.add(showLabelssMenuItem);
        JCheckBoxMenuItem showKinTypeLabelssMenuItem = new JCheckBoxMenuItem("Show Kin Type Labels");
        showKinTypeLabelssMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showKinTypeLabels = !graphPanel.dataStoreSvg.showKinTypeLabels;
                graphPanel.drawNodes();
            }
        });
        this.add(showKinTypeLabelssMenuItem);
        JCheckBoxMenuItem showIdLabelsMenuItem = new JCheckBoxMenuItem("Show Id Labels");
        showIdLabelsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showIdLabels = !graphPanel.dataStoreSvg.showIdLabels;
                graphPanel.drawNodes();
            }
        });
        this.add(showIdLabelsMenuItem);
        JCheckBoxMenuItem showDateLabelsMenuItem = new JCheckBoxMenuItem("Show Date Labels");
        showDateLabelsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showDateLabels = !graphPanel.dataStoreSvg.showDateLabels;
                graphPanel.drawNodes();
            }
        });
        this.add(showDateLabelsMenuItem);
        JCheckBoxMenuItem showArchiveLinksMenuItem = new JCheckBoxMenuItem("Show Archive Links");
        showArchiveLinksMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showArchiveLinks = !graphPanel.dataStoreSvg.showArchiveLinks;
                graphPanel.drawNodes();
            }
        });
        this.add(showArchiveLinksMenuItem);
        snapToGridMenuItem.setSelected(graphPanel.dataStoreSvg.snapToGrid);
        highlightRelationsMenuItem.setSelected(graphPanel.dataStoreSvg.highlightRelationLines);
        showBorderMenuItem.setSelected(graphPanel.dataStoreSvg.showDiagramBorder);
        showSanguineLinesMenuItem.setSelected(graphPanel.dataStoreSvg.showSanguineLines);
        showLabelssMenuItem.setSelected(graphPanel.dataStoreSvg.showLabels);
        showKinTypeLabelssMenuItem.setSelected(graphPanel.dataStoreSvg.showKinTypeLabels);
        showIdLabelsMenuItem.setSelected(graphPanel.dataStoreSvg.showIdLabels);
        showDateLabelsMenuItem.setSelected(graphPanel.dataStoreSvg.showDateLabels);
        showArchiveLinksMenuItem.setSelected(graphPanel.dataStoreSvg.showArchiveLinks);
    }
}

