/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.relationsettings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.DataStoreSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationTypesTableModel
extends AbstractTableModel
implements ActionListener {
    SavePanel savePanel;
    DataStoreSvg dataStoreSvg;
    HashSet<RelationTypeDefinition> checkBoxSet = new HashSet();
    JButton deleteSelectedButton;

    public RelationTypesTableModel(SavePanel savePanel, DataStoreSvg dataStoreSvg, JButton deleteSelectedButton) {
        this.savePanel = savePanel;
        this.dataStoreSvg = dataStoreSvg;
        this.deleteSelectedButton = deleteSelectedButton;
        deleteSelectedButton.setEnabled(false);
        deleteSelectedButton.addActionListener(this);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 3;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Custom Name";
            }
            case 1: {
                return "Data Category";
            }
            case 2: {
                return "Relation Type";
            }
            case 3: {
                return "Line Colour";
            }
            case 4: {
                return "Line Width";
            }
            case 5: {
                return "Line/Dash";
            }
            case 6: {
                return "Line Orientation";
            }
            case 7: {
                return "";
            }
        }
        throw new UnsupportedOperationException("Too many columns");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 7: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.dataStoreSvg.getRelationTypeDefinitions().length + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.dataStoreSvg.getRelationTypeDefinitions().length) {
            RelationTypeDefinition kinType = this.dataStoreSvg.getRelationTypeDefinitions()[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return kinType.getDisplayName();
                }
                case 1: {
                    return kinType.getDataCategory();
                }
                case 2: {
                    return kinType.getRelationType();
                }
                case 3: {
                    return kinType.getLineColour();
                }
                case 4: {
                    return kinType.getLineWidth();
                }
                case 5: {
                    return kinType.getLineStye();
                }
                case 6: {
                    return kinType.getCurveLineOrientation();
                }
                case 7: {
                    return this.checkBoxSet.contains(kinType);
                }
            }
            throw new UnsupportedOperationException("Too many columns");
        }
        switch (columnIndex) {
            case 7: {
                return false;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        RelationTypeDefinition[] kinTypeDefinitions = this.dataStoreSvg.getRelationTypeDefinitions();
        if (rowIndex >= this.dataStoreSvg.getRelationTypeDefinitions().length && columnIndex == 7) {
            if (this.checkBoxSet.isEmpty()) {
                this.checkBoxSet.addAll(Arrays.asList(kinTypeDefinitions));
            } else {
                this.checkBoxSet.clear();
            }
            this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
            this.fireTableDataChanged();
            return;
        }
        String displayName = "undefined";
        DataTypes.RelationType relationType = DataTypes.RelationType.ancestor;
        String dataCategory = "";
        String lineColour = "#999999";
        int lineWidth = 2;
        String lineStye = null;
        RelationTypeDefinition.CurveLineOrientation curveLineOrientation = RelationTypeDefinition.CurveLineOrientation.horizontal;
        RelationTypeDefinition kinType = null;
        if (rowIndex < this.dataStoreSvg.getRelationTypeDefinitions().length) {
            kinType = kinTypeDefinitions[rowIndex];
            displayName = kinType.getDisplayName();
            relationType = kinType.getRelationType();
            dataCategory = kinType.getDataCategory();
            lineColour = kinType.getLineColour();
            lineWidth = kinType.getLineWidth();
            lineStye = kinType.getLineStye();
            curveLineOrientation = kinType.getCurveLineOrientation();
        }
        String stringValue = aValue.toString();
        switch (columnIndex) {
            case 0: {
                displayName = stringValue;
                break;
            }
            case 1: {
                dataCategory = stringValue;
                break;
            }
            case 2: {
                relationType = DataTypes.RelationType.valueOf(stringValue);
                break;
            }
            case 3: {
                lineColour = stringValue;
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 4: {
                lineWidth = Integer.parseInt(stringValue.replaceAll("[^0-9]", ""));
                break;
            }
            case 5: {
                lineStye = stringValue;
                break;
            }
            case 6: {
                curveLineOrientation = RelationTypeDefinition.CurveLineOrientation.valueOf(stringValue);
                break;
            }
            case 7: {
                if (((Boolean)aValue).booleanValue()) {
                    this.checkBoxSet.add(kinType);
                } else {
                    this.checkBoxSet.remove(kinType);
                }
                this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
                this.fireTableDataChanged();
                return;
            }
            default: {
                throw new UnsupportedOperationException("Too many columns");
            }
        }
        if (rowIndex < this.dataStoreSvg.getRelationTypeDefinitions().length) {
            kinTypeDefinitions[rowIndex] = new RelationTypeDefinition(displayName, dataCategory, relationType, lineColour, lineWidth, lineStye);
            this.dataStoreSvg.setRelationTypeDefinitions(kinTypeDefinitions);
        } else {
            if ("".equals(aValue)) {
                return;
            }
            ArrayList<RelationTypeDefinition> kinTypesList = new ArrayList<RelationTypeDefinition>(Arrays.asList(kinTypeDefinitions));
            kinTypesList.add(new RelationTypeDefinition(displayName, dataCategory, relationType, lineColour, lineWidth, lineStye));
            this.dataStoreSvg.setRelationTypeDefinitions(kinTypesList.toArray(new RelationTypeDefinition[0]));
        }
        this.savePanel.updateGraph();
        this.savePanel.requiresSave();
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<RelationTypeDefinition> kinTypesList = new ArrayList<RelationTypeDefinition>(Arrays.asList(this.dataStoreSvg.getRelationTypeDefinitions()));
        for (RelationTypeDefinition kinType : this.checkBoxSet) {
            kinTypesList.remove(kinType);
        }
        this.dataStoreSvg.setRelationTypeDefinitions(kinTypesList.toArray(new RelationTypeDefinition[0]));
        this.checkBoxSet.clear();
        this.fireTableDataChanged();
        this.savePanel.updateGraph();
    }
}

