/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.data.DocumentationLanguages;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.util.WindowManager;

public class LanguageListDialogue
extends TemplateDialogue
implements ActionListener {
    private static WindowManager windowManager;
    ArrayList<JCheckBox> checkBoxArray;

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public LanguageListDialogue(JDialog parentFrameLocal) {
        super(parentFrameLocal);
    }

    public static void showLanguageDialogue() {
        JDialog dialog = new JDialog(windowManager.getMainFrame(), "Available Languages", true);
        LanguageListDialogue templateDialogue = new LanguageListDialogue(dialog);
        templateDialogue.populateLists();
        dialog.setContentPane(templateDialogue);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            DocumentationLanguages.getSingleInstance().addselectedLanguage(e.getActionCommand());
        } else {
            DocumentationLanguages.getSingleInstance().removeselectedLanguages(e.getActionCommand());
        }
    }

    protected void populateLists() {
        this.cmdiProfilesPanel.getParent().remove(this.cmdiProfilesPanel);
        this.internalTemplatesPanel.setBorder(BorderFactory.createTitledBorder("Languages to display in the field language select box for IMDI"));
        List<String> selectedLanguages = DocumentationLanguages.getSingleInstance().getSelectedLanguagesArrayList();
        this.checkBoxArray = new ArrayList();
        for (ArbilVocabularyItem currentTemplate : DocumentationLanguages.getSingleInstance().getAllLanguagesForImdi()) {
            JCheckBox languageCheckBox = new JCheckBox();
            languageCheckBox.setText(currentTemplate.itemDisplayName);
            languageCheckBox.setName(currentTemplate.itemDisplayName);
            languageCheckBox.setActionCommand(currentTemplate.itemDisplayName);
            languageCheckBox.setSelected(selectedLanguages.contains(currentTemplate.itemDisplayName));
            languageCheckBox.setToolTipText(currentTemplate.itemDisplayName);
            languageCheckBox.addActionListener(this);
            this.checkBoxArray.add(languageCheckBox);
        }
        LanguageListDialogue.addSorted(this.templatesPanel, this.checkBoxArray);
        JButton selectAllButton = new JButton();
        selectAllButton.setText("Select All");
        selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (JCheckBox currentCheckBox : LanguageListDialogue.this.checkBoxArray) {
                    currentCheckBox.setSelected(true);
                    DocumentationLanguages.getSingleInstance().addselectedLanguage(currentCheckBox.getActionCommand());
                }
            }
        });
        JButton selectNoneButton = new JButton();
        selectNoneButton.setText("Clear Selection");
        selectNoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (JCheckBox currentCheckBox : LanguageListDialogue.this.checkBoxArray) {
                    currentCheckBox.setSelected(false);
                    DocumentationLanguages.getSingleInstance().removeselectedLanguages(currentCheckBox.getActionCommand());
                }
            }
        });
        this.internalTemplatesButtonPanel.removeAll();
        this.internalTemplatesButtonPanel.add(selectNoneButton);
        this.internalTemplatesButtonPanel.add(selectAllButton);
    }
}

