/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.Scanner;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.CommandParser;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Password;
import org.basex.core.cmd.Set;
import org.basex.query.QueryException;
import org.basex.server.Session;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public abstract class Main
implements Runnable {
    private static final boolean NOCONSOLE = System.console() == null;
    public final Context context = new Context();
    protected final boolean success;
    protected OutputStream out = System.out;
    protected boolean console;
    protected Session session;
    protected boolean verbose;

    protected Main(String[] args) {
        this.success = this.parseArguments(args);
        Main.check(this.success);
        this.verbose |= this.console;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Main.this.context.close();
            }
        });
    }

    protected final boolean console() throws IOException {
        while (this.console) {
            Util.out("> ", new Object[0]);
            for (String in : this.inputs()) {
                Boolean b;
                if (in.isEmpty() || (b = this.execute(in)) != null) continue;
                return true;
            }
        }
        return false;
    }

    protected void quit(boolean user) {
        try {
            if (user) {
                Util.outln(Text.CLIENTBYE[new Random().nextInt(4)], new Object[0]);
            }
            this.execute(new Exit(), true);
            this.out.flush();
        }
        catch (IOException ex) {
            Util.errln(Util.server(ex), new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Boolean execute(String in) throws IOException {
        try {
            Command[] commandArray = new CommandParser(in, this.context).parse();
            int n = commandArray.length;
            int n2 = 0;
            while (true) {
                int i;
                if (n2 >= n) {
                    return true;
                }
                Command cmd = commandArray[n2];
                if (cmd instanceof Exit) {
                    return null;
                }
                int n3 = cmd instanceof Password && cmd.args[0] == null ? 0 : (i = (cmd instanceof CreateUser || cmd instanceof AlterUser) && cmd.args[1] == null ? 1 : -1);
                if (i != -1) {
                    Util.out(String.valueOf(Text.SERVERPW) + ": ", new Object[0]);
                    cmd.args[i] = Token.md5(this.password());
                }
                if (!this.execute(cmd, this.verbose)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (QueryException ex) {
            return this.error(ex, ex.getMessage());
        }
    }

    protected final boolean execute(Command cmd, boolean info) throws IOException {
        Session ss = this.session();
        if (ss == null) {
            return false;
        }
        try {
            ss.execute(cmd);
            if (info) {
                Util.out(ss.info(), new Object[0]);
            }
            return true;
        }
        catch (BaseXException ex) {
            return this.error(null, ex.getMessage());
        }
    }

    protected final boolean set(Object[] opt, Object arg) throws IOException {
        return this.execute(new Set(opt, arg), false);
    }

    protected final boolean error(Exception ex, String msg) {
        Util.errln(String.valueOf(this.console ? "" : Text.INFOERROR) + msg.trim(), new Object[0]);
        Util.debug(ex);
        return false;
    }

    protected final StringList inputs() {
        StringList sl = new StringList();
        Scanner scan = new Scanner(System.in).useDelimiter("\\z");
        if (scan.hasNext()) {
            Scanner lines = new Scanner(scan.next());
            while (lines.hasNextLine()) {
                sl.add(lines.nextLine());
            }
        }
        if (sl.size() == 0) {
            sl.add(Commands.Cmd.EXIT.toString());
        }
        return sl;
    }

    protected final String input() {
        Scanner sc = new Scanner(System.in);
        return sc.hasNextLine() ? sc.nextLine().trim() : "";
    }

    protected final String password() {
        if (NOCONSOLE) {
            return this.input();
        }
        char[] pw = System.console().readPassword();
        return pw != null ? new String(pw) : "";
    }

    protected static void check(boolean ok) {
        if (!ok) {
            System.exit(1);
        }
    }

    protected abstract Session session() throws IOException;

    protected abstract boolean parseArguments(String[] var1);
}

