/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexToken;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class Optimize
extends ACreate {
    private int pre;
    private int size;

    public Optimize() {
        super(514, new String[0]);
    }

    @Override
    protected boolean run() {
        Data d = this.context.data;
        MetaData m = d.meta;
        this.size = m.size;
        try {
            Optimize.optimize(d, this.prop, this);
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        return this.info(Text.DBOPTIMIZED, m.name, this.perf);
    }

    @Override
    public double prog() {
        return (double)this.pre / (double)this.size;
    }

    @Override
    public boolean stoppable() {
        return false;
    }

    @Override
    public String det() {
        return Text.INFOSTATS;
    }

    public static void optimize(Data d, Prop p) throws IOException {
        Optimize.optimize(d, p, null);
    }

    private static void optimize(Data d, Prop p, Optimize c) throws IOException {
        d.pthindex.init();
        d.tagindex.init();
        d.atnindex.init();
        MetaData m = d.meta;
        m.dirty = true;
        IntList pars = new IntList();
        IntList tags = new IntList();
        boolean path = p.is(Prop.PATHINDEX);
        int n = 0;
        int pre = 0;
        while (pre < m.size) {
            byte kind = (byte)d.kind(pre);
            int par = d.parent(pre, kind);
            while (!pars.empty() && pars.peek() > par) {
                pars.pop();
                tags.pop();
            }
            if (kind == 0) {
                pars.push(pre);
                tags.push(0);
                if (path) {
                    d.pthindex.index(0, kind, pars.size());
                }
                ++n;
            } else if (kind == 1) {
                int id = d.name(pre);
                d.tagindex.index(d.tagindex.key(id), null, true);
                if (path) {
                    d.pthindex.index(id, kind, pars.size());
                }
                pars.push(pre);
                tags.push(id);
            } else if (kind == 3) {
                int id = d.name(pre);
                d.atnindex.index(d.atnindex.key(id), d.text(pre, false), true);
                if (path) {
                    d.pthindex.index(id, kind, pars.size());
                }
            } else {
                byte[] txt = d.text(pre, true);
                if (kind == 2) {
                    d.tagindex.index(tags.peek(), txt);
                }
                if (path) {
                    d.pthindex.index(0, kind, pars.size());
                }
            }
            if (c != null) {
                c.pre = pre;
            }
            ++pre;
        }
        m.ndocs = n;
        m.pathindex = path;
        m.uptodate = true;
        try {
            if (m.textindex || p.is(Prop.TEXTINDEX)) {
                Optimize.index(IndexToken.IndexType.TEXT, d, c);
            }
            if (m.attrindex || p.is(Prop.ATTRINDEX)) {
                Optimize.index(IndexToken.IndexType.ATTRIBUTE, d, c);
            }
            if (m.ftindex || p.is(Prop.FTINDEX)) {
                Optimize.index(IndexToken.IndexType.FULLTEXT, d, c);
            }
        }
        finally {
            d.flush();
        }
    }
}

