/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class ImportSamplesFileMenu
extends JMenu
implements ActionListener {
    private AbstractDiagramManager diagramWindowManager;
    private MessageDialogHandler dialogHandler;

    public ImportSamplesFileMenu(AbstractDiagramManager diagramWindowManager, MessageDialogHandler dialogHandler) {
        this.diagramWindowManager = diagramWindowManager;
        this.dialogHandler = dialogHandler;
        this.addSampleToMenu("Gedcom Simple File (small sample of three individuals)", "/gedcomsamples/wiki-test-ged.ged");
        this.addSampleToMenu("Gedcom Torture File (only for testing GEDOM compliance)", "/TestGED/TGC55C.ged");
        this.addSampleToMenu("Descententes de Jose Antonio de Figueiredo", "/gedcomsamples/descententes_de_jose_antonio_de_figueiredo.ged");
        this.addSampleToMenu("European Royalty (royal92.ged)", "/gedcomsamples/royal92.ged");
    }

    private void addSampleToMenu(String menuText, String sampleFileString) {
        JMenuItem currentMenuItem = new JMenuItem(menuText);
        currentMenuItem.setActionCommand(sampleFileString);
        currentMenuItem.addActionListener(this);
        this.add(currentMenuItem);
    }

    public void actionPerformed(ActionEvent e) {
        SavePanel originatingSavePanel = this.diagramWindowManager.getCurrentSavePanel();
        try {
            this.diagramWindowManager.openJarImportPanel(e.getActionCommand(), originatingSavePanel);
        }
        catch (ImportException exception1) {
            this.dialogHandler.addMessageDialogToQueue(exception1.getMessage() + "\n" + e.getActionCommand(), "Import Sample Data");
        }
    }
}

