/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.KinTypeStringProvider;

public class KinTypeStringInput
extends JTextPane
implements KinTypeStringProvider {
    private String previousKinTypeStrings = null;
    private String lastDefaultString;
    private Color defaultColour = Color.GRAY;
    protected Style styleComment;
    protected Style styleKinType;
    protected Style styleQuery;
    protected Style styleParamater;
    protected Style styleMessage;
    protected Style styleError;
    protected Style styleUnknown;
    private ParserHighlight[] parserHighlight = null;
    DataStoreSvg dataStore;

    public KinTypeStringInput(DataStoreSvg dataStore) {
        this.dataStore = dataStore;
        this.setToolTipText("");
        this.setDragEnabled(true);
        this.styleComment = this.addStyle("Comment", null);
        StyleConstants.setForeground(this.styleComment, Color.GRAY);
        this.styleKinType = this.addStyle("KinType", null);
        StyleConstants.setForeground(this.styleKinType, new Color(43, 32, 161));
        this.styleQuery = this.addStyle("Query", null);
        StyleConstants.setForeground(this.styleQuery, new Color(183, 7, 140));
        this.styleMessage = this.addStyle("Message", null);
        StyleConstants.setForeground(this.styleMessage, new Color(7, 103, 200));
        this.styleParamater = this.addStyle("Parameter", null);
        StyleConstants.setForeground(this.styleParamater, new Color(103, 7, 200));
        this.styleError = this.addStyle("Error", null);
        StyleConstants.setForeground(this.styleError, Color.RED);
        this.styleUnknown = this.addStyle("Unknown", null);
        StyleConstants.setForeground(this.styleUnknown, Color.BLACK);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                KinTypeStringInput.this.clearDefaultKinTypeInput();
            }

            public void focusLost(FocusEvent e) {
                KinTypeStringInput.this.checkKinTypeInput();
            }
        });
        this.setForeground(this.defaultColour);
        this.setText(this.getDefaultText());
    }

    private String getDefaultText() {
        StringBuilder defaultString = new StringBuilder();
        if (this.dataStore.diagramMode == DataStoreSvg.DiagramMode.FreeForm) {
            defaultString.append("# The kin type strings entered in this text area will determine the diagram drawn below. For more information see the sample diagram \"Freeform Diagram Syntax\".\n");
            defaultString.append("# <KinType>:<id>;<label>;<label...>;<DOB>-<DOD>:<KinType...>");
        } else {
            defaultString.append("# The queries here will be used to search the database. For more information see the sample diagram \"Query Diagram Syntax\".\n");
            defaultString.append("# <KinType>[<search term>]<KinType>[<search field> = <search term>][<search field> == <search term>][<search field> > <search term>][<search field> < <search term>]<KinType...>");
        }
        this.lastDefaultString = defaultString.toString();
        return this.lastDefaultString;
    }

    public void setDefaultText() {
        this.setText(this.getDefaultText());
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.getStyle("Comment"), true);
        this.setCaretPosition(0);
    }

    public void clearDefaultKinTypeInput() {
        if (this.getText().equals(this.lastDefaultString)) {
            this.setText("");
        }
    }

    public void checkKinTypeInput() {
        if (this.getText().length() == 0) {
            this.setDefaultText();
        }
    }

    public String[] getCurrentStrings() {
        this.previousKinTypeStrings = this.getText();
        return this.getText().split("\n");
    }

    public boolean hasChanges() {
        return this.previousKinTypeStrings == null || !this.previousKinTypeStrings.equals(this.getText());
    }

    public void highlightKinTypeStrings(ParserHighlight[] parserHighlight, String[] kinTypeStrings) {
        this.parserHighlight = parserHighlight;
        StyledDocument styledDocument = this.getStyledDocument();
        int lineStart = 0;
        for (int lineCounter = 0; lineCounter < parserHighlight.length; ++lineCounter) {
            ParserHighlight currentHighlight = parserHighlight[lineCounter];
            int lineEnd = lineStart + kinTypeStrings[lineCounter].length();
            styledDocument.setCharacterAttributes(lineStart, lineEnd, this.getStyle("Unknown"), true);
            while (currentHighlight.highlight != null) {
                int startPos = lineStart + currentHighlight.startChar;
                int charCount = lineEnd - lineStart;
                if (currentHighlight.nextHighlight.highlight != null) {
                    charCount = currentHighlight.nextHighlight.startChar - currentHighlight.startChar;
                }
                if (currentHighlight.highlight != null) {
                    String styleName = currentHighlight.highlight.name();
                    styledDocument.setCharacterAttributes(startPos, charCount, this.getStyle(styleName), true);
                }
                currentHighlight = currentHighlight.nextHighlight;
            }
            lineStart += kinTypeStrings[lineCounter].length() + 1;
        }
    }

    public Point getToolTipLocation(MouseEvent event) {
        if (this.parserHighlight != null && !this.previousKinTypeStrings.isEmpty()) {
            int textPosition = this.viewToModel(event.getPoint());
            String[] lineStrings = this.previousKinTypeStrings.substring(0, textPosition).split("\n");
            int linePosition = lineStrings.length;
            int lineChar = lineStrings[linePosition - 1].length();
            ParserHighlight currentHighlight = this.parserHighlight[linePosition - 1];
            while (currentHighlight.highlight != null && currentHighlight.nextHighlight.highlight != null && currentHighlight.nextHighlight.startChar <= lineChar) {
                currentHighlight = currentHighlight.nextHighlight;
            }
            this.setToolTipText(currentHighlight.tooltipText);
        } else {
            this.setToolTipText(null);
        }
        return super.getToolTipLocation(event);
    }

    public int getTotalLength() {
        return this.getText().split("\n").length;
    }
}

