/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;

public class ArbilTreeRenderer
implements TreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel returnComponent;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof ArbilNode) {
            ArbilNode arbilNode = (ArbilNode)node.getUserObject();
            returnComponent = new JLabel(arbilNode.toString(), arbilNode.getIcon(), 2);
            if (arbilNode instanceof ArbilDataNode) {
                if (((ArbilDataNode)arbilNode).isContainerNode()) {
                    returnComponent.setForeground(Color.DARK_GRAY);
                    returnComponent.setText("<html><u>" + arbilNode.toString() + "</u></html>");
                }
                if (((ArbilDataNode)arbilNode).hasSchemaError) {
                    returnComponent.setForeground(Color.RED);
                }
                if (((ArbilDataNode)arbilNode).getNeedsSaveToDisk(true)) {
                    returnComponent.setForeground(Color.BLUE);
                }
            }
        } else if (node.getUserObject() instanceof JLabel) {
            returnComponent = new JLabel(((JLabel)node.getUserObject()).getText(), ((JLabel)node.getUserObject()).getIcon(), 2);
        } else {
            return new JLabel();
        }
        if (selected) {
            returnComponent.setOpaque(true);
            returnComponent.setBackground(tree.getBackground().darker());
        }
        return returnComponent;
    }
}

