/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.XMLSyntax;

public final class DialogHelp
extends Dialog {
    private final BaseXEditor area;

    public DialogHelp(GUI main) {
        super(main, Text.HELPTIT, false);
        this.panel.border(5, 5, 5, 5);
        this.panel.setBackground(Color.white);
        this.area = new BaseXEditor(false, (Window)this.gui);
        this.area.setSyntax(new XMLSyntax());
        this.set(this.area, "Center");
        this.setResizable(true);
        int[] size = main.gprop.nums(GUIProp.HELPSIZE);
        this.setPreferredSize(new Dimension(size[0], size[1]));
        this.finish(main.gprop.nums(GUIProp.HELPLOC));
        this.refresh();
    }

    public void setText(byte[] help) {
        this.area.setText(help);
    }

    public void refresh() {
        this.area.setFont(GUIConstants.font);
    }

    @Override
    public void close() {
        this.gui.gprop.set(GUIProp.SHOWHELP, false);
        this.gui.gprop.set(GUIProp.HELPSIZE, new int[]{this.getWidth(), this.getHeight()});
        this.gui.refreshControls();
        this.gui.help = null;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.close();
    }
}

