/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Date;
import org.basex.query.item.Dbl;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.Formatter;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNFormat
extends FuncCall {
    public FNFormat(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case FORMINT: {
                return this.formatInteger(ctx);
            }
            case FORMNUM: {
                return this.formatNumber(ctx);
            }
            case FORMDTM: {
                return this.formatDate(AtomType.DTM, ctx);
            }
            case FORMDAT: {
                return this.formatDate(AtomType.DAT, ctx);
            }
            case FORMTIM: {
                return this.formatDate(AtomType.TIM, ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 || super.uses(u);
    }

    private Str formatInteger(QueryContext ctx) throws QueryException {
        byte[] lng;
        byte[] pic = this.checkStr(this.expr[1], ctx);
        byte[] byArray = lng = this.expr.length == 2 ? Token.EMPTY : this.checkStr(this.expr[2], ctx);
        if (this.expr[0].empty()) {
            return Str.ZERO;
        }
        long num = this.checkItr(this.expr[0], ctx);
        if (pic.length == 0) {
            Err.WRONGINT.thrw(this.input, new Object[]{pic});
        }
        FormatParser fp = new FormatParser(this.input, pic, null);
        return Str.get(Formatter.get(Token.string(lng)).formatInt(num, fp));
    }

    private Str formatNumber(QueryContext ctx) throws QueryException {
        Item it = this.expr[0].item(ctx, this.input);
        if (it == null) {
            it = Dbl.NAN;
        } else if (!it.unt() && !it.num()) {
            Err.number(this, it);
        }
        String pic = Token.string(this.checkStr(this.expr[1], ctx));
        byte[] frm = new QNm(this.expr.length == 3 ? this.checkStr(this.expr[2], ctx) : Token.EMPTY).full();
        DecFormatter df = ctx.decFormats.get(frm);
        if (df == null) {
            throw Err.FORMNUM.thrw(this.input, new Object[]{frm});
        }
        return Str.get(df.format(this.input, it, pic));
    }

    private Item formatDate(Type tp, QueryContext ctx) throws QueryException {
        byte[] plc;
        Item it = this.expr[0].item(ctx, this.input);
        byte[] pic = this.checkEStr(this.expr[1], ctx);
        byte[] lng = this.expr.length == 5 ? this.checkEStr(this.expr[2], ctx) : Token.EMPTY;
        byte[] cal = this.expr.length == 5 ? this.checkEStr(this.expr[3], ctx) : Token.EMPTY;
        byte[] byArray = plc = this.expr.length == 5 ? this.checkEStr(this.expr[4], ctx) : Token.EMPTY;
        if (it == null) {
            return null;
        }
        Date date = (Date)this.checkType(it, tp);
        Formatter form = Formatter.get(Token.string(lng));
        return Str.get(form.formatDate(date, pic, cal, plc, this.input));
    }
}

