/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilRootNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.ui.ArbilTrackingTree;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeHelper
implements TreeHelper {
    private DefaultTreeModel localCorpusTreeModel;
    private DefaultTreeModel remoteCorpusTreeModel;
    private DefaultTreeModel localDirectoryTreeModel;
    private DefaultTreeModel favouritesTreeModel;
    private ArbilDataNode[] remoteCorpusNodes = new ArbilDataNode[0];
    private ArbilDataNode[] localCorpusNodes = new ArbilDataNode[0];
    private ArbilDataNode[] localFileNodes = new ArbilDataNode[0];
    private ArbilDataNode[] favouriteNodes = new ArbilDataNode[0];
    private boolean showHiddenFilesInTree = false;
    private MessageDialogHandler messageDialogHandler;
    private DataNodeLoader dataNodeLoader;
    protected final ArbilRootNode localCorpusRootNodeObject;
    protected final ArbilRootNode remoteCorpusRootNodeObject;
    protected final ArbilRootNode localDirectoryRootNodeObject;
    protected final ArbilRootNode favouritesRootNodeObject;

    public AbstractTreeHelper(MessageDialogHandler messageDialogHandler) {
        this.localCorpusRootNodeObject = new ArbilRootNode("Local corpus", ArbilIcons.getSingleInstance().directoryIcon, true){

            public ArbilDataNode[] getChildArray() {
                return AbstractTreeHelper.this.getLocalCorpusNodes();
            }
        };
        this.remoteCorpusRootNodeObject = new ArbilRootNode("Remote corpus", ArbilIcons.getSingleInstance().serverIcon, false){

            public ArbilDataNode[] getChildArray() {
                return AbstractTreeHelper.this.getRemoteCorpusNodes();
            }
        };
        this.localDirectoryRootNodeObject = new ArbilRootNode("Working Directories", ArbilIcons.getSingleInstance().computerIcon, true){

            public ArbilDataNode[] getChildArray() {
                return AbstractTreeHelper.this.getLocalFileNodes();
            }
        };
        this.favouritesRootNodeObject = new ArbilRootNode("Favourites", ArbilIcons.getSingleInstance().favouriteIcon, true){
            HashMap<String, ContainerNode> containerNodeMap;
            {
                this.containerNodeMap = new HashMap();
            }

            public ArbilNode[] getChildArray() {
                this.containerNodeMap = AbstractTreeHelper.this.groupTreeNodesByType(AbstractTreeHelper.this.getFavouriteNodes(), this.containerNodeMap);
                return this.containerNodeMap.values().toArray(new ArbilNode[0]);
            }
        };
        this.messageDialogHandler = messageDialogHandler;
    }

    protected final void initTrees() {
        this.initTreeModels();
    }

    protected void initTreeModels() {
        this.localCorpusTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(this.localCorpusRootNodeObject), true);
        this.remoteCorpusTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(this.remoteCorpusRootNodeObject), true);
        this.localDirectoryTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(this.localDirectoryRootNodeObject), true);
        this.favouritesTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(this.favouritesRootNodeObject), true);
    }

    @Override
    public int addDefaultCorpusLocations() {
        try {
            this.addLocations(this.getClass().getResourceAsStream("/nl/mpi/arbil/defaults/imdiLocations"));
            return this.remoteCorpusNodes.length;
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return 0;
        }
    }

    public int addDefaultCorpusLocationsOld() {
        HashSet<ArbilDataNode> remoteCorpusNodesSet = new HashSet<ArbilDataNode>();
        remoteCorpusNodesSet.addAll(Arrays.asList(this.remoteCorpusNodes));
        for (String currentUrlString : new String[]{"http://corpus1.mpi.nl/IMDI/metadata/IMDI.imdi", "http://corpus1.mpi.nl/qfs1/media-archive/Corpusstructure/MPI.imdi", "http://corpus1.mpi.nl/qfs1/media-archive/Corpusstructure/sign_language.imdi"}) {
            try {
                remoteCorpusNodesSet.add(this.dataNodeLoader.getArbilDataNode(null, new URI(currentUrlString)));
            }
            catch (URISyntaxException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        this.remoteCorpusNodes = remoteCorpusNodesSet.toArray(new ArbilDataNode[0]);
        return remoteCorpusNodesSet.size();
    }

    @Override
    public void saveLocations(ArbilDataNode[] nodesToAdd, ArbilDataNode[] nodesToRemove) {
        try {
            HashSet<String> locationsSet = new HashSet<String>();
            ArbilDataNode[][] arr$ = new ArbilDataNode[][]{this.remoteCorpusNodes, this.localCorpusNodes, this.localFileNodes, this.favouriteNodes};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ArbilDataNode[] arbilDataNodeArray;
                for (ArbilDataNode currentLocation : arbilDataNodeArray = arr$[i$]) {
                    locationsSet.add(currentLocation.getUrlString());
                }
            }
            if (nodesToAdd != null) {
                for (ArbilDataNode[] arbilDataNodeArray : nodesToAdd) {
                    if (arbilDataNodeArray == null) continue;
                    locationsSet.add(arbilDataNodeArray.getUrlString());
                }
            }
            if (nodesToRemove != null) {
                for (ArbilDataNode[] arbilDataNodeArray : nodesToRemove) {
                    locationsSet.remove(arbilDataNodeArray.getUrlString());
                }
            }
            ArrayList<String> locationsList = new ArrayList<String>();
            for (String currentLocation : locationsSet) {
                locationsList.add(URLDecoder.decode(currentLocation, "UTF-8"));
            }
            this.getSessionStorage().saveStringArray("locationsList", locationsList.toArray(new String[0]));
            System.out.println("saved locationsList");
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    @Override
    public final void loadLocationsList() {
        System.out.println("loading locationsList");
        String[] locationsArray = null;
        try {
            locationsArray = this.getSessionStorage().loadStringArray("locationsList");
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            this.messageDialogHandler.addMessageDialogToQueue("Could not find or load locations. Adding default locations.", "Error");
        }
        if (locationsArray != null) {
            ArrayList<ArbilDataNode> remoteCorpusNodesList = new ArrayList<ArbilDataNode>();
            ArrayList<ArbilDataNode> localCorpusNodesList = new ArrayList<ArbilDataNode>();
            ArrayList<ArbilDataNode> localFileNodesList = new ArrayList<ArbilDataNode>();
            ArrayList<ArbilDataNode> favouriteNodesList = new ArrayList<ArbilDataNode>();
            int failedLoads = 0;
            for (String currentLocationString : locationsArray) {
                URI currentLocation = null;
                try {
                    currentLocation = ArbilDataNodeService.conformStringToUrl(currentLocationString);
                }
                catch (URISyntaxException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                if (currentLocation == null) {
                    BugCatcherManager.getBugCatcher().logError("Could conform string to url: " + currentLocationString, null);
                    ++failedLoads;
                    continue;
                }
                try {
                    ArbilDataNode currentTreeObject = this.dataNodeLoader.getArbilDataNode(null, currentLocation);
                    if (currentTreeObject.isLocal()) {
                        if (currentTreeObject.isFavorite()) {
                            favouriteNodesList.add(currentTreeObject);
                            continue;
                        }
                        if (this.getSessionStorage().pathIsInsideCache(currentTreeObject.getFile())) {
                            if (!currentTreeObject.isMetaDataNode() || currentTreeObject.isChildNode()) continue;
                            localCorpusNodesList.add(currentTreeObject);
                            continue;
                        }
                        localFileNodesList.add(currentTreeObject);
                        continue;
                    }
                    remoteCorpusNodesList.add(currentTreeObject);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError("Failure in trying to load " + currentLocationString, ex);
                    ++failedLoads;
                }
            }
            if (failedLoads > 0) {
                this.messageDialogHandler.addMessageDialogToQueue("Failed to load " + failedLoads + " locations. See error log for details.", "Warning");
            }
            this.remoteCorpusNodes = remoteCorpusNodesList.toArray(new ArbilDataNode[0]);
            this.localCorpusNodes = localCorpusNodesList.toArray(new ArbilDataNode[0]);
            this.localFileNodes = localFileNodesList.toArray(new ArbilDataNode[0]);
            this.favouriteNodes = favouriteNodesList.toArray(new ArbilDataNode[0]);
        }
        this.showHiddenFilesInTree = this.getSessionStorage().loadBoolean("showHiddenFilesInTree", this.showHiddenFilesInTree);
    }

    @Override
    public void setShowHiddenFilesInTree(boolean showState) {
        this.showHiddenFilesInTree = showState;
        this.reloadNodesInTree((DefaultMutableTreeNode)this.localDirectoryTreeModel.getRoot());
        try {
            this.getSessionStorage().saveBoolean("showHiddenFilesInTree", this.showHiddenFilesInTree);
        }
        catch (Exception ex) {
            System.out.println("save showHiddenFilesInTree failed");
        }
    }

    @Override
    public void addLocations(List<URI> locations) {
        ArbilDataNode[] addedNodes = new ArbilDataNode[locations.size()];
        for (int i = 0; i < locations.size(); ++i) {
            URI addedLocation = locations.get(i);
            System.out.println("addLocation: " + addedLocation.toString());
            addedNodes[i] = this.dataNodeLoader.getArbilDataNode(null, addedLocation);
        }
        this.saveLocations(addedNodes, null);
        this.loadLocationsList();
    }

    @Override
    public void addLocations(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        LinkedList<URI> locationsList = new LinkedList<URI>();
        String location = reader.readLine();
        while (location != null) {
            try {
                URI uri = new URI(location);
                locationsList.add(uri);
            }
            catch (URISyntaxException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
            location = reader.readLine();
        }
        this.addLocations(locationsList);
    }

    @Override
    public void clearRemoteLocations() {
        for (ArbilDataNode removeNode : this.remoteCorpusNodes) {
            this.removeLocation(removeNode.getURI());
        }
    }

    @Override
    public boolean addLocationInteractive(URI addableLocation) {
        return this.addLocation(addableLocation);
    }

    @Override
    public boolean addLocation(URI addedLocation) {
        System.out.println("addLocation: " + addedLocation.toString());
        ArbilDataNode addedLocationObject = this.dataNodeLoader.getArbilDataNode(null, addedLocation);
        if (addedLocationObject != null) {
            this.saveLocations(new ArbilDataNode[]{addedLocationObject}, null);
            this.loadLocationsList();
            return true;
        }
        return false;
    }

    @Override
    public void removeLocation(ArbilDataNode removeObject) {
        if (removeObject != null) {
            this.saveLocations(null, new ArbilDataNode[]{removeObject});
            removeObject.removeFromAllContainers();
            this.loadLocationsList();
        }
    }

    @Override
    public void removeLocation(URI removeLocation) {
        System.out.println("removeLocation: " + removeLocation);
        this.removeLocation(this.dataNodeLoader.getArbilDataNode(null, removeLocation));
    }

    private void reloadNodesInTree(DefaultMutableTreeNode parentTreeNode) {
        Enumeration<TreeNode> childNodesEnum = parentTreeNode.children();
        while (childNodesEnum.hasMoreElements()) {
            this.reloadNodesInTree((DefaultMutableTreeNode)childNodesEnum.nextElement());
        }
        if (parentTreeNode.getUserObject() instanceof ArbilDataNode && ((ArbilDataNode)parentTreeNode.getUserObject()).isDataLoaded()) {
            ((ArbilDataNode)parentTreeNode.getUserObject()).reloadNode();
        }
    }

    @Override
    public boolean locationsHaveBeenAdded() {
        return this.localCorpusNodes.length > 0;
    }

    @Override
    public abstract void applyRootLocations();

    @Override
    public abstract void deleteNodes(Object var1);

    public void deleteChildNodes(ArbilDataNode parent, Collection<ArbilDataNode> children) {
        HashMap<ArbilDataNode, List<ArbilDataNode>> dataNodesDeleteList = new HashMap<ArbilDataNode, List<ArbilDataNode>>();
        HashMap<ArbilDataNode, List<String>> childNodeDeleteList = new HashMap<ArbilDataNode, List<String>>();
        HashMap<ArbilDataNode, List<ArbilDataNode>> cmdiLinksDeleteList = new HashMap<ArbilDataNode, List<ArbilDataNode>>();
        for (ArbilDataNode child : children) {
            this.determineDeleteFromParent(child, parent, childNodeDeleteList, dataNodesDeleteList, cmdiLinksDeleteList);
        }
        this.deleteNodesByChidXmlIdLink(childNodeDeleteList);
        this.deleteNodesByCorpusLink(dataNodesDeleteList);
        this.deleteCmdiLinks(cmdiLinksDeleteList);
    }

    protected void determineNodesToDelete(TreePath[] nodePaths, Map<ArbilDataNode, List<String>> childNodeDeleteList, Map<ArbilDataNode, List<ArbilDataNode>> dataNodesDeleteList, Map<ArbilDataNode, List<ArbilDataNode>> cmdiLinksDeleteList) {
        Vector<ArbilDataNode> dataNodesToRemove = new Vector<ArbilDataNode>();
        for (TreePath currentNodePath : nodePaths) {
            if (currentNodePath == null) continue;
            DefaultMutableTreeNode selectedTreeNode = (DefaultMutableTreeNode)currentNodePath.getLastPathComponent();
            Object userObject = selectedTreeNode.getUserObject();
            System.out.println("trying to delete: " + userObject);
            if (currentNodePath.getPath().length == 2) {
                System.out.println("removing by location");
                this.removeLocation((ArbilDataNode)selectedTreeNode.getUserObject());
                this.applyRootLocations();
            } else {
                System.out.println("deleting from parent");
                DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)selectedTreeNode.getParent();
                if (parentTreeNode != null) {
                    System.out.println("found parent to remove from");
                    ArbilDataNode parentDataNode = (ArbilDataNode)parentTreeNode.getUserObject();
                    ArbilDataNode childDataNode = (ArbilDataNode)selectedTreeNode.getUserObject();
                    this.determineDeleteFromParent(childDataNode, parentDataNode, childNodeDeleteList, dataNodesDeleteList, cmdiLinksDeleteList);
                }
            }
            dataNodesToRemove.add((ArbilDataNode)userObject);
            ((ArbilDataNode)userObject).getAllChildren(dataNodesToRemove);
        }
    }

    private void determineDeleteFromParent(ArbilDataNode childDataNode, ArbilDataNode parentDataNode, Map<ArbilDataNode, List<String>> childNodeDeleteList, Map<ArbilDataNode, List<ArbilDataNode>> dataNodesDeleteList, Map<ArbilDataNode, List<ArbilDataNode>> cmdiLinksDeleteList) {
        if (childDataNode.isChildNode()) {
            if (!childNodeDeleteList.containsKey(childDataNode.getParentDomNode())) {
                childNodeDeleteList.put(childDataNode.getParentDomNode(), new Vector());
            }
            if (childDataNode.isEmptyMetaNode()) {
                for (ArbilDataNode metaChildNode : childDataNode.getChildArray()) {
                    childNodeDeleteList.get(childDataNode.getParentDomNode()).add(metaChildNode.getURI().getFragment());
                }
            }
            childNodeDeleteList.get(childDataNode.getParentDomNode()).add(childDataNode.getURI().getFragment());
            childDataNode.removeFromAllContainers();
        } else if (parentDataNode.isCmdiMetaDataNode()) {
            if (!cmdiLinksDeleteList.containsKey(parentDataNode)) {
                cmdiLinksDeleteList.put(parentDataNode, new ArrayList());
            }
            cmdiLinksDeleteList.get(parentDataNode).add(childDataNode);
        } else {
            if (!dataNodesDeleteList.containsKey(parentDataNode)) {
                dataNodesDeleteList.put(parentDataNode, new Vector());
            }
            dataNodesDeleteList.get(parentDataNode).add(childDataNode);
        }
    }

    protected void deleteNodesByChidXmlIdLink(Map<ArbilDataNode, List<String>> childNodeDeleteList) {
        for (Map.Entry<ArbilDataNode, List<String>> deleteEntry : childNodeDeleteList.entrySet()) {
            ArbilDataNode currentParent = deleteEntry.getKey();
            System.out.println("deleting by child xml id link");
            ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
            boolean result = componentBuilder.removeChildNodes(currentParent, deleteEntry.getValue().toArray(new String[0]));
            if (result) {
                currentParent.invalidateThumbnails();
                currentParent.reloadNode();
                continue;
            }
            this.messageDialogHandler.addMessageDialogToQueue("Error deleting node, check the log file via the help menu for more information.", "Delete Node");
        }
    }

    protected void deleteNodesByCorpusLink(Map<ArbilDataNode, List<ArbilDataNode>> dataNodesDeleteList) {
        for (Map.Entry<ArbilDataNode, List<ArbilDataNode>> deleteEntry : dataNodesDeleteList.entrySet()) {
            System.out.println("deleting by corpus link");
            deleteEntry.getKey().deleteCorpusLink(deleteEntry.getValue().toArray(new ArbilDataNode[0]));
        }
    }

    protected void deleteCmdiLinks(Map<ArbilDataNode, List<ArbilDataNode>> cmdiLinks) {
        ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
        for (Map.Entry<ArbilDataNode, List<ArbilDataNode>> deleteEntry : cmdiLinks.entrySet()) {
            ArrayList<String> references = new ArrayList<String>(deleteEntry.getValue().size());
            for (ArbilDataNode node : deleteEntry.getValue()) {
                references.add(node.getUrlString());
            }
            if (componentBuilder.removeResourceProxyReferences(deleteEntry.getKey(), references)) {
                deleteEntry.getKey().reloadNode();
                continue;
            }
            this.messageDialogHandler.addMessageDialogToQueue("Error deleting node, check the log file via the help menu for more information.", "Delete Node");
        }
    }

    @Override
    public void jumpToSelectionInTree(boolean silent, ArbilDataNode cellDataNode) {
        for (ArbilDataNodeContainer container : cellDataNode.getRegisteredContainers()) {
            if (!(container instanceof ArbilTrackingTree)) continue;
            boolean found = false;
            if (cellDataNode.isChildNode()) {
                found = ((ArbilTrackingTree)container).jumpToNode(cellDataNode.getParentDomNode(), cellDataNode);
            }
            if (found) continue;
            ((ArbilTrackingTree)container).jumpToNode(null, cellDataNode);
        }
    }

    @Override
    public boolean isInFavouritesNodes(ArbilDataNode dataNode) {
        return Arrays.asList(this.favouriteNodes).contains(dataNode);
    }

    @Override
    public DefaultTreeModel getLocalCorpusTreeModel() {
        return this.localCorpusTreeModel;
    }

    @Override
    public DefaultTreeModel getRemoteCorpusTreeModel() {
        return this.remoteCorpusTreeModel;
    }

    @Override
    public DefaultTreeModel getLocalDirectoryTreeModel() {
        return this.localDirectoryTreeModel;
    }

    @Override
    public DefaultTreeModel getFavouritesTreeModel() {
        return this.favouritesTreeModel;
    }

    @Override
    public ArbilDataNode[] getRemoteCorpusNodes() {
        return this.remoteCorpusNodes;
    }

    @Override
    public ArbilDataNode[] getLocalCorpusNodes() {
        return this.localCorpusNodes;
    }

    @Override
    public ArbilDataNode[] getLocalFileNodes() {
        return this.localFileNodes;
    }

    @Override
    public ArbilDataNode[] getFavouriteNodes() {
        return this.favouriteNodes;
    }

    protected HashMap<String, ContainerNode> groupTreeNodesByType(ArbilDataNode[] favouriteNodes, HashMap<String, ContainerNode> containerNodeMap) {
        HashMap metaNodeMap = new HashMap();
        for (ArbilDataNode arbilDataNode : favouriteNodes) {
            String containerNodeLabel = "Other";
            if (arbilDataNode.isChildNode()) {
                String urlString = arbilDataNode.getUrlString();
                containerNodeLabel = urlString.substring(urlString.lastIndexOf(".") + 1);
                containerNodeLabel = containerNodeLabel.replaceFirst("\\([0-9]*\\)", "");
                if (arbilDataNode.isCmdiMetaDataNode()) {
                    ArbilTemplate nodeTemplate = arbilDataNode.getParentDomNode().nodeTemplate;
                    containerNodeLabel = nodeTemplate != null ? containerNodeLabel + " (" + nodeTemplate.getTemplateName() + ")" : containerNodeLabel + " (loading)";
                }
            } else if (arbilDataNode.isSession()) {
                containerNodeLabel = "Session";
            } else if (arbilDataNode.isCatalogue()) {
                containerNodeLabel = "Catalogue";
            } else if (arbilDataNode.isCmdiMetaDataNode()) {
                containerNodeLabel = arbilDataNode.nodeTemplate == null ? "Clarin Instance" : arbilDataNode.nodeTemplate.getTemplateName();
            }
            if (!metaNodeMap.containsKey(containerNodeLabel)) {
                metaNodeMap.put(containerNodeLabel, new HashSet());
            }
            ((HashSet)metaNodeMap.get(containerNodeLabel)).add(arbilDataNode);
        }
        HashMap<String, ContainerNode> containerNodeMapUpdated = new HashMap<String, ContainerNode>();
        for (Map.Entry filteredNodeEntry : metaNodeMap.entrySet()) {
            if (containerNodeMapUpdated.containsKey(filteredNodeEntry.getKey())) {
                containerNodeMapUpdated.get(filteredNodeEntry.getKey()).setChildNodes(((HashSet)filteredNodeEntry.getValue()).toArray(new ArbilDataNode[0]));
                continue;
            }
            if (containerNodeMap.containsKey(filteredNodeEntry.getKey())) {
                ContainerNode foundEntry = containerNodeMap.get(filteredNodeEntry.getKey());
                foundEntry.setChildNodes(((HashSet)filteredNodeEntry.getValue()).toArray(new ArbilDataNode[0]));
                containerNodeMapUpdated.put((String)filteredNodeEntry.getKey(), foundEntry);
                continue;
            }
            ContainerNode containerNode = new ContainerNode((String)filteredNodeEntry.getKey(), null, ((HashSet)filteredNodeEntry.getValue()).toArray(new ArbilDataNode[0]));
            containerNodeMapUpdated.put((String)filteredNodeEntry.getKey(), containerNode);
        }
        return containerNodeMapUpdated;
    }

    @Override
    public boolean isShowHiddenFilesInTree() {
        return this.showHiddenFilesInTree;
    }

    protected abstract SessionStorage getSessionStorage();

    protected MessageDialogHandler getMessageDialogHandler() {
        return this.messageDialogHandler;
    }

    public void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        this.dataNodeLoader = dataNodeLoaderInstance;
    }

    protected DataNodeLoader getDataNodeLoader() {
        return this.dataNodeLoader;
    }
}

