/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.HidePane;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.SvgElementEditor;
import nl.mpi.kinnate.ui.TableCellDragHandler;

public class MetadataPanel
extends JPanel {
    private ArbilTree arbilTree;
    private ArbilTableModel kinTableModel;
    private ArbilTableModel archiveTableModel;
    private JScrollPane kinTableScrollPane;
    private HidePane editorHidePane;
    private ArrayList<ArbilDataNode> metadataNodes = new ArrayList();
    private ArrayList<ArbilDataNode> archiveTreeNodes = new ArrayList();
    private ArrayList<ArbilDataNode> archiveRootNodes = new ArrayList();
    private ArrayList<SvgElementEditor> elementEditors = new ArrayList();
    private ArbilDataNodeLoader dataNodeLoader;
    private ContainerNode rootNode;

    public MetadataPanel(GraphPanel graphPanel, HidePane editorHidePane, TableCellDragHandler tableCellDragHandler, ArbilDataNodeLoader dataNodeLoader) {
        this.arbilTree = new ArbilTree();
        this.rootNode = new ContainerNode("links", null, new ArbilNode[0]);
        this.arbilTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode(this.rootNode)));
        this.kinTableModel = new ArbilTableModel();
        this.archiveTableModel = new ArbilTableModel();
        this.dataNodeLoader = dataNodeLoader;
        ArbilTable kinTable = new ArbilTable(this.kinTableModel, "Selected Nodes");
        ArbilTable archiveTable = new ArbilTable(this.archiveTableModel, "Selected Nodes");
        this.arbilTree.setCustomPreviewTable(archiveTable);
        kinTable.setTransferHandler((TransferHandler)tableCellDragHandler);
        kinTable.setDragEnabled(true);
        this.editorHidePane = editorHidePane;
        this.setLayout(new BorderLayout());
        this.kinTableScrollPane = new JScrollPane((Component)kinTable);
        JScrollPane archiveTableScrollPane = new JScrollPane((Component)archiveTable);
        this.add((Component)archiveTableScrollPane, "Center");
        this.add((Component)this.arbilTree, "Before");
    }

    public void removeAllEditors() {
        while (!this.elementEditors.isEmpty()) {
            this.editorHidePane.removeTab(this.elementEditors.remove(0));
        }
    }

    public void removeAllArbilDataNodeRows() {
        this.kinTableModel.removeAllArbilDataNodeRows();
        this.archiveTableModel.removeAllArbilDataNodeRows();
        for (ArbilDataNode arbilDataNode : this.metadataNodes) {
            if (!arbilDataNode.getParentDomNode().getNeedsSaveToDisk(false)) continue;
            this.dataNodeLoader.requestReload(arbilDataNode.getParentDomNode());
        }
        this.metadataNodes.clear();
    }

    public void addArbilDataNode(ArbilDataNode arbilDataNode) {
        this.archiveTableModel.addSingleArbilDataNode(arbilDataNode);
        this.archiveRootNodes.clear();
        this.metadataNodes.add(arbilDataNode);
    }

    public void addEntityDataNode(KinDiagramPanel kinDiagramPanel, EntityData entityData) {
        String entityPath = entityData.getEntityPath();
        System.out.println("entity path: " + entityPath);
        boolean metadataFileMissing = false;
        if (entityPath != null && entityPath.length() > 0) {
            try {
                ArbilDataNode arbilDataNode = this.dataNodeLoader.getArbilDataNode(null, new URI(entityPath));
                if (arbilDataNode.fileNotFound) {
                    metadataFileMissing = true;
                } else {
                    kinDiagramPanel.registerArbilNode(entityData.getUniqueIdentifier(), arbilDataNode);
                    this.kinTableModel.addSingleArbilDataNode(arbilDataNode);
                    this.metadataNodes.add(arbilDataNode);
                    if (entityData.archiveLinkArray != null) {
                        for (URI archiveLink : entityData.archiveLinkArray) {
                            ArbilDataNode archiveLinkNode = this.dataNodeLoader.getArbilDataNode(null, archiveLink);
                            this.archiveTableModel.addSingleArbilDataNode(archiveLinkNode);
                            this.archiveTreeNodes.add(archiveLinkNode);
                            this.archiveRootNodes.add(archiveLinkNode.getParentDomNode());
                            this.metadataNodes.add(archiveLinkNode);
                        }
                    }
                }
            }
            catch (URISyntaxException urise) {
                BugCatcherManager.getBugCatcher().logError((Exception)urise);
            }
        }
    }

    public void addTab(String labelString, SvgElementEditor elementEditor) {
        this.editorHidePane.addTab(labelString, elementEditor);
        this.elementEditors.add(elementEditor);
    }

    public void removeTab(Component elementEditor) {
        this.editorHidePane.removeTab(elementEditor);
    }

    public void updateEditorPane() {
        if (this.archiveTableModel.getArbilDataNodeCount() > 0) {
            this.editorHidePane.addTab("External Links", this);
        } else {
            this.removeTab(this);
        }
        if (this.kinTableModel.getArbilDataNodeCount() > 0) {
            this.editorHidePane.addTab("Kinship Data", this.kinTableScrollPane);
            this.editorHidePane.setSelectedComponent(this.kinTableScrollPane);
        } else {
            this.removeTab(this.kinTableScrollPane);
        }
        if (!this.archiveRootNodes.isEmpty()) {
            this.rootNode.setChildNodes(this.archiveRootNodes.toArray(new ArbilNode[0]));
            this.arbilTree.requestResort();
        }
        this.arbilTree.setVisible(!this.archiveRootNodes.isEmpty());
        this.editorHidePane.setHiddeState();
    }
}

