/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.window;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class WindowedDiagramManager
extends AbstractDiagramManager {
    private HashMap<JFrame, String> titleMap = new HashMap();
    private ArrayList<JFrame> diagramArray = new ArrayList();

    public WindowedDiagramManager(ApplicationVersionManager versionManager, ArbilWindowManager dialogHandler, SessionStorage sessionStorage, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, EntityCollection entityCollection) {
        super(versionManager, dialogHandler, sessionStorage, dataNodeLoader, treeHelper, entityCollection);
    }

    public void createApplicationWindow() {
    }

    protected void closeWindowAction(JFrame windowFrame) {
        if (this.diagramArray.size() == 1) {
            super.closeWindowAction(windowFrame);
        } else {
            int selectedIndex = this.diagramArray.indexOf(windowFrame);
            if (windowFrame instanceof SavePanel) {
                SavePanel savePanel = (SavePanel)((Object)windowFrame);
                String diagramTitle = this.getSavePanelTitle(selectedIndex);
                boolean userCanceled = this.offerUserToSave(savePanel, diagramTitle);
                if (!userCanceled) {
                    this.closeSavePanel(selectedIndex);
                }
            } else {
                this.closeSavePanel(selectedIndex);
            }
        }
    }

    public Component createDiagramContainer(Component diagramComponent) {
        String diagramTitle = diagramComponent.getName();
        JFrame diagramWindow = super.createDiagramWindow(diagramTitle, diagramComponent);
        this.titleMap.put(diagramWindow, diagramTitle);
        this.diagramArray.add(diagramWindow);
        return diagramWindow;
    }

    public void createDiagramSubPanel(String diagramTitle, Component diagramComponent, Component parentPanel) {
        JTabbedPane tabbedPane;
        JFrame diagramFame = (JFrame)parentPanel;
        Container currentComponent = diagramFame.getContentPane();
        if (!(currentComponent instanceof JTabbedPane)) {
            tabbedPane = new JTabbedPane();
            String savePanelTitle = currentComponent.getName();
            tabbedPane.addTab(savePanelTitle, currentComponent);
            diagramFame.setContentPane(tabbedPane);
        } else {
            tabbedPane = (JTabbedPane)currentComponent;
        }
        tabbedPane.addTab(diagramTitle, diagramComponent);
    }

    Component getSelectedDiagram() {
        throw new UnsupportedOperationException();
    }

    public void setSelectedDiagram(Component diagramComponent) {
        ((JFrame)diagramComponent).toFront();
    }

    public void setSelectedDiagram(int diagramIndex) {
        if (this.diagramArray.size() > diagramIndex) {
            this.setSelectedDiagram(this.diagramArray.get(diagramIndex));
        } else {
            this.setSelectedDiagram(null);
        }
    }

    public int getSavePanelIndex(Component parentComponent) {
        return this.diagramArray.indexOf(parentComponent);
    }

    public SavePanel getCurrentSavePanel(Component parentComponent) {
        return (SavePanel)((Object)parentComponent);
    }

    public String getSavePanelTitle(int selectedIndex) {
        return this.titleMap.get(this.diagramArray.get(selectedIndex));
    }

    Component getDiagramAt(int diagramIndex) {
        return this.diagramArray.get(diagramIndex);
    }

    public void closeSavePanel(int selectedIndex) {
        JFrame diagramFrame = this.diagramArray.get(selectedIndex);
        this.titleMap.remove(this.diagramArray.get(selectedIndex));
        this.diagramArray.remove(selectedIndex);
        diagramFrame.dispose();
        while (this.diagramArray.size() <= selectedIndex && selectedIndex > 0) {
            --selectedIndex;
        }
        this.setSelectedDiagram(selectedIndex);
    }

    public void setDiagramTitle(int diagramIndex, String diagramTitle) {
        this.titleMap.put(this.diagramArray.get(diagramIndex), diagramTitle);
        this.setWindowTitle(this.diagramArray.get(diagramIndex), diagramTitle);
    }

    public Component[] getAllDiagrams() {
        return this.diagramArray.toArray(new Component[0]);
    }
}

