/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.search.ArbilSearch;
import nl.mpi.arbil.ui.ArbilNodeSearchColumnComboBox;
import nl.mpi.arbil.ui.ArbilNodeSearchTermPanel;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.RemoteServerSearchTermPanel;
import nl.mpi.arbil.util.BugCatcherManager;

public class ArbilNodeSearchPanel
extends JPanel
implements ArbilDataNodeContainer {
    private ArbilNodeSearchPanel thisPanel = this;
    private JInternalFrame parentFrame;
    private ArbilTableModel resultsTableModel;
    private ArbilNode[] selectedNodes;
    private JPanel searchTermsPanel;
    private JPanel inputNodePanel;
    private JProgressBar searchProgressBar;
    private JButton searchButton;
    private JButton stopButton;
    private RemoteServerSearchTermPanel remoteServerSearchTerm = null;
    private ArbilSearch searchService;
    private Thread searchThread = null;
    private final Object searchThreadLock = new Object();

    public ArbilNodeSearchPanel(JInternalFrame parentFrameLocal, ArbilTableModel resultsTableModelLocal, ArbilNode[] localSelectedNodes) {
        this.parentFrame = parentFrameLocal;
        this.resultsTableModel = resultsTableModelLocal;
        this.selectedNodes = (ArbilNode[])localSelectedNodes.clone();
        this.searchTermsPanel = new JPanel();
        this.setLayout(new BoxLayout(this, 3));
        this.initNodePanel();
        this.add(this.inputNodePanel);
        this.initSearchTermsPanel();
        this.add(this.searchTermsPanel);
        JPanel buttonsProgressPanel = this.createButtonsProgressPanel();
        this.add(buttonsProgressPanel);
        this.hideFirstBooleanOption();
        this.parentFrame.pack();
    }

    private JPanel createButtonsProgressPanel() {
        JPanel buttonsProgressPanel = new JPanel();
        buttonsProgressPanel.setLayout(new BoxLayout(buttonsProgressPanel, 2));
        JButton addButton = new JButton();
        addButton.setText("+");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    System.out.println("adding new term");
                    ArbilNodeSearchPanel.this.stopSearch();
                    ArbilNodeSearchPanel.this.getSearchTermsPanel().add(new ArbilNodeSearchTermPanel(ArbilNodeSearchPanel.this.thisPanel));
                    ArbilNodeSearchPanel.this.hideFirstBooleanOption();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        buttonsProgressPanel.add(addButton);
        this.searchProgressBar = new JProgressBar();
        this.searchProgressBar.setString("");
        this.searchProgressBar.setStringPainted(true);
        buttonsProgressPanel.add(this.searchProgressBar);
        this.stopButton = new JButton();
        this.stopButton.setText("stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchPanel.this.stopSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.stopButton.setEnabled(false);
        buttonsProgressPanel.add(this.stopButton);
        this.searchButton = new JButton();
        this.searchButton.setText("search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchPanel.this.startSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        buttonsProgressPanel.add(this.searchButton);
        return buttonsProgressPanel;
    }

    private void initSearchTermsPanel() {
        this.searchTermsPanel.setLayout(new BoxLayout(this.searchTermsPanel, 3));
        boolean remoteSearch = false;
        for (ArbilNode arbilDataNode : this.selectedNodes) {
            if (arbilDataNode.isLocal()) continue;
            remoteSearch = true;
            break;
        }
        if (remoteSearch) {
            this.remoteServerSearchTerm = new RemoteServerSearchTermPanel(this);
            this.add(this.remoteServerSearchTerm);
        }
        this.searchTermsPanel.add(new ArbilNodeSearchTermPanel(this));
    }

    private void initNodePanel() {
        this.inputNodePanel = new JPanel();
        this.inputNodePanel.setLayout(new GridLayout());
        for (ArbilNode currentNode : this.selectedNodes) {
            JLabel currentLabel = new JLabel(currentNode.toString(), currentNode.getIcon(), 0);
            this.inputNodePanel.add(currentLabel);
        }
    }

    private void hideFirstBooleanOption() {
        boolean firstTerm = true;
        for (Component currentTermComp : this.searchTermsPanel.getComponents()) {
            ((ArbilNodeSearchTermPanel)currentTermComp).setBooleanVisible(!firstTerm);
            firstTerm = false;
        }
        this.searchTermsPanel.revalidate();
    }

    public void stopSearch() {
        System.out.println("stop search");
        this.hideFirstBooleanOption();
        if (this.searchService != null) {
            this.searchService.stopSearch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSearch() {
        Object object = this.searchThreadLock;
        synchronized (object) {
            while (this.searchThread != null && this.searchThread.isAlive()) {
                try {
                    this.searchThreadLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void startSearch() {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.stopSearch();
            this.waitForSearch();
        }
        System.out.println("start search");
        this.searchButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.resultsTableModel.removeAllArbilDataNodeRows();
        this.performSearch();
    }

    private void performSearch() {
        this.searchThread = new Thread((Runnable)new SearchThread(), "performSearch");
        this.searchThread.setPriority(4);
        this.searchThread.start();
    }

    public JPanel getSearchTermsPanel() {
        return this.searchTermsPanel;
    }

    public void dataNodeRemoved(ArbilNode dataNode) {
    }

    public void dataNodeIconCleared(ArbilNode dataNode) {
    }

    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
    }

    private class SearchThread
    implements Runnable,
    ArbilSearch.ArbilSearchListener {
        private SearchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ArbilNodeSearchPanel.this.searchThreadLock;
            synchronized (object) {
                try {
                    this.initSearchService();
                    this.prepareUI();
                    this.populateSearchTerms();
                    this.saveColumnOptions();
                    this.executeSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                this.finishUI();
                ArbilNodeSearchPanel.this.resultsTableModel.addArbilDataNodes(Collections.enumeration(ArbilNodeSearchPanel.this.searchService.getFoundNodes()));
                ArbilNodeSearchPanel.this.searchService.clearResults();
                ArbilNodeSearchPanel.this.searchThreadLock.notifyAll();
            }
        }

        private void initSearchService() {
            ArrayList<ArbilNodeSearchTermPanel> searchTerms = new ArrayList<ArbilNodeSearchTermPanel>(ArbilNodeSearchPanel.this.getComponentCount());
            for (Component component : ArbilNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                if (!(component instanceof ArbilNodeSearchTermPanel)) continue;
                searchTerms.add((ArbilNodeSearchTermPanel)component);
            }
            ArbilNodeSearchPanel.this.searchService = new ArbilSearch(Arrays.asList(ArbilNodeSearchPanel.this.selectedNodes), searchTerms, ArbilNodeSearchPanel.this.remoteServerSearchTerm, ArbilNodeSearchPanel.this.resultsTableModel, ArbilNodeSearchPanel.this, this);
        }

        private void populateSearchTerms() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        for (Component currentTermComp : ArbilNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                            ((ArbilNodeSearchTermPanel)currentTermComp).populateSearchTerm();
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        private void saveColumnOptions() {
            ArrayList<String> columns = new ArrayList<String>(ArbilNodeSearchPanel.this.searchTermsPanel.getComponentCount());
            for (Component currentTermComp : ArbilNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                ((ArbilNodeSearchTermPanel)currentTermComp).addCurrentSearchColumnOption();
                columns.add(((ArbilNodeSearchTermPanel)currentTermComp).searchFieldName);
            }
            ArbilNodeSearchColumnComboBox.addOptions(columns);
        }

        private void executeSearch() {
            ArbilNodeSearchPanel.this.searchService.splitLocalRemote();
            if (ArbilNodeSearchPanel.this.remoteServerSearchTerm != null) {
                ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(true);
                ArbilNodeSearchPanel.this.searchProgressBar.setString("connecting to server");
                ArbilNodeSearchPanel.this.searchService.fetchRemoteSearchResults();
                ArbilNodeSearchPanel.this.searchProgressBar.setString("");
                ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(false);
            }
            ArbilNodeSearchPanel.this.searchService.searchLocalNodes();
            if (ArbilNodeSearchPanel.this.searchService.isSearchStopped()) {
                ArbilNodeSearchPanel.this.searchProgressBar.setString("search canceled");
            } else {
                ArbilNodeSearchPanel.this.searchService.setTotalNodesToSearch(ArbilNodeSearchPanel.this.searchService.getTotalSearched());
            }
        }

        private void finishUI() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(false);
                        ArbilNodeSearchPanel.this.searchProgressBar.setValue(0);
                        ArbilNodeSearchPanel.this.searchProgressBar.setMaximum(1000);
                        ArbilNodeSearchPanel.this.searchButton.setEnabled(true);
                        ArbilNodeSearchPanel.this.stopButton.setEnabled(false);
                    }
                });
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        private void prepareUI() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(true);
                        ArbilNodeSearchPanel.this.searchProgressBar.setMinimum(0);
                        ArbilNodeSearchPanel.this.searchProgressBar.setMaximum(ArbilNodeSearchPanel.this.searchService.getTotalNodesToSearch());
                    }
                });
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        public void searchProgress(Object currentElement) {
            if (currentElement instanceof ArbilNode) {
                ArbilNodeSearchPanel.this.searchProgressBar.setString("searched: " + ArbilNodeSearchPanel.this.searchService.getTotalSearched() + "/" + ArbilNodeSearchPanel.this.searchService.getTotalNodesToSearch() + " found: " + ArbilNodeSearchPanel.this.searchService.getFoundNodes().size());
            }
            if (!ArbilNodeSearchPanel.this.parentFrame.isVisible() && ArbilNodeSearchPanel.this.searchService != null) {
                ArbilNodeSearchPanel.this.searchService.stopSearch();
            }
        }
    }
}

