/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BinaryMetadataReader;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.arbil.util.task.ArbilTaskListener;
import nl.mpi.arbil.util.task.DefaultArbilTask;
import nl.mpi.bcarchive.typecheck.DeepFileType;
import nl.mpi.bcarchive.typecheck.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMimeHashQueue
implements MimeHashQueue {
    private DataNodeLoader dataNodeLoader;
    private Hashtable processedFilesMTimes;
    private Hashtable<String, String[]> knownMimeTypes;
    private Hashtable<String, Vector<String>> md5SumToDuplicates;
    private Hashtable<String, String> pathToMd5Sums;
    private final Vector<ArbilDataNode> dataNodeQueue = new Vector();
    private boolean continueThread = false;
    private boolean checkResourcePermissions = true;
    private ScheduledThreadPoolExecutor mimeHashQueueThreadExecutor;
    private static FileType fileType;
    private static DeepFileType deepFileType;
    private SessionStorage sessionStorage;
    private MessageDialogHandler messageDialogHandler;
    private MimeHashQueueRunner runner;

    public void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        this.dataNodeLoader = dataNodeLoaderInstance;
    }

    protected Collection<ArbilTaskListener> getTaskListeners() {
        return Collections.emptySet();
    }

    private synchronized FileType getFileType() {
        if (fileType == null) {
            try {
                File configFile = this.sessionStorage.getTypeCheckerConfig();
                if (configFile != null) {
                    fileType = new FileType(configFile);
                }
            }
            catch (Exception ex) {
                this.messageDialogHandler.addMessageDialogToQueue("A custom typechecker file types configuration was found. However, it cannot be processed, therefore the default configuration will be used.", "Type checker configuration error");
                BugCatcherManager.getBugCatcher().logError("Error while retrieving or applying file checker configuration. Using default configuration.", ex);
            }
            if (fileType == null) {
                fileType = new FileType();
            }
            DefaultMimeHashQueue.fileType._cmdlineMode = true;
        }
        return fileType;
    }

    public void setMessageDialogHandler(MessageDialogHandler handler) {
        this.messageDialogHandler = handler;
    }

    public DefaultMimeHashQueue(SessionStorage sessionStorage) {
        System.out.println("MimeHashQueue init");
        this.sessionStorage = sessionStorage;
        this.checkResourcePermissions = sessionStorage.loadBoolean("checkResourcePermissions", true);
        this.continueThread = true;
    }

    protected void finalize() throws Throwable {
        this.continueThread = false;
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToQueue(ArbilDataNode dataNode) {
        this.startMimeHashQueueThread();
        if (dataNode.isLocal() && !dataNode.isMetaDataNode() && !dataNode.isDirectory() || dataNode.isChildNode() && dataNode.hasResource()) {
            Vector<ArbilDataNode> vector = this.dataNodeQueue;
            synchronized (vector) {
                if (!this.dataNodeQueue.contains(dataNode)) {
                    dataNode.setTypeCheckerState(MimeHashQueue.TypeCheckerState.IN_QUEUE);
                    this.dataNodeQueue.add(dataNode);
                    this.dataNodeQueue.notifyAll();
                }
            }
        }
    }

    @Override
    public synchronized void startMimeHashQueueThread() {
        if (this.mimeHashQueueThreadExecutor == null) {
            this.mimeHashQueueThreadExecutor = new ScheduledThreadPoolExecutor(1){

                protected void beforeExecute(Thread t, Runnable r) {
                    DefaultMimeHashQueue.this.beforeExecuteThread(t, r);
                }

                protected void afterExecute(Runnable r, Throwable t) {
                    DefaultMimeHashQueue.this.afterExecuteThread(r, t);
                }

                public ThreadFactory getThreadFactory() {
                    return new ThreadFactory(){

                        public Thread newThread(Runnable r) {
                            Thread mimeHashQueueThread = new Thread(r, "MimeHashQueue");
                            mimeHashQueueThread.setPriority(1);
                            return mimeHashQueueThread;
                        }
                    };
                }
            };
            this.runner = new MimeHashQueueRunner();
            this.mimeHashQueueThreadExecutor.submit(this.runner);
        }
    }

    protected void beforeExecuteThread(Thread t, Runnable r) {
    }

    protected void afterExecuteThread(Runnable r, Throwable t) {
    }

    @Override
    public void stopMimeHashQueueThread() {
        this.mimeHashQueueThreadExecutor.shutdownNow();
    }

    @Override
    public synchronized void terminateQueue() {
        if (this.runner != null) {
            this.stopMimeHashQueueThread();
            this.runner.checkSaveChanges();
            this.runner = null;
        }
    }

    private URI getNodeURI(ArbilDataNode dataNode) {
        if (dataNode.isResourceSet()) {
            return dataNode.getFullResourceURI();
        }
        try {
            return new URI(dataNode.getURI().getScheme(), dataNode.getURI().getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return null;
        }
    }

    private static String getFileSizeString(File targetFile) {
        return targetFile.length() / 1024L + "KB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMimeType(URI fileUri) {
        String mpiMimeType = null;
        String typeCheckerMessage = null;
        boolean deep = false;
        if (new File(fileUri).exists()) {
            InputStream inputStream = null;
            try {
                inputStream = fileUri.toURL().openStream();
                if (inputStream != null) {
                    typeCheckerMessage = deep ? deepFileType.checkStream(inputStream, fileUri.toString()) : this.getFileType().checkStream(inputStream, fileUri.toString());
                }
                mpiMimeType = FileType.resultToMPIType(typeCheckerMessage);
            }
            catch (Exception ioe) {
                System.out.println("Cannot read file at URL: " + fileUri + " ioe: " + ioe.getMessage());
                BugCatcherManager.getBugCatcher().logError(ioe);
                if (typeCheckerMessage == null) {
                    typeCheckerMessage = "I/O Exception: " + ioe.getMessage();
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            }
            System.out.println(mpiMimeType);
        }
        String[] resultArray = new String[]{mpiMimeType, typeCheckerMessage};
        this.knownMimeTypes.put(fileUri.toString(), resultArray);
        return resultArray;
    }

    @Override
    public boolean isCheckResourcePermissions() {
        return this.checkResourcePermissions;
    }

    @Override
    public void setCheckResourcePermissions(boolean checkResourcePermissions) {
        this.checkResourcePermissions = checkResourcePermissions;
    }

    static {
        deepFileType = new DeepFileType();
    }

    private class MimeHashQueueRunner
    implements Runnable {
        private boolean changedSinceLastSave = false;
        private ArbilDataNode currentDataNode;
        private int processed;

        private MimeHashQueueRunner() {
        }

        public void run() {
            System.out.println("MimeHashQueue run");
            this.loadMd5sumIndex();
            while (DefaultMimeHashQueue.this.continueThread) {
                this.waitForNode();
                try {
                    this.processQueueWithTask();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            System.out.println("MimeHashQueue stop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForNode() {
            Vector vector = DefaultMimeHashQueue.this.dataNodeQueue;
            synchronized (vector) {
                try {
                    while (DefaultMimeHashQueue.this.dataNodeQueue.isEmpty()) {
                        DefaultMimeHashQueue.this.dataNodeQueue.wait(60000L);
                        if (!DefaultMimeHashQueue.this.dataNodeQueue.isEmpty()) continue;
                        this.checkSaveChanges();
                        DefaultMimeHashQueue.this.dataNodeQueue.wait();
                    }
                }
                catch (InterruptedException ie) {
                    DefaultMimeHashQueue.this.continueThread = false;
                }
            }
        }

        public synchronized void checkSaveChanges() {
            if (this.isChangedSinceLastSave()) {
                this.saveMd5sumIndex();
                this.setChangedSinceLastSave(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueueWithTask() throws InterruptedException {
            DefaultArbilTask task = new DefaultArbilTask("Checking filetypes", "Checking filetypes", "%1$d/%2$d files", DefaultMimeHashQueue.this.getTaskListeners());
            task.setIndeterminate(false);
            this.processed = 0;
            task.start();
            try {
                this.processQueue(task);
            }
            finally {
                task.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue(DefaultArbilTask task) {
            while (!DefaultMimeHashQueue.this.dataNodeQueue.isEmpty() && DefaultMimeHashQueue.this.continueThread) {
                Vector vector = DefaultMimeHashQueue.this.dataNodeQueue;
                synchronized (vector) {
                    this.currentDataNode = (ArbilDataNode)DefaultMimeHashQueue.this.dataNodeQueue.remove(0);
                }
                if (task != null) {
                    task.setProgressValue(++this.processed);
                    task.setTargetValue(this.processed + DefaultMimeHashQueue.this.dataNodeQueue.size());
                    task.setStatus("Checking file " + this.currentDataNode.toString());
                }
                this.currentDataNode.setTypeCheckerState(MimeHashQueue.TypeCheckerState.IN_PROCESS);
                if (!this.currentDataNode.isMetaDataNode()) {
                    this.addFileAndExifFields();
                }
                if (this.currentDataNode.hasResource() && !this.currentDataNode.hasLocalResource()) {
                    this.checkServerPermissions();
                } else {
                    this.checkMimeTypeForCurrentNode();
                }
                if (!this.currentDataNode.getTypeCheckerState().equals((Object)MimeHashQueue.TypeCheckerState.ERROR)) {
                    this.currentDataNode.setTypeCheckerState(MimeHashQueue.TypeCheckerState.CHECKED);
                }
                this.currentDataNode.clearIcon();
            }
        }

        private synchronized void setChangedSinceLastSave(boolean changed) {
            this.changedSinceLastSave = changed;
        }

        private synchronized boolean isChangedSinceLastSave() {
            return this.changedSinceLastSave;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void checkMimeTypeForCurrentNode() {
            File currentFile;
            URI currentPathURI = DefaultMimeHashQueue.this.getNodeURI(this.currentDataNode);
            if (currentPathURI != null && currentPathURI.toString().length() > 0 && (currentFile = new File(currentPathURI)).exists()) {
                ArbilDataNode currentNodeObject;
                long previousMTime = 0L;
                if (DefaultMimeHashQueue.this.processedFilesMTimes.containsKey(currentPathURI.toString())) {
                    previousMTime = (Long)DefaultMimeHashQueue.this.processedFilesMTimes.get(currentPathURI.toString());
                }
                long currentMTime = currentFile.lastModified();
                String[] lastCheckedMimeArray = (String[])DefaultMimeHashQueue.this.knownMimeTypes.get(currentPathURI.toString());
                ArbilDataNode arbilDataNode = currentNodeObject = this.currentDataNode;
                synchronized (arbilDataNode) {
                    if (previousMTime != currentMTime || lastCheckedMimeArray == null) {
                        this.currentDataNode.setMimeType(DefaultMimeHashQueue.this.getMimeType(currentPathURI));
                        this.currentDataNode.hashString = this.getHash(currentPathURI, this.currentDataNode.getURI());
                        DefaultMimeHashQueue.this.processedFilesMTimes.put(currentPathURI.toString(), currentMTime);
                        this.setChangedSinceLastSave(true);
                    } else {
                        this.currentDataNode.hashString = (String)DefaultMimeHashQueue.this.pathToMd5Sums.get(currentPathURI.toString());
                        this.currentDataNode.setMimeType(lastCheckedMimeArray);
                    }
                    this.updateAutoFields(this.currentDataNode, currentFile);
                    this.updateIconsToMatchingFileNodes(currentPathURI);
                }
            }
        }

        private void addFileAndExifFields() {
            File fileObject;
            if (!this.currentDataNode.isMetaDataNode() && (fileObject = this.currentDataNode.getFile()) != null && fileObject.exists()) {
                try {
                    ArbilField[] exifFields;
                    int currentFieldId = 1;
                    ArbilField sizeField = new ArbilField(currentFieldId++, this.currentDataNode, "Size", DefaultMimeHashQueue.getFileSizeString(fileObject), 0, false);
                    this.currentDataNode.addField(sizeField);
                    Date mtime = new Date(fileObject.lastModified());
                    String mTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mtime);
                    ArbilField dateField = new ArbilField(currentFieldId++, this.currentDataNode, "last modified", mTimeString, 0, false);
                    this.currentDataNode.addField(dateField);
                    for (ArbilField currentField : exifFields = new BinaryMetadataReader().getExifMetadata(this.currentDataNode, currentFieldId)) {
                        this.currentDataNode.addField(currentField);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(this.currentDataNode.getUrlString() + "\n" + fileObject.getAbsolutePath(), ex);
                }
            }
        }

        private void checkServerPermissions() {
            if (DefaultMimeHashQueue.this.checkResourcePermissions) {
                try {
                    HttpURLConnection resourceConnection = (HttpURLConnection)this.currentDataNode.getFullResourceURI().toURL().openConnection();
                    resourceConnection.setRequestMethod("HEAD");
                    resourceConnection.setRequestProperty("Connection", "Close");
                    this.currentDataNode.resourceFileServerResponse = resourceConnection.getResponseCode();
                    this.currentDataNode.fileNotFound = this.currentDataNode.resourceFileServerResponse == 404 || this.currentDataNode.resourceFileServerResponse == 403 || this.currentDataNode.resourceFileServerResponse == 301;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }

        private void loadMd5sumIndex() {
            try {
                DefaultMimeHashQueue.this.knownMimeTypes = (Hashtable)DefaultMimeHashQueue.this.sessionStorage.loadObject("knownMimeTypesV2");
                DefaultMimeHashQueue.this.pathToMd5Sums = (Hashtable)DefaultMimeHashQueue.this.sessionStorage.loadObject("pathToMd5Sums");
                DefaultMimeHashQueue.this.md5SumToDuplicates = (Hashtable)DefaultMimeHashQueue.this.sessionStorage.loadObject("md5SumToDuplicates");
                DefaultMimeHashQueue.this.processedFilesMTimes = (Hashtable)DefaultMimeHashQueue.this.sessionStorage.loadObject("processedFilesMTimesV2");
            }
            catch (Exception ex) {
                DefaultMimeHashQueue.this.knownMimeTypes = new Hashtable();
                DefaultMimeHashQueue.this.pathToMd5Sums = new Hashtable();
                DefaultMimeHashQueue.this.processedFilesMTimes = new Hashtable();
                DefaultMimeHashQueue.this.md5SumToDuplicates = new Hashtable();
            }
        }

        private void saveMd5sumIndex() {
            try {
                DefaultMimeHashQueue.this.sessionStorage.saveObject(DefaultMimeHashQueue.this.knownMimeTypes, "knownMimeTypesV2");
                DefaultMimeHashQueue.this.sessionStorage.saveObject(DefaultMimeHashQueue.this.pathToMd5Sums, "pathToMd5Sums");
                DefaultMimeHashQueue.this.sessionStorage.saveObject(DefaultMimeHashQueue.this.processedFilesMTimes, "processedFilesMTimesV2");
                DefaultMimeHashQueue.this.sessionStorage.saveObject(DefaultMimeHashQueue.this.md5SumToDuplicates, "md5SumToDuplicates");
            }
            catch (IOException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }

        private void updateAutoFields(ArbilDataNode currentDataNode, File resourceFile) {
            String[] currentNodeFieldNames = currentDataNode.getFields().keySet().toArray(new String[0]);
            for (String[] autoFields : currentDataNode.getNodeTemplate().getAutoFieldsArray()) {
                int indexOfChar;
                String fieldPath = autoFields[0];
                String fileAttribute = autoFields[1];
                String autoValue = null;
                if (fileAttribute.equals("Size")) {
                    if (!currentDataNode.resourceFileNotFound()) {
                        autoValue = DefaultMimeHashQueue.getFileSizeString(resourceFile);
                    }
                } else if (fileAttribute.equals("MpiMimeType")) {
                    autoValue = currentDataNode.mpiMimeType;
                } else if (fileAttribute.equals("FileType") && (autoValue = FileType.resultToMimeType((String)currentDataNode.typeCheckerMessage)) != null && (indexOfChar = autoValue.indexOf("/")) > 0) {
                    autoValue = autoValue.substring(0, indexOfChar);
                }
                if (autoValue == null) continue;
                for (String currentKeyString : currentNodeFieldNames) {
                    ArbilField[] currentFieldArray;
                    if (!fieldPath.endsWith(currentKeyString) || (currentFieldArray = currentDataNode.getFields().get(currentKeyString)) == null || !currentFieldArray[0].getGenericFullXmlPath().equals(fieldPath)) continue;
                    for (ArbilField currentField : currentFieldArray) {
                        currentField.setFieldValue(autoValue, true, true);
                    }
                }
            }
        }

        private void updateIconsToMatchingFileNodes(URI currentPathURI) {
            int matchesInCache = 0;
            int matchesLocalFileSystem = 0;
            int matchesRemote = 0;
            String currentMd5Sum = (String)DefaultMimeHashQueue.this.pathToMd5Sums.get(currentPathURI.toString());
            if (currentMd5Sum != null) {
                Vector duplicatesPaths = (Vector)DefaultMimeHashQueue.this.md5SumToDuplicates.get(currentMd5Sum);
                Vector<ArbilDataNode> relevantDataNodes = new Vector<ArbilDataNode>();
                Enumeration duplicatesPathEnum = duplicatesPaths.elements();
                while (duplicatesPathEnum.hasMoreElements()) {
                    String currentDupPath = (String)duplicatesPathEnum.nextElement();
                    try {
                        File currentFile = new File(new URI(currentDupPath));
                        if (!currentFile.exists()) continue;
                        ArbilDataNode dataNode = DefaultMimeHashQueue.this.dataNodeLoader.getArbilDataNodeOnlyIfLoaded(new URI(currentDupPath));
                        if (dataNode != null) {
                            relevantDataNodes.add(dataNode);
                        }
                        if (DefaultMimeHashQueue.this.sessionStorage.pathIsInsideCache(currentFile)) {
                            ++matchesInCache;
                        } else {
                            ++matchesLocalFileSystem;
                        }
                        matchesRemote = 0;
                    }
                    catch (Exception e) {}
                }
                Enumeration relevantNodeEnum = relevantDataNodes.elements();
                while (relevantNodeEnum.hasMoreElements()) {
                    ArbilDataNode currentDataNode = (ArbilDataNode)relevantNodeEnum.nextElement();
                    currentDataNode.matchesInCache = matchesInCache;
                    currentDataNode.matchesLocalFileSystem = matchesLocalFileSystem;
                    currentDataNode.matchesRemote = matchesRemote;
                    currentDataNode.clearIcon();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHash(URI fileUri, URI nodeUri) {
            long startTime = System.currentTimeMillis();
            String hashString = null;
            FileInputStream is = null;
            try {
                int i;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                StringBuilder hexString = new StringBuilder();
                is = new FileInputStream(new File(fileUri));
                byte[] buff = new byte[1024];
                while ((i = is.read(buff)) > 0) {
                    digest.update(buff, 0, i);
                    long downloadDelay = System.currentTimeMillis() - startTime;
                    if (downloadDelay > 100L) {
                        throw new Exception("reading file for md5sum is taking too long (" + downloadDelay + ") skipping the file: " + fileUri);
                    }
                    startTime = System.currentTimeMillis();
                }
                byte[] md5sum = digest.digest();
                for (i = 0; i < md5sum.length; ++i) {
                    hexString.append(Integer.toHexString(256 + (md5sum[i] & 0xFF)).substring(1));
                }
                hashString = hexString.toString();
            }
            catch (Exception ex) {
                System.out.println("failed to created hash: " + ex.getMessage());
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        System.out.println("Failed to close input stream for: " + fileUri);
                    }
                }
            }
            if (hashString != null) {
                DefaultMimeHashQueue.this.pathToMd5Sums.put(fileUri.toString(), hashString);
                Object matchingNodes = DefaultMimeHashQueue.this.md5SumToDuplicates.get(hashString);
                if (matchingNodes != null) {
                    if (!((Vector)matchingNodes).contains(nodeUri.toString())) {
                        Enumeration otherNodesEnum = ((Vector)matchingNodes).elements();
                        while (otherNodesEnum.hasMoreElements()) {
                            Object currentElement = otherNodesEnum.nextElement();
                            Object currentNode = DefaultMimeHashQueue.this.processedFilesMTimes.get(currentElement.toString());
                            if (!(currentNode instanceof ArbilDataNode)) continue;
                            ((ArbilDataNode)currentNode).clearIcon();
                        }
                        ((Vector)matchingNodes).add(fileUri.toString());
                    }
                } else {
                    Vector<String> nodeVector = new Vector<String>(1);
                    nodeVector.add(nodeUri.toString());
                    DefaultMimeHashQueue.this.md5SumToDuplicates.put(hashString, nodeVector);
                }
            }
            return hashString;
        }
    }
}

