/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.util.ArrayList;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImportLineStructure {
    int gedcomLevel = 0;
    String currentID = null;
    String entityType = null;
    boolean isFileHeader = false;
    boolean incompleteLine = false;
    private int currentFieldIndex = 0;
    ArrayList<FieldEntry> fieldEntryList = new ArrayList();
    ArrayList<RelationEntry> relationEntryList = new ArrayList();

    public ImportLineStructure(String lineString, ArrayList<String> gedcomLevelStrings) {
    }

    protected void addFieldEntry(String currentName, String lineContents) throws ImportException {
        this.fieldEntryList.add(new FieldEntry(currentName, lineContents));
    }

    protected void addRelationEntry(String egoIdString, String alterIdString, DataTypes.RelationType relationType, String customType) throws ImportException {
        this.relationEntryList.add(new RelationEntry(egoIdString, alterIdString, relationType, customType));
    }

    protected FieldEntry getCurrentField() {
        return this.fieldEntryList.get(this.currentFieldIndex);
    }

    protected void moveToNextField() {
        ++this.currentFieldIndex;
    }

    protected boolean hasCurrentField() {
        return this.currentFieldIndex < this.fieldEntryList.size();
    }

    public RelationEntry[] getRelationList() {
        return this.relationEntryList.toArray(new RelationEntry[0]);
    }

    public String getCurrentID() throws ImportException {
        if (this.currentID == null) {
            throw new ImportException("CurrentID has not been set");
        }
        return this.currentID;
    }

    public String getCurrentName() throws ImportException {
        if (this.getCurrentField().currentName == null) {
            throw new ImportException("CurrentName has not been set");
        }
        return this.getCurrentField().currentName;
    }

    public int getGedcomLevel() {
        return this.gedcomLevel;
    }

    public boolean hasLineContents() {
        return this.hasCurrentField() && this.getCurrentField().lineContents != null;
    }

    public String getLineContents() throws ImportException {
        if (!this.hasCurrentField() || this.getCurrentField().lineContents == null) {
            throw new ImportException("LineContents has not been set");
        }
        return this.getCurrentField().lineContents;
    }

    public String getEscapedLineContents() throws ImportException {
        return this.getLineContents();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getProfileForEntityType(String individualTypeProfile, String otherTypeProfile) {
        if (!this.isFileHeader) {
            return individualTypeProfile;
        }
        return otherTypeProfile;
    }

    public boolean isFileHeader() {
        return this.isFileHeader;
    }

    public boolean isContinueLine() {
        return false;
    }

    public boolean isContinueLineBreak() {
        return false;
    }

    public boolean isEndOfFileMarker() {
        return false;
    }

    public boolean isIncompleteLine() {
        return this.incompleteLine;
    }

    abstract boolean isRelation();

    protected class FieldEntry {
        protected String lineContents = null;
        protected String currentName = null;

        protected FieldEntry(String currentName, String lineContents) throws ImportException {
            if (currentName == null) {
                throw new ImportException("Cannot have null names to a field.");
            }
            this.currentName = currentName.trim();
            if (lineContents != null) {
                this.lineContents = lineContents;
            }
        }
    }

    protected class RelationEntry {
        protected String egoIdString;
        protected String alterIdString;
        protected DataTypes.RelationType relationType;
        protected String customType;

        public RelationEntry(String egoIdString, String alterIdString, DataTypes.RelationType relationType, String customType) {
            this.egoIdString = egoIdString;
            this.alterIdString = alterIdString;
            this.relationType = relationType;
            this.customType = customType;
        }
    }
}

