/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

public class GraphPanelSize {
    public boolean autoSize = true;
    private int preferedWidth = 800;
    private int preferedHeight = 600;
    private int defaultVerticalSpacing = 100;
    private int defaultHorizontalSpacing = 200;
    String[][] preferredSizeArray = new String[][]{{"352 x 288", "352", "288"}, {"640 x 480", "640", "480"}, {"800 x 600", "800", "600"}, {"1024 x 768", "1024", "768"}};

    public String[] getPreferredSizes() {
        String[] returnArray = new String[this.preferredSizeArray.length + 1];
        for (int currentCount = 0; currentCount < this.preferredSizeArray.length; ++currentCount) {
            returnArray[currentCount] = this.preferredSizeArray[currentCount][0];
        }
        returnArray[this.preferredSizeArray.length] = "Auto";
        return returnArray;
    }

    public void setSize(String selectedSize) {
        if ("Auto".equals(selectedSize)) {
            this.autoSize = true;
        } else {
            for (String[] currentEntry : this.preferredSizeArray) {
                if (!selectedSize.equals(currentEntry[0])) continue;
                this.preferedWidth = Integer.valueOf(currentEntry[1]);
                this.preferedHeight = Integer.valueOf(currentEntry[2]);
            }
        }
    }

    public int getWidth(int gridWidth, int hSpacing) {
        if (this.autoSize) {
            return gridWidth * hSpacing + hSpacing * 2;
        }
        return this.preferedWidth;
    }

    public int getHeight(int gridHeight, int vSpacing) {
        if (this.autoSize) {
            return gridHeight * vSpacing + vSpacing * 2;
        }
        return this.preferedHeight;
    }

    public int getVerticalSpacing() {
        return this.defaultVerticalSpacing;
    }

    public int getHorizontalSpacing() {
        return this.defaultHorizontalSpacing;
    }
}

