/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class SamplesFileMenu
extends JMenu
implements ActionListener {
    private final AbstractDiagramManager diagramWindowManager;
    private final MessageDialogHandler dialogHandler;
    private final Component parentComponent;

    public SamplesFileMenu(AbstractDiagramManager diagramWindowManager, MessageDialogHandler dialogHandler, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.dialogHandler = dialogHandler;
        this.parentComponent = parentComponent;
        this.addSampleToMenu("Freeform Diagram Syntax", "FreeformDiagramSyntax.svg");
        this.addSampleToMenu("Query Diagram Syntax", "QueryDiagramSyntax.svg");
        this.addSampleToMenu("Hawaiian Kin Terms", "HawaiianKinTerms.svg");
        this.addSampleToMenu("Japanese Kin Terms", "JapaneseKinTerms.svg");
        this.addSampleToMenu("Swedish Kin Terms", "SwedishKinTerms.svg");
        this.addSampleToMenu("Named Transient Entities", "NamedTransientEntities.svg");
        this.addSampleToMenu("Matrimonial Ring Examples", "MatrimonialRings.svg");
        this.addSampleToMenu("Charles II of Spain", "Charles_II_of_Spain.svg");
        this.addSampleToMenu("Haemophilia in European Royalty", "HaemophiliaEuropeanRoyalty.svg");
    }

    private void addSampleToMenu(String menuText, String sampleFileString) {
        String currentFilePath = SamplesFileMenu.class.getResource("/svgsamples/" + sampleFileString).toString();
        JMenuItem currentMenuItem = new JMenuItem(menuText);
        currentMenuItem.setActionCommand(currentFilePath);
        currentMenuItem.addActionListener(this);
        this.add(currentMenuItem);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            URI sampleFile = new URI(e.getActionCommand());
            if (e.getSource() instanceof JMenuItem) {
                String sampleName = ((JMenuItem)e.getSource()).getText();
                Dimension parentSize = this.parentComponent.getSize();
                Point parentLocation = this.parentComponent.getLocation();
                int offset = 10;
                Rectangle windowRectangle = new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset);
                this.diagramWindowManager.openDiagram(sampleName, sampleFile, false, windowRectangle);
            }
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.dialogHandler.addMessageDialogToQueue("Failed to load sample", "Sample Diagram");
        }
    }
}

