/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.relationsettings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.kintypeeditor.ArrayListCellRenderer;
import nl.mpi.kinnate.ui.kintypeeditor.CheckBoxRenderer;
import nl.mpi.kinnate.ui.relationsettings.ColourCellEditor;
import nl.mpi.kinnate.ui.relationsettings.NumberSpinnerEditor;
import nl.mpi.kinnate.ui.relationsettings.RelationTypesTableModel;

public class RelationSettingsPanel
extends JPanel
implements ActionListener {
    private DataStoreSvg dataStoreSvg;
    private RelationTypesTableModel relationTypesTableModel;
    private ArbilWindowManager dialogHandler;
    private final String Scan_For_Types = "Scan For Types";

    public RelationSettingsPanel(String panelName, SavePanel savePanel, DataStoreSvg dataStoreSvg, ArbilWindowManager dialogHandler) {
        this.dataStoreSvg = dataStoreSvg;
        this.dialogHandler = dialogHandler;
        this.setName(panelName);
        this.setLayout(new BorderLayout());
        JButton deleteButton = new JButton("Delete Selected");
        JButton scanButton = new JButton("Scan For Types");
        scanButton.setEnabled(true);
        scanButton.setActionCommand("scan");
        scanButton.addActionListener(this);
        this.relationTypesTableModel = new RelationTypesTableModel(savePanel, dataStoreSvg, deleteButton);
        JTable kinTypeTable = new JTable(this.relationTypesTableModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 3 && row < this.getRowCount() - 1) {
                    DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            JPanel panel = new JPanel();
                            try {
                                panel.setBackground(Color.decode(value.toString()));
                            }
                            catch (NumberFormatException exception) {
                                // empty catch block
                            }
                            return panel;
                        }
                    };
                    return cellRenderer;
                }
                TableCellRenderer standardCellRenderer = super.getCellRenderer(row, column);
                return standardCellRenderer;
            }
        };
        TableColumn columnRelationType = kinTypeTable.getColumnModel().getColumn(2);
        JComboBox<Object> relationTypeComboBox = new JComboBox<Object>(this.relationTypesTableModel.getValueRangeAt(2).toArray());
        CheckBoxRenderer relationTypeCheckBoxRenderer = new CheckBoxRenderer(this.relationTypesTableModel, relationTypeComboBox);
        relationTypeComboBox.addActionListener(relationTypeCheckBoxRenderer);
        relationTypeComboBox.setRenderer(relationTypeCheckBoxRenderer);
        columnRelationType.setCellEditor(relationTypeCheckBoxRenderer);
        columnRelationType.setCellRenderer(new ArrayListCellRenderer());
        kinTypeTable.getColumnModel().getColumn(3).setCellEditor(new ColourCellEditor(kinTypeTable));
        kinTypeTable.getColumnModel().getColumn(4).setCellEditor(new NumberSpinnerEditor(this.relationTypesTableModel));
        kinTypeTable.getColumnModel().getColumn(5).setCellEditor(new NumberSpinnerEditor(this.relationTypesTableModel));
        TableColumn columnCurveLineOrientation = kinTypeTable.getColumnModel().getColumn(6);
        JComboBox<String> comboBoxCurveLineOrientation = new JComboBox<String>();
        for (RelationTypeDefinition.CurveLineOrientation curveLineOrientation : RelationTypeDefinition.CurveLineOrientation.values()) {
            comboBoxCurveLineOrientation.addItem(curveLineOrientation.name());
        }
        columnCurveLineOrientation.setCellEditor(new DefaultCellEditor(comboBoxCurveLineOrientation));
        this.add((Component)new JScrollPane(kinTypeTable), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)deleteButton, "First");
        buttonPanel.add((Component)scanButton, "Last");
        this.add((Component)buttonPanel, "After");
    }

    public void actionPerformed(ActionEvent e) {
        if ("scan".equals(e.getActionCommand())) {
            int initalTypeCount = this.dataStoreSvg.getRelationTypeDefinitions().length;
            for (EntityData entityData : this.dataStoreSvg.graphData.getDataNodes()) {
                for (EntityRelation entityRelation : entityData.getAllRelations()) {
                    this.dataStoreSvg.addRelationTypeDefinition(new RelationTypeDefinition(entityRelation.customType, entityRelation.dcrType, new DataTypes.RelationType[]{entityRelation.getRelationType()}, "#999999", 2, 0, RelationTypeDefinition.CurveLineOrientation.horizontal));
                }
            }
            int foundTypesCount = this.dataStoreSvg.getRelationTypeDefinitions().length - initalTypeCount;
            if (foundTypesCount > 0) {
                this.relationTypesTableModel.fireTableDataChanged();
                this.dialogHandler.addMessageDialogToQueue("Added " + foundTypesCount + " new types from the diagram", "Scan For Types");
            } else {
                this.dialogHandler.addMessageDialogToQueue("No new types found on the diagram", "Scan For Types");
            }
        }
    }
}

