/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.io.IOException;
import org.basex.data.ExprInfo;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryText;
import org.basex.query.expr.BaseFuncCall;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.UserFunc;
import org.basex.query.expr.UserFuncCall;
import org.basex.query.func.FNIndex;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.func.JavaFunc;
import org.basex.query.item.AtomType;
import org.basex.query.item.FuncType;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Types;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.TypedFunc;
import org.basex.query.util.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Levenshtein;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class UserFuncs
extends ExprInfo {
    private UserFuncCall[][] calls = new UserFuncCall[0][];
    private UserFunc[] func = new UserFunc[0];

    public int size() {
        return this.func.length;
    }

    public TypedFunc get(QNm name, Expr[] args, QueryContext ctx, QueryParser qp) throws QueryException {
        byte[] uri = name.uri().atom();
        byte[] ln = name.ln();
        if (Token.eq(uri, QueryText.XSURI)) {
            AtomType type = AtomType.find(name, true);
            if (type == null || type == AtomType.NOT || type == AtomType.AAT) {
                Levenshtein ls = new Levenshtein();
                AtomType[] atomTypeArray = AtomType.values();
                int n = atomTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AtomType t = atomTypeArray[n2];
                    if (t.par != null && ls.similar(Token.lc(ln), Token.lc(t.nam), 0)) {
                        qp.error(Err.FUNSIMILAR, name.atom(), t.nam);
                    }
                    ++n2;
                }
                qp.error(Err.FUNCUNKNOWN, new Object[]{name.atom()});
            }
            if (args.length != 1) {
                qp.error(Err.FUNCTYPE, new Object[]{name.atom()});
            }
            SeqType to = SeqType.get((Type)type, SeqType.Occ.ZO);
            return TypedFunc.constr(new Cast(qp.input(), args[0], to), to);
        }
        if (Token.startsWith(uri, QueryText.JAVAPRE) && ctx.context.user.perm(8)) {
            int i;
            String c = Token.string(Token.substring(uri, QueryText.JAVAPRE.length));
            TokenBuilder tb = new TokenBuilder().add(c).add(46);
            boolean dash = false;
            int p = 0;
            while (p < ln.length) {
                int ch = Token.cp(ln, p);
                if (dash) {
                    tb.add(Character.toUpperCase(ch));
                    dash = false;
                } else {
                    boolean bl = dash = ch == 45;
                    if (!dash) {
                        tb.add(ch);
                    }
                }
                p += Token.cl(ln, p);
            }
            String java = tb.toString();
            Class<?> cls = Reflect.find(java.substring(0, i = java.lastIndexOf(".")));
            if (cls == null) {
                qp.error(Err.FUNCJAVA, java);
            }
            String mth = java.substring(i + 1);
            return TypedFunc.java(new JavaFunc(qp.input(), cls, mth, args));
        }
        FuncCall fun = FNIndex.get().get(ln, uri, args, qp);
        if (fun != null) {
            ctx.updating = ctx.updating | (fun.def == Function.PUT || fun.def == Function.DBADD || fun.def == Function.DBDELETE || fun.def == Function.DBRENAME || fun.def == Function.DBREPLACE || fun.def == Function.DBOPTIMIZE);
            return new TypedFunc(fun, fun.def.type(args.length));
        }
        int l = 0;
        while (l < this.func.length) {
            QNm qn = this.func[l].name;
            if (Token.eq(ln, qn.ln()) && Token.eq(uri, qn.uri().atom()) && args.length == this.func[l].args.length) {
                return new TypedFunc(this.add(qp.input(), qn, l, args), FuncType.get(this.func[l]));
            }
            ++l;
        }
        if (Types.find(name, false) == null) {
            return new TypedFunc(this.add(qp.input(), name, this.add(new UserFunc(qp.input(), name, new Var[args.length], null, false), qp), args), FuncType.arity(args.length));
        }
        return null;
    }

    private UserFuncCall add(InputInfo ii, QNm nm, int id, Expr[] arg) {
        BaseFuncCall call = new BaseFuncCall(ii, nm, arg);
        this.calls[id] = Array.add(this.calls[id], call);
        return call;
    }

    public int add(UserFunc fun, QueryParser qp) throws QueryException {
        QNm name = fun.name;
        byte[] uri = name.uri().atom();
        if (uri.length == 0) {
            qp.error(Err.FUNNONS, new Object[]{name.atom()});
        }
        if (NSGlobal.standard(uri)) {
            if (fun.declared) {
                qp.error(Err.NAMERES, new Object[]{name.atom()});
            }
            this.funError(name, qp);
        }
        byte[] ln = name.ln();
        int l = 0;
        while (l < this.func.length) {
            QNm qn = this.func[l].name;
            byte[] u = qn.uri().atom();
            byte[] nm = qn.ln();
            if (Token.eq(ln, nm) && Token.eq(uri, u) && fun.args.length == this.func[l].args.length) {
                if (!this.func[l].declared) {
                    this.func[l] = fun;
                    return l;
                }
                qp.error(Err.FUNCDEFINED, fun);
            }
            ++l;
        }
        this.func = Array.add(this.func, fun);
        this.calls = Array.add(this.calls, new UserFuncCall[0]);
        return this.func.length - 1;
    }

    public void check() throws QueryException {
        int n;
        int i = 0;
        while (i < this.func.length) {
            UserFuncCall[] userFuncCallArray = this.calls[i];
            int n2 = userFuncCallArray.length;
            n = 0;
            while (n < n2) {
                UserFuncCall c = userFuncCallArray[n];
                c.init(this.func[i]);
                ++n;
            }
            ++i;
        }
        UserFunc[] userFuncArray = this.func;
        n = this.func.length;
        int n3 = 0;
        while (n3 < n) {
            UserFunc f = userFuncArray[n3];
            f.check();
            ++n3;
        }
    }

    public void comp(QueryContext ctx) throws QueryException {
        int i = 0;
        while (i < this.func.length) {
            if (this.calls[i].length != 0) {
                this.func[i].comp(ctx);
            }
            ++i;
        }
    }

    public void funError(QNm name, QueryParser qp) throws QueryException {
        FNIndex.get().error(name, qp);
        Levenshtein ls = new Levenshtein();
        byte[] nm = Token.lc(name.ln());
        int n = 0;
        while (n < this.func.length) {
            if (ls.similar(nm, Token.lc(this.func[n].name.ln()), 0)) {
                qp.error(Err.FUNSIMILAR, name.atom(), this.func[n].name.atom());
            }
            ++n;
        }
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        if (this.func.length == 0) {
            return;
        }
        ser.openElement(this, (byte[][])new byte[0][]);
        int i = 0;
        while (i < this.func.length) {
            this.func[i].plan(ser);
            ++i;
        }
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.func.length) {
            sb.append(this.func[i].toString());
            ++i;
        }
        return sb.toString();
    }
}

