/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.AbstractRequest;

public class Interface {
    public static final byte ST_OUT_OF_SERVICE = 0;
    public static final byte ST_ADMIN = 1;
    public static final byte ST_QUERY = 2;
    public static final byte ST_ADMIN_AND_QUERY = 3;
    public static final byte SP_HDL_UDP = 0;
    public static final byte SP_HDL_TCP = 1;
    public static final byte SP_HDL_HTTP = 2;
    public byte type;
    public int port;
    public byte protocol;

    public Interface(byte type, byte protocol, int port) {
        this.type = type;
        this.port = port;
        this.protocol = protocol;
    }

    public Interface() {
    }

    public boolean canHandleRequest(AbstractRequest req) {
        if ((req.streaming || req.requiresConnection) && this.protocol != 1 && this.protocol != 2) {
            return false;
        }
        if (req.isAdminRequest) {
            return this.type == 1 || this.type == 3;
        }
        return this.type == 2 || this.type == 3;
    }

    public String toString() {
        return Interface.typeName(this.type) + '/' + Interface.protocolName(this.protocol) + '/' + this.port;
    }

    public static final String typeName(byte type) {
        switch (type) {
            case 0: {
                return "OUT_OF_SERVICE";
            }
            case 3: {
                return "ADMIN_AND_QUERY";
            }
            case 2: {
                return "QUERY";
            }
            case 1: {
                return "ADMIN";
            }
        }
        return "UNKNOWN";
    }

    public static final String protocolName(byte protocol) {
        switch (protocol) {
            case 2: {
                return "HDL_HTTP";
            }
            case 1: {
                return "HDL_TCP";
            }
            case 0: {
                return "HDL_UDP";
            }
        }
        return "UNKNOWN";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Interface)) {
            return false;
        }
        Interface intfc = (Interface)obj;
        return this.type == intfc.type && this.port == intfc.port && this.protocol == intfc.protocol;
    }
}

