/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationLinker {
    private void removeMatchingRelations(Document entityDocument, UniqueIdentifier[] selectedIdentifiers) {
    }

    public UniqueIdentifier[] linkEntities(GraphPanel graphPanel, UniqueIdentifier targetIdentifier, UniqueIdentifier[] selectedIdentifiers, DataTypes.RelationType relationType) throws ImportException {
        ArrayList<EntityDocument> entityDocumentList = new ArrayList<EntityDocument>();
        ArrayList<UniqueIdentifier> affectedIdentifiers = new ArrayList<UniqueIdentifier>();
        try {
            EntityDocument leadEntityDocument = new EntityDocument(new URI(graphPanel.getPathForElementId(targetIdentifier)), new ImportTranslator(true));
            affectedIdentifiers.add(targetIdentifier);
            for (EntityData alterEntity : graphPanel.getEntitiesById(selectedIdentifiers).values()) {
                EntityDocument entityDocument = new EntityDocument(new URI(alterEntity.getEntityPath()), new ImportTranslator(true));
                entityDocumentList.add(entityDocument);
                affectedIdentifiers.add(alterEntity.getUniqueIdentifier());
            }
            this.linkEntities(leadEntityDocument, entityDocumentList, relationType);
        }
        catch (URISyntaxException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        return affectedIdentifiers.toArray(new UniqueIdentifier[0]);
    }

    public void linkEntities(GraphPanel graphPanel, UniqueIdentifier[] selectedIdentifiers, DataTypes.RelationType relationType) throws ImportException {
        EntityDocument leadEntityDocument = null;
        ArrayList<EntityDocument> entityDocumentList = new ArrayList<EntityDocument>();
        try {
            for (EntityData alterEntity : graphPanel.getEntitiesById(selectedIdentifiers).values()) {
                EntityDocument entityDocument = new EntityDocument(new URI(alterEntity.getEntityPath()), new ImportTranslator(true));
                if (leadEntityDocument == null) {
                    leadEntityDocument = entityDocument;
                    continue;
                }
                entityDocumentList.add(entityDocument);
            }
            this.linkEntities(leadEntityDocument, entityDocumentList, relationType);
        }
        catch (URISyntaxException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
    }

    public void linkEntities(EntityDocument leadEntityDocument, ArrayList<EntityDocument> entityDocumentList, DataTypes.RelationType relationType) throws ImportException {
        for (EntityDocument alterEntity : entityDocumentList) {
            leadEntityDocument.entityData.addRelatedNode(alterEntity.entityData, relationType, DataTypes.RelationLineType.sanguineLine, null, null);
        }
        leadEntityDocument.saveDocument();
        new EntityCollection().updateDatabase(leadEntityDocument.getFile().toURI());
        for (EntityDocument entityDocument : entityDocumentList) {
            entityDocument.saveDocument();
            new EntityCollection().updateDatabase(entityDocument.getFile().toURI());
        }
    }

    public void unlinkEntities(GraphPanel graphPanel, UniqueIdentifier[] selectedIdentifiers) {
        HashMap<UniqueIdentifier, EntityData> selectedEntityMap = graphPanel.getEntitiesById(selectedIdentifiers);
        EntityData leadSelectionEntity = selectedEntityMap.get(selectedIdentifiers[0]);
        for (EntityData selectedEntity : selectedEntityMap.values()) {
            String targetPath = selectedEntity.getEntityPath();
            try {
                URI targetUri = new URI(targetPath);
                Document metadataDom = ArbilComponentBuilder.getDocument((URI)targetUri);
                if (selectedEntity.equals(leadSelectionEntity)) {
                    this.removeMatchingRelations(metadataDom, selectedIdentifiers);
                } else {
                    this.removeMatchingRelations(metadataDom, new UniqueIdentifier[]{leadSelectionEntity.getUniqueIdentifier()});
                }
                ArbilComponentBuilder.savePrettyFormatting((Document)metadataDom, (File)new File(targetUri));
                new EntityCollection().updateDatabase(targetUri);
            }
            catch (URISyntaxException exception) {
                new ArbilBugCatcher().logError((Exception)exception);
            }
            catch (DOMException exception) {
                new ArbilBugCatcher().logError((Exception)exception);
            }
            catch (IOException exception) {
                new ArbilBugCatcher().logError((Exception)exception);
            }
            catch (ParserConfigurationException exception) {
                new ArbilBugCatcher().logError((Exception)exception);
            }
            catch (SAXException exception) {
                new ArbilBugCatcher().logError((Exception)exception);
            }
        }
        throw new UnsupportedOperationException("todo...");
    }
}

