/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.BorderLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.EntitySvg;
import nl.mpi.kinnate.svg.GraphPanelSize;
import nl.mpi.kinnate.svg.MouseListenerSvg;
import nl.mpi.kinnate.svg.SvgUpdateHandler;
import nl.mpi.kinnate.ui.GraphPanelContextMenu;
import nl.mpi.kinnate.ui.HidePane;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanel
extends JPanel
implements SavePanel {
    private JSVGScrollPane jSVGScrollPane;
    protected JSVGCanvas svgCanvas;
    protected SVGDocument doc;
    protected ArbilTableModel arbilTableModel;
    protected HidePane editorHidePane;
    private boolean requiresSave = false;
    private File svgFile = null;
    protected GraphPanelSize graphPanelSize;
    protected ArrayList<UniqueIdentifier> selectedGroupId;
    protected String svgNameSpace = "http://www.w3.org/2000/svg";
    public DataStoreSvg dataStoreSvg = new DataStoreSvg();
    protected EntitySvg entitySvg = new EntitySvg();
    public SvgUpdateHandler svgUpdateHandler;
    private int currentZoom = 0;
    private AffineTransform zoomAffineTransform = null;
    public MouseListenerSvg mouseListenerSvg;

    public GraphPanel(KinDiagramPanel kinDiagramPanel) {
        this.dataStoreSvg.setDefaults();
        this.svgUpdateHandler = new SvgUpdateHandler(this, kinDiagramPanel);
        this.selectedGroupId = new ArrayList();
        this.graphPanelSize = new GraphPanelSize();
        this.setLayout(new BorderLayout());
        this.svgCanvas = new JSVGCanvas();
        this.svgCanvas.setDocumentState(1);
        this.svgCanvas.setEnableImageZoomInteractor(false);
        this.svgCanvas.setEnablePanInteractor(false);
        this.svgCanvas.setEnableRotateInteractor(false);
        this.svgCanvas.setEnableZoomInteractor(false);
        this.svgCanvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                GraphPanel.this.currentZoom = GraphPanel.this.currentZoom + e.getUnitsToScroll();
                if (GraphPanel.this.currentZoom > 8) {
                    GraphPanel.this.currentZoom = 8;
                }
                if (GraphPanel.this.currentZoom < -6) {
                    GraphPanel.this.currentZoom = -6;
                }
                double scale = 1.0 - (double)e.getUnitsToScroll() / 10.0;
                double tx = (double)(-e.getX()) * (scale - 1.0);
                double ty = (double)(-e.getY()) * (scale - 1.0);
                AffineTransform at = new AffineTransform();
                at.translate(tx, ty);
                at.scale(scale, scale);
                at.concatenate(GraphPanel.this.svgCanvas.getRenderingTransform());
                GraphPanel.this.svgCanvas.setRenderingTransform(at);
            }
        });
        this.mouseListenerSvg = new MouseListenerSvg(kinDiagramPanel, this);
        this.svgCanvas.addMouseListener(this.mouseListenerSvg);
        this.svgCanvas.addMouseMotionListener(this.mouseListenerSvg);
        this.jSVGScrollPane = new JSVGScrollPane(this.svgCanvas);
        this.add("Center", this.jSVGScrollPane);
        this.svgCanvas.setComponentPopupMenu(new GraphPanelContextMenu(kinDiagramPanel, this, this.graphPanelSize));
        this.svgCanvas.addLinkActivationListener(new LinkActivationListener(){

            public void linkActivated(LinkActivationEvent lae) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
    }

    public void setArbilTableModel(ArbilTableModel arbilTableModelLocal, HidePane editorHidePane) {
        this.editorHidePane = editorHidePane;
        this.arbilTableModel = arbilTableModelLocal;
    }

    public EntityData[] readSvg(File svgFilePath) {
        this.svgFile = svgFilePath;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(parser);
        try {
            this.doc = (SVGDocument)documentFactory.createDocument(svgFilePath.toURI().toString());
            this.svgCanvas.setDocument((Document)this.doc);
            this.dataStoreSvg = DataStoreSvg.loadDataFromSvg(this.doc);
            this.requiresSave = false;
            this.entitySvg.readEntityPositions(this.doc.getElementById("EntityGroup"));
            this.entitySvg.readEntityPositions(this.doc.getElementById("LabelsGroup"));
        }
        catch (IOException ioe) {
            GuiHelper.linorgBugCatcher.logError((Exception)ioe);
        }
        for (String groupForMouseListener : new String[]{"EntityGroup", "LabelsGroup"}) {
            Element parentElement = this.doc.getElementById(groupForMouseListener);
            if (parentElement == null) {
                Element requiredGroup = this.doc.createElementNS(this.svgNameSpace, "g");
                requiredGroup.setAttribute("id", groupForMouseListener);
                Element svgRoot = this.doc.getDocumentElement();
                svgRoot.appendChild(requiredGroup);
                continue;
            }
            for (Node currentNode = parentElement.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                ((EventTarget)((Object)currentNode)).addEventListener("mousedown", this.mouseListenerSvg, false);
            }
        }
        this.dataStoreSvg.indexParameters.symbolFieldsFields.setAvailableValues(this.entitySvg.listSymbolNames(this.doc));
        if (this.dataStoreSvg.graphData == null) {
            return null;
        }
        this.svgCanvas.setSVGDocument(this.doc);
        return this.dataStoreSvg.graphData.getDataNodes();
    }

    public void generateDefaultSvg() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            String templateXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><svg xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:kin=\"http://mpi.nl/tla/kin\" xmlns=\"http://www.w3.org/2000/svg\" contentScriptType=\"text/ecmascript\"  zoomAndPan=\"magnify\" contentStyleType=\"text/css\" preserveAspectRatio=\"xMidYMid meet\" version=\"1.0\"/>";
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(parser);
            this.doc = (SVGDocument)documentFactory.createDocument(this.svgNameSpace, (Reader)new StringReader(templateXml));
            this.entitySvg.insertSymbols(this.doc, this.svgNameSpace);
            Element diagramGroup = this.doc.createElementNS(this.svgNameSpace, "g");
            diagramGroup.setAttribute("id", "DiagramGroup");
            this.doc.getDocumentElement().appendChild(diagramGroup);
            Element relationGroupNode = this.doc.createElementNS(this.svgNameSpace, "g");
            relationGroupNode.setAttribute("id", "RelationGroup");
            diagramGroup.appendChild(relationGroupNode);
            Element entityGroupNode = this.doc.createElementNS(this.svgNameSpace, "g");
            entityGroupNode.setAttribute("id", "EntityGroup");
            diagramGroup.appendChild(entityGroupNode);
            Element labelsGroup = this.doc.createElementNS(this.svgNameSpace, "g");
            labelsGroup.setAttribute("id", "LabelsGroup");
            diagramGroup.appendChild(labelsGroup);
            this.dataStoreSvg.indexParameters.symbolFieldsFields.setAvailableValues(this.entitySvg.listSymbolNames(this.doc));
            this.svgCanvas.setSVGDocument(this.doc);
            this.dataStoreSvg.graphData = new GraphSorter();
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError((Exception)exception);
        }
    }

    private void saveSvg(File svgFilePath) {
        this.svgFile = svgFilePath;
        this.selectedGroupId.clear();
        this.svgUpdateHandler.drawEntities();
        ArbilComponentBuilder.savePrettyFormatting((Document)this.doc, (File)svgFilePath);
        this.requiresSave = false;
    }

    private void printNodeNames(Node nodeElement) {
        System.out.println(nodeElement.getLocalName());
        System.out.println(nodeElement.getNamespaceURI());
        for (Node childNode = nodeElement.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            this.printNodeNames(childNode);
        }
    }

    public String[] getKinTypeStrigs() {
        return this.dataStoreSvg.kinTypeStrings;
    }

    public void setKinTypeStrigs(String[] kinTypeStringArray) {
        this.dataStoreSvg.kinTypeStrings = kinTypeStringArray;
    }

    public IndexerParameters getIndexParameters() {
        return this.dataStoreSvg.indexParameters;
    }

    public KinTermGroup[] getkinTermGroups() {
        return this.dataStoreSvg.kinTermGroups;
    }

    public void addKinTermGroup() {
        ArrayList<KinTermGroup> kinTermsList = new ArrayList<KinTermGroup>(Arrays.asList(this.dataStoreSvg.kinTermGroups));
        kinTermsList.add(new KinTermGroup());
        this.dataStoreSvg.kinTermGroups = kinTermsList.toArray(new KinTermGroup[0]);
    }

    public void setSelectedIds(UniqueIdentifier[] uniqueIdentifiers) {
        this.selectedGroupId.clear();
        this.selectedGroupId.addAll(Arrays.asList(uniqueIdentifiers));
        this.svgUpdateHandler.updateSvgSelectionHighlights();
    }

    public UniqueIdentifier[] getSelectedIds() {
        return this.selectedGroupId.toArray(new UniqueIdentifier[0]);
    }

    public HashMap<UniqueIdentifier, EntityData> getEntitiesById(UniqueIdentifier[] uniqueIdentifiers) {
        ArrayList<UniqueIdentifier> identifierList = new ArrayList<UniqueIdentifier>(Arrays.asList(uniqueIdentifiers));
        HashMap<UniqueIdentifier, EntityData> returnMap = new HashMap<UniqueIdentifier, EntityData>();
        for (EntityData entityData : this.dataStoreSvg.graphData.getDataNodes()) {
            if (!identifierList.contains(entityData.getUniqueIdentifier())) continue;
            returnMap.put(entityData.getUniqueIdentifier(), entityData);
        }
        return returnMap;
    }

    public String getPathForElementId(UniqueIdentifier elementId) {
        Element entityElement = this.doc.getElementById(elementId.getAttributeIdentifier());
        if (entityElement == null) {
            return null;
        }
        return entityElement.getAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "path");
    }

    public String getKinTypeForElementId(UniqueIdentifier elementId) {
        Element entityElement = this.doc.getElementById(elementId.getAttributeIdentifier());
        if (entityElement != null) {
            return entityElement.getAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "kintype");
        }
        return "";
    }

    public void resetZoom() {
        AffineTransform at = new AffineTransform();
        at.scale(1.0, 1.0);
        at.setToTranslation(1.0, 1.0);
        this.svgCanvas.setRenderingTransform(at);
    }

    public void resetLayout() {
        this.entitySvg = new EntitySvg();
        this.dataStoreSvg.graphData.setEntitys(this.dataStoreSvg.graphData.getDataNodes());
        this.dataStoreSvg.graphData.placeAllNodes(this.entitySvg.entityPositions);
        this.drawNodes();
    }

    public void clearEntityLocations(UniqueIdentifier[] selectedIdentifiers) {
        this.entitySvg.clearEntityLocations(selectedIdentifiers);
    }

    public void drawNodes() {
        this.requiresSave = true;
        this.selectedGroupId.clear();
        this.svgUpdateHandler.updateEntities();
    }

    public void drawNodes(GraphSorter graphDataLocal) {
        this.dataStoreSvg.graphData = graphDataLocal;
        this.drawNodes();
        if (graphDataLocal.getDataNodes().length == 0) {
            // empty if block
        }
    }

    @Override
    public boolean hasSaveFileName() {
        return this.svgFile != null;
    }

    @Override
    public File getFileName() {
        return this.svgFile;
    }

    @Override
    public boolean requiresSave() {
        return this.requiresSave;
    }

    @Override
    public void setRequiresSave() {
        this.requiresSave = true;
    }

    @Override
    public void saveToFile() {
        this.saveSvg(this.svgFile);
    }

    @Override
    public void saveToFile(File saveAsFile) {
        this.saveSvg(saveAsFile);
    }

    @Override
    public void updateGraph() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

