/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.util.ArrayList;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.EntitySvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationSvg {
    private void addUseNode(SVGDocument doc, String svgNameSpace, Element targetGroup, String targetDefId) {
        String useNodeId = targetDefId + "use";
        Element useNodeOld = doc.getElementById(useNodeId);
        if (useNodeOld != null) {
            useNodeOld.getParentNode().removeChild(useNodeOld);
        }
        Element useNode = doc.createElementNS(svgNameSpace, "use");
        useNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + targetDefId);
        useNode.setAttribute("id", useNodeId);
        targetGroup.appendChild(useNode);
    }

    private void updateLabelNode(SVGDocument doc, String svgNameSpace, String lineIdString, String targetRelationId) {
        String labelNodeId = targetRelationId + "label";
        Element useNodeOld = doc.getElementById(labelNodeId);
        if (useNodeOld != null) {
            Node textParentNode = useNodeOld.getParentNode();
            String labelText = useNodeOld.getTextContent();
            useNodeOld.getParentNode().removeChild(useNodeOld);
            Element textPath = doc.createElementNS(svgNameSpace, "textPath");
            textPath.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + lineIdString);
            textPath.setAttribute("startOffset", "50%");
            textPath.setAttribute("id", labelNodeId);
            Text textNode = doc.createTextNode(labelText);
            textPath.appendChild(textNode);
            textParentNode.appendChild(textPath);
        }
    }

    protected void setPolylinePointsAttribute(Element targetNode, DataTypes.RelationType relationType, float vSpacing, float egoX, float egoY, float alterX, float alterY) {
        float midY = (egoY + alterY) / 2.0f;
        switch (relationType) {
            case affiliation: {
                break;
            }
            case ancestor: {
                midY = alterY + vSpacing / 2.0f;
                break;
            }
            case descendant: {
                midY = egoY + vSpacing / 2.0f;
                break;
            }
            case none: {
                break;
            }
            case sibling: {
                midY = egoY < alterY ? egoY - vSpacing / 2.0f : alterY - vSpacing / 2.0f;
                break;
            }
            case union: {
                midY = egoY > alterY ? egoY + vSpacing / 2.0f : alterY + vSpacing / 2.0f;
            }
        }
        targetNode.setAttribute("points", egoX + "," + egoY + " " + egoX + "," + midY + " " + alterX + "," + midY + " " + alterX + "," + alterY);
    }

    protected void setPathPointsAttribute(Element targetNode, DataTypes.RelationType relationType, DataTypes.RelationLineType relationLineType, float hSpacing, float vSpacing, float egoX, float egoY, float alterX, float alterY) {
        float toBezY;
        float toBezX;
        float fromBezY;
        float fromBezX;
        if (egoX > alterX && egoY < alterY || egoX > alterX && egoY > alterY) {
            float tempX = alterX;
            float tempY = alterY;
            alterX = egoX;
            alterY = egoY;
            egoX = tempX;
            egoY = tempY;
        }
        if (relationLineType == DataTypes.RelationLineType.verticalCurve) {
            fromBezX = egoX;
            fromBezY = alterY;
            toBezX = alterX;
            toBezY = egoY;
            if (1.0f / (egoY - alterY) < vSpacing) {
                fromBezX = egoX;
                fromBezY = alterY - vSpacing / 2.0f;
                toBezX = alterX;
                toBezY = egoY - vSpacing / 2.0f;
            }
        } else {
            fromBezX = alterX;
            fromBezY = egoY;
            toBezX = egoX;
            toBezY = alterY;
            if (egoX > alterX) {
                if (egoX - alterX < hSpacing / 4.0f) {
                    fromBezX = egoX - hSpacing / 4.0f;
                    toBezX = alterX - hSpacing / 4.0f;
                } else {
                    fromBezX = (egoX - alterX) / 2.0f + alterX;
                    toBezX = (egoX - alterX) / 2.0f + alterX;
                }
            } else if (alterX - egoX < hSpacing / 4.0f) {
                fromBezX = egoX + hSpacing / 4.0f;
                toBezX = alterX + hSpacing / 4.0f;
            } else {
                fromBezX = (alterX - egoX) / 2.0f + egoX;
                toBezX = (alterX - egoX) / 2.0f + egoX;
            }
        }
        targetNode.setAttribute("d", "M " + egoX + "," + egoY + " C " + fromBezX + "," + fromBezY + " " + toBezX + "," + toBezY + " " + alterX + "," + alterY);
    }

    private boolean hasCommonParent(EntityData currentNode, EntityRelation graphLinkNode) {
        if (graphLinkNode.relationType == DataTypes.RelationType.sibling) {
            for (EntityRelation altersRelation : graphLinkNode.getAlterNode().getDistinctRelateNodes()) {
                if (altersRelation.relationType != DataTypes.RelationType.ancestor) continue;
                for (EntityRelation egosRelation : currentNode.getDistinctRelateNodes()) {
                    if (egosRelation.relationType != DataTypes.RelationType.ancestor || !altersRelation.alterUniqueIdentifier.equals(egosRelation.alterUniqueIdentifier) || !altersRelation.getAlterNode().isVisible) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void insertRelation(GraphPanel graphPanel, Element relationGroupNode, EntityData currentNode, EntityRelation graphLinkNode, int hSpacing, int vSpacing) {
        if (graphLinkNode.relationLineType == DataTypes.RelationLineType.sanguineLine && this.hasCommonParent(currentNode, graphLinkNode)) {
            return;
        }
        int relationLineIndex = relationGroupNode.getChildNodes().getLength();
        Element groupNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "g");
        groupNode.setAttribute("id", "relation" + relationLineIndex);
        Element defsNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "defs");
        String lineIdString = "relation" + relationLineIndex + "Line";
        new DataStoreSvg().storeRelationParameters(graphPanel.doc, groupNode, graphLinkNode.relationType, graphLinkNode.relationLineType, currentNode.getUniqueIdentifier(), graphLinkNode.getAlterNode().getUniqueIdentifier());
        float[] egoSymbolPoint = graphPanel.entitySvg.getEntityLocation(currentNode.getUniqueIdentifier());
        float[] alterSymbolPoint = graphPanel.entitySvg.getEntityLocation(graphLinkNode.getAlterNode().getUniqueIdentifier());
        float fromX = egoSymbolPoint[0];
        float fromY = egoSymbolPoint[1];
        float toX = alterSymbolPoint[0];
        float toY = alterSymbolPoint[1];
        boolean addedRelationLine = false;
        switch (graphLinkNode.relationLineType) {
            case kinTermLine: 
            case verticalCurve: {
                Element linkLine = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "path");
                this.setPathPointsAttribute(linkLine, graphLinkNode.relationType, graphLinkNode.relationLineType, hSpacing, vSpacing, fromX, fromY, toX, toY);
                linkLine.setAttribute("fill", "none");
                if (graphLinkNode.lineColour != null) {
                    linkLine.setAttribute("stroke", graphLinkNode.lineColour);
                } else {
                    linkLine.setAttribute("stroke", "blue");
                }
                linkLine.setAttribute("stroke-width", Integer.toString(EntitySvg.strokeWidth));
                linkLine.setAttribute("id", lineIdString);
                defsNode.appendChild(linkLine);
                addedRelationLine = true;
                break;
            }
            case sanguineLine: {
                Element squareLinkLine = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "polyline");
                this.setPolylinePointsAttribute(squareLinkLine, graphLinkNode.relationType, vSpacing, fromX, fromY, toX, toY);
                squareLinkLine.setAttribute("fill", "none");
                squareLinkLine.setAttribute("stroke", "grey");
                squareLinkLine.setAttribute("stroke-width", Integer.toString(EntitySvg.strokeWidth));
                squareLinkLine.setAttribute("id", lineIdString);
                defsNode.appendChild(squareLinkLine);
                addedRelationLine = true;
            }
        }
        groupNode.appendChild(defsNode);
        if (addedRelationLine) {
            this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, groupNode, lineIdString);
            if (graphLinkNode.labelString != null) {
                Element labelText = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "text");
                labelText.setAttribute("text-anchor", "middle");
                if (graphLinkNode.lineColour != null) {
                    labelText.setAttribute("fill", graphLinkNode.lineColour);
                } else {
                    labelText.setAttribute("fill", "blue");
                }
                labelText.setAttribute("stroke-width", "0");
                labelText.setAttribute("font-size", "14");
                Element textPath = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "textPath");
                textPath.setAttributeNS("http://www.w3.rg/1999/xlink", "xlink:href", "#" + lineIdString);
                textPath.setAttribute("startOffset", "50%");
                textPath.setAttribute("id", "relation" + relationLineIndex + "label");
                Text textNode = graphPanel.doc.createTextNode(graphLinkNode.labelString);
                textPath.appendChild(textNode);
                labelText.appendChild(textPath);
                groupNode.appendChild(labelText);
            }
        }
        relationGroupNode.appendChild(groupNode);
    }

    public void updateRelationLines(GraphPanel graphPanel, ArrayList<UniqueIdentifier> draggedNodeIds, int hSpacing, int vSpacing) {
        Element relationGroup = graphPanel.doc.getElementById("RelationGroup");
        for (Node currentChild = relationGroup.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!"g".equals(currentChild.getLocalName())) continue;
            Node idAttrubite = currentChild.getAttributes().getNamedItem("id");
            DataStoreSvg.GraphRelationData graphRelationData = new DataStoreSvg().getEntitiesForRelations(currentChild);
            if (graphRelationData == null || !draggedNodeIds.contains(graphRelationData.egoNodeId) && !draggedNodeIds.contains(graphRelationData.alterNodeId)) continue;
            String lineElementId = idAttrubite.getNodeValue() + "Line";
            Element relationLineElement = graphPanel.doc.getElementById(lineElementId);
            float[] egoSymbolPoint = graphPanel.entitySvg.getEntityLocation(graphRelationData.egoNodeId);
            float[] alterSymbolPoint = graphPanel.entitySvg.getEntityLocation(graphRelationData.alterNodeId);
            float egoX = egoSymbolPoint[0];
            float egoY = egoSymbolPoint[1];
            float alterX = alterSymbolPoint[0];
            float alterY = alterSymbolPoint[1];
            if ("polyline".equals(relationLineElement.getLocalName())) {
                this.setPolylinePointsAttribute(relationLineElement, graphRelationData.relationType, vSpacing, egoX, egoY, alterX, alterY);
            }
            if ("path".equals(relationLineElement.getLocalName())) {
                this.setPathPointsAttribute(relationLineElement, graphRelationData.relationType, graphRelationData.relationLineType, hSpacing, vSpacing, egoX, egoY, alterX, alterY);
            }
            this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, (Element)currentChild, lineElementId);
            this.updateLabelNode(graphPanel.doc, graphPanel.svgNameSpace, lineElementId, idAttrubite.getNodeValue());
        }
    }
}

