/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilNodeSearchPanel;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.ui.KinDragTransferHandler;

public class ArchiveEntityLinkerPanel
extends JPanel
implements ActionListener {
    private JTabbedPane tabbedPane;
    private ArbilTree archiveTree = new ArbilTree();
    private JButton nextButton;

    public ArchiveEntityLinkerPanel(ArbilTable previewTable, KinDragTransferHandler dragTransferHandler) {
        this.setLayout(new BorderLayout());
        JPanel treePanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Archive Branch Selection", treePanel);
        this.add((Component)this.tabbedPane, "Center");
        this.nextButton = new JButton("Search Selected");
        this.nextButton.setActionCommand("Search");
        this.nextButton.addActionListener(this);
        treePanel.add((Component)new JScrollPane((Component)this.archiveTree), "Center");
        treePanel.add((Component)this.nextButton, "Last");
        this.archiveTree.setCustomPreviewTable(previewTable);
        this.archiveTree.setTransferHandler((TransferHandler)dragTransferHandler);
        this.archiveTree.setDragEnabled(true);
        this.loadTreeNodes();
    }

    private void loadTreeNodes() {
        try {
            ArbilDataNode imdiCorporaNode = ArbilDataNodeLoader.getSingleInstance().getArbilDataNode(null, new URI("http://corpus1.mpi.nl/IMDI/metadata/IMDI.imdi"));
            ArbilNode[] allEntities = new ArbilNode[]{imdiCorporaNode};
            this.archiveTree.rootNodeChildren = allEntities;
            this.archiveTree.requestResort();
        }
        catch (URISyntaxException exception) {
            GuiHelper.linorgBugCatcher.logError((Exception)exception);
        }
    }

    private void getSeachPanel() {
        JPanel searchPanel = new JPanel(new BorderLayout());
        String frameTitle = "Archive Search";
        ArbilTableModel resultsTableModel = new ArbilTableModel();
        ArbilTable imdiTable = new ArbilTable(resultsTableModel, frameTitle);
        ArbilSplitPanel imdiSplitPanel = new ArbilSplitPanel(imdiTable);
        JInternalFrame searchFrame = new JInternalFrame();
        searchPanel.add((Component)new ArbilNodeSearchPanel(searchFrame, resultsTableModel, (ArbilNode[])this.archiveTree.getSelectedNodes()), "First");
        searchPanel.add((Component)imdiSplitPanel, "Center");
        JButton closeSearch = new JButton("Close Search");
        closeSearch.setActionCommand("Close Search");
        closeSearch.addActionListener(this);
        searchPanel.add((Component)closeSearch, "Last");
        imdiSplitPanel.setSplitDisplay();
        this.tabbedPane.add("Archive Branch Search", searchPanel);
        this.tabbedPane.setSelectedComponent(searchPanel);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Search")) {
            this.getSeachPanel();
        }
        if (ae.getActionCommand().equals("Close Search")) {
            this.tabbedPane.remove(this.tabbedPane.getSelectedComponent());
        }
    }
}

