/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.EntityMerger;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.kindocument.RelationLinker;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.GraphPanelSize;
import nl.mpi.kinnate.svg.SvgUpdateHandler;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GraphPanelContextMenu
extends JPopupMenu
implements ActionListener {
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private GraphPanelSize graphPanelSize;
    private JMenuItem duplicateEntitiesMenu;
    private JMenuItem mergeEntitiesMenu;
    private JMenuItem addRelationEntityMenu;
    private JMenuItem removeRelationEntityMenu;
    private JMenuItem setAsEgoMenuItem;
    private JMenuItem addAsEgoMenuItem;
    private JMenuItem removeEgoMenuItem;
    private JMenuItem addAsRequiredMenuItem;
    private JMenuItem removeRequiredMenuItem;
    private JMenuItem saveFileMenuItem;
    private JCheckBoxMenuItem snapToGridMenuItem;
    private JCheckBoxMenuItem showBorderMenuItem;
    private JCheckBoxMenuItem highlightRelationsMenuItem;
    private JCheckBoxMenuItem showKinTermLinesMenuItem;
    private JCheckBoxMenuItem showSanguineLinesMenuItem;
    private JCheckBoxMenuItem showLabelssMenuItem;
    private JCheckBoxMenuItem showKinTypeLabelssMenuItem;
    private JCheckBoxMenuItem showKinTermLabelssMenuItem;
    private JCheckBoxMenuItem showArchiveLinksMenuItem;
    private UniqueIdentifier[] selectedIdentifiers = null;
    private float xPos;
    private float yPos;

    public GraphPanelContextMenu(KinDiagramPanel egoSelectionPanelLocal, GraphPanel graphPanelLocal, GraphPanelSize graphPanelSizeLocal) {
        this.kinDiagramPanel = egoSelectionPanelLocal;
        this.graphPanel = graphPanelLocal;
        this.graphPanelSize = graphPanelSizeLocal;
        if (egoSelectionPanelLocal != null) {
            JMenuItem addEntityMenuItem = new JMenuItem("Add Entity");
            addEntityMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EntityDocument entityDocument = new EntityDocument(ArbilSessionStorage.getSingleInstance().getCacheDirectory(), null, new ImportTranslator(true));
                    try {
                        entityDocument.createDocument(true);
                        entityDocument.insertDefaultMetadata();
                        entityDocument.saveDocument();
                        URI addedEntityUri = entityDocument.getFile().toURI();
                        new EntityCollection().updateDatabase(addedEntityUri);
                        GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(new UniqueIdentifier[]{entityDocument.getUniqueIdentifier()});
                    }
                    catch (ImportException exception) {
                        new ArbilBugCatcher().logError((Exception)exception);
                    }
                }
            });
            this.add(addEntityMenuItem);
            this.duplicateEntitiesMenu = new JMenuItem("Duplicate Selected Entities");
            this.duplicateEntitiesMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        UniqueIdentifier[] duplicateEntities = new EntityMerger().duplicateEntities(GraphPanelContextMenu.this.graphPanel, GraphPanelContextMenu.this.selectedIdentifiers);
                        GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                        GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(duplicateEntities);
                    }
                    catch (ImportException exception) {
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to duplicate: " + exception.getMessage(), GraphPanelContextMenu.this.duplicateEntitiesMenu.getText());
                    }
                }
            });
            this.add(this.duplicateEntitiesMenu);
            this.mergeEntitiesMenu = new JMenuItem("Merge Selected Entities");
            this.mergeEntitiesMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        new EntityMerger().mergeEntities(GraphPanelContextMenu.this.graphPanel, GraphPanelContextMenu.this.selectedIdentifiers);
                        GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                    }
                    catch (ImportException exception) {
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to merge: " + exception.getMessage(), GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                    }
                }
            });
            this.add(this.mergeEntitiesMenu);
            this.addRelationEntityMenu = new JMenu("Add Relation");
            this.add(this.addRelationEntityMenu);
            for (DataTypes.RelationType relationType : DataTypes.RelationType.values()) {
                JMenuItem addRelationEntityMenuItem = new JMenuItem(relationType.name());
                addRelationEntityMenuItem.setActionCommand(relationType.name());
                addRelationEntityMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            new RelationLinker().linkEntities(GraphPanelContextMenu.this.graphPanel, GraphPanelContextMenu.this.selectedIdentifiers, DataTypes.RelationType.valueOf(evt.getActionCommand()));
                            GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                        }
                        catch (ImportException exception) {
                            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to create relation: " + exception.getMessage(), GraphPanelContextMenu.this.addRelationEntityMenu.getText());
                        }
                    }
                });
                this.addRelationEntityMenu.add(addRelationEntityMenuItem);
            }
            this.removeRelationEntityMenu = new JMenu("Remove Relations");
            this.add(this.removeRelationEntityMenu);
            String actionString = "Remove Relations to Lead Selection";
            JMenuItem removeRelationEntityMenuItem = new JMenuItem(actionString);
            removeRelationEntityMenuItem.setActionCommand(actionString);
            removeRelationEntityMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    new RelationLinker().unlinkEntities(GraphPanelContextMenu.this.graphPanel, GraphPanelContextMenu.this.selectedIdentifiers);
                    GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                }
            });
            this.removeRelationEntityMenu.add(removeRelationEntityMenuItem);
            JMenu shapeSubMenu = new JMenu("Add Geometry");
            for (SvgUpdateHandler.GraphicsTypes graphicsType : SvgUpdateHandler.GraphicsTypes.values()) {
                JMenuItem addLabel = new JMenuItem("Add " + graphicsType.name());
                addLabel.setActionCommand(graphicsType.name());
                shapeSubMenu.add(addLabel);
                if (SvgUpdateHandler.GraphicsTypes.Polyline.equals((Object)graphicsType)) {
                    addLabel.setEnabled(false);
                }
                addLabel.addActionListener(this);
            }
            this.add(shapeSubMenu);
        }
        this.setAsEgoMenuItem = new JMenuItem("Set as Ego (relacing existing)");
        this.setAsEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.setEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.setAsEgoMenuItem);
        this.addAsEgoMenuItem = new JMenuItem("Add as Ego");
        this.addAsEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.addAsEgoMenuItem);
        this.removeEgoMenuItem = new JMenuItem("Remove Ego");
        this.removeEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeEgoMenuItem);
        this.addAsRequiredMenuItem = new JMenuItem("Set as required");
        this.addAsRequiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.addAsRequiredMenuItem);
        this.removeRequiredMenuItem = new JMenuItem("Remove requirement");
        this.removeRequiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeRequiredMenuItem);
        JMenuItem resetZoomMenuItem = new JMenuItem("Reset Zoom");
        resetZoomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.graphPanel.resetZoom();
            }
        });
        this.add(resetZoomMenuItem);
        JMenuItem resetLayoutMenuItem = new JMenuItem("Reset Layout");
        resetLayoutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.graphPanel.resetLayout();
            }
        });
        this.add(resetLayoutMenuItem);
        this.snapToGridMenuItem = new JCheckBoxMenuItem("Snap To Grid");
        this.snapToGridMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.snapToGrid = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.snapToGrid;
            }
        });
        this.add(this.snapToGridMenuItem);
        this.highlightRelationsMenuItem = new JCheckBoxMenuItem("Highlight Selected Relations");
        this.highlightRelationsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.highlightRelationLines = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.highlightRelationLines;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.highlightRelationsMenuItem);
        this.showBorderMenuItem = new JCheckBoxMenuItem("Show Diagram Border");
        this.showBorderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showDiagramBorder = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showDiagramBorder;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.showBorderMenuItem);
        JMenu diagramSizeMenuItem = new JMenu("Diagram Size");
        for (String currentString : this.graphPanelSize.getPreferredSizes()) {
            JMenuItem currentMenuItem = new JMenuItem(currentString);
            currentMenuItem.setActionCommand(currentString);
            currentMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GraphPanelContextMenu.this.setGraphPanelSize(evt.getActionCommand());
                }
            });
            diagramSizeMenuItem.add(currentMenuItem);
        }
        this.add(diagramSizeMenuItem);
        this.showSanguineLinesMenuItem = new JCheckBoxMenuItem("Show Sanguin Lines");
        this.showSanguineLinesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showSanguineLines = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showSanguineLines;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.showSanguineLinesMenuItem);
        this.showKinTermLinesMenuItem = new JCheckBoxMenuItem("Show Kin Term Lines");
        this.showKinTermLinesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showKinTermLines = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showKinTermLines;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.showKinTermLinesMenuItem);
        this.showLabelssMenuItem = new JCheckBoxMenuItem("Show Labels");
        this.showLabelssMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showLabels = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showLabels;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.showLabelssMenuItem);
        this.showKinTypeLabelssMenuItem = new JCheckBoxMenuItem("Show Kin Type Labels");
        this.showKinTypeLabelssMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showKinTypeLabels = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showKinTypeLabels;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.showKinTypeLabelssMenuItem);
        this.showKinTermLabelssMenuItem = new JCheckBoxMenuItem("Show Kin Term Labels");
        this.showKinTermLabelssMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showKinTermLabels = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showKinTermLabels;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.showKinTermLabelssMenuItem);
        this.showArchiveLinksMenuItem = new JCheckBoxMenuItem("Show Archive Links");
        this.showArchiveLinksMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showArchiveLinks = !((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.dataStoreSvg.showArchiveLinks;
                GraphPanelContextMenu.this.graphPanel.drawNodes();
            }
        });
        this.add(this.showArchiveLinksMenuItem);
        JMenuItem searchEntityServiceMenuItem = new JMenuItem("Search Entity Service");
        searchEntityServiceMenuItem.setToolTipText("Search the entity database for entities matching the current kin terms and populate he diagram with the results");
        searchEntityServiceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.add(searchEntityServiceMenuItem);
        this.saveFileMenuItem = new JMenuItem();
        this.saveFileMenuItem.setText("Save All Metadata Changes");
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilWindowManager.getSingleInstance().stopEditingInCurrentWindow();
                    ArbilDataNodeLoader.getSingleInstance().saveNodesNeedingSave(true);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.add(this.saveFileMenuItem);
    }

    private URI[] getSelectedUriArray() {
        URI[] selectedUriArray = new URI[this.selectedIdentifiers.length];
        for (int currentIndex = 0; currentIndex < this.selectedIdentifiers.length; ++currentIndex) {
            try {
                selectedUriArray[currentIndex] = new URI(this.graphPanel.getPathForElementId(this.selectedIdentifiers[currentIndex]));
                continue;
            }
            catch (URISyntaxException ex) {
                new ArbilBugCatcher().logError((Exception)ex);
            }
        }
        return selectedUriArray;
    }

    private void setGraphPanelSize(String sizeString) {
        this.graphPanelSize.setSize(sizeString);
        this.graphPanel.drawNodes();
    }

    public void show(Component cmpnt, int i, int i1) {
        this.xPos = cmpnt.getMousePosition().x;
        this.yPos = cmpnt.getMousePosition().y;
        this.selectedIdentifiers = this.graphPanel.getSelectedIds();
        int nonTransientNodeCount = 0;
        for (UniqueIdentifier uniqueIdentifier : this.selectedIdentifiers) {
            if (uniqueIdentifier.isTransientIdentifier() || uniqueIdentifier.isGraphicsIdentifier()) continue;
            ++nonTransientNodeCount;
        }
        if (this.addRelationEntityMenu != null) {
            this.duplicateEntitiesMenu.setVisible(nonTransientNodeCount > 0);
            this.mergeEntitiesMenu.setVisible(nonTransientNodeCount > 1);
            this.addRelationEntityMenu.setVisible(nonTransientNodeCount > 1);
            this.setAsEgoMenuItem.setVisible(nonTransientNodeCount > 0);
            this.addAsEgoMenuItem.setVisible(nonTransientNodeCount > 0);
            this.removeEgoMenuItem.setVisible(nonTransientNodeCount > 0);
            this.addAsRequiredMenuItem.setVisible(nonTransientNodeCount > 0);
            this.removeRequiredMenuItem.setVisible(nonTransientNodeCount > 0);
        } else {
            this.setAsEgoMenuItem.setVisible(false);
            this.addAsEgoMenuItem.setVisible(false);
            this.removeEgoMenuItem.setVisible(false);
            this.addAsRequiredMenuItem.setVisible(false);
            this.removeRequiredMenuItem.setVisible(false);
        }
        this.snapToGridMenuItem.setSelected(this.graphPanel.dataStoreSvg.snapToGrid);
        this.highlightRelationsMenuItem.setSelected(this.graphPanel.dataStoreSvg.highlightRelationLines);
        this.showBorderMenuItem.setSelected(this.graphPanel.dataStoreSvg.showDiagramBorder);
        this.showSanguineLinesMenuItem.setSelected(this.graphPanel.dataStoreSvg.showSanguineLines);
        this.showKinTermLinesMenuItem.setSelected(this.graphPanel.dataStoreSvg.showKinTermLines);
        this.showLabelssMenuItem.setSelected(this.graphPanel.dataStoreSvg.showLabels);
        this.showKinTypeLabelssMenuItem.setSelected(this.graphPanel.dataStoreSvg.showKinTypeLabels);
        this.showKinTermLabelssMenuItem.setSelected(this.graphPanel.dataStoreSvg.showKinTermLabels);
        this.showArchiveLinksMenuItem.setSelected(this.graphPanel.dataStoreSvg.showArchiveLinks);
        this.saveFileMenuItem.setEnabled(ArbilDataNodeLoader.getSingleInstance().nodesNeedSave());
        super.show(cmpnt, i, i1);
    }

    public void actionPerformed(ActionEvent e) {
        this.graphPanel.svgUpdateHandler.addGraphics(SvgUpdateHandler.GraphicsTypes.valueOf(e.getActionCommand()), this.xPos, this.yPos);
    }
}

