/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import org.basex.core.ProgressException;
import org.basex.core.Text;
import org.basex.util.Performance;

public abstract class Progress {
    protected boolean stopped;
    private Thread timeout;
    private Progress sub;

    public final String title() {
        return this.sub != null ? this.sub.title() : this.tit();
    }

    public final String detail() {
        return this.sub != null ? this.sub.detail() : this.det();
    }

    public final double progress() {
        return this.sub != null ? this.sub.progress() : this.prog();
    }

    public final <P extends Progress> P progress(P prog) {
        this.sub = prog;
        if (this.stopped) {
            this.sub.stop();
        }
        return prog;
    }

    public final void stop() {
        if (this.sub != null) {
            this.sub.stop();
        }
        this.stopped = true;
        this.stopTimeout();
    }

    public final void checkStop() {
        if (this.stopped) {
            throw new ProgressException();
        }
    }

    public void abort() {
        if (this.sub != null) {
            this.sub.abort();
        }
    }

    public final void startTimeout(final long sec) {
        if (sec == 0L) {
            return;
        }
        this.timeout = new Thread(){

            @Override
            public void run() {
                Performance.sleep(sec * 1000L);
                Progress.this.stop();
            }
        };
        this.timeout.start();
    }

    public final void stopTimeout() {
        if (this.timeout != null) {
            this.timeout.interrupt();
            this.timeout = null;
        }
    }

    protected String tit() {
        return Text.INFOWAIT;
    }

    protected String det() {
        return Text.INFOWAIT;
    }

    protected double prog() {
        return 0.0;
    }
}

