/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.handle.apps.gui.jwidget.GenDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.Util;

public class TextDataJPanel
extends GenDataJPanel {
    protected JTextField textField = new JTextField("", 30);

    public TextDataJPanel(byte[] type, boolean moreFlag, boolean editFlag) {
        this(type, moreFlag, editFlag, 0);
    }

    public TextDataJPanel(byte[] type, boolean moreFlag, boolean editFlag, int index) {
        super(moreFlag, editFlag, index);
        String labelStr = " " + Util.decodeString(type) + ": ";
        if (Util.equals(type, Common.STD_TYPE_URL)) {
            this.textField = new JTextField("http://", 30);
        }
        this.textField.setEditable(editFlag);
        this.panel.add((Component)new JLabel(labelStr, 4), AwtUtil.getConstraints(0, 1, 0.0, 0.0, 1, 1, true, true));
        this.panel.add((Component)this.textField, AwtUtil.getConstraints(1, 1, 1.0, 0.0, 1, 1, true, false));
        this.handlevalue.setType(type);
        if (this.handlevalue.hasType(Common.STD_TYPE_HSSECKEY)) {
            this.handlevalue.setAnyoneCanRead(false);
        }
    }

    public void setValueData(byte[] data) {
        if (data == Common.EMPTY_BYTE_ARRAY || data == null) {
            System.err.println("warning message: Handle value data is empty");
            return;
        }
        String str = Util.looksLikeBinary(data) ? Util.decodeHexString(data, false) : Util.decodeString(data);
        this.textField.setText(str);
        this.textField.setScrollOffset(0);
    }

    public byte[] getValueData() {
        try {
            String str = this.textField.getText().trim();
            return Util.encodeString(str);
        }
        catch (Exception e) {
            System.err.println("warning message: Exception at getValueData");
            return Common.EMPTY_BYTE_ARRAY;
        }
    }
}

