/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcher;

public class ArbilIcons {
    private static ApplicationVersionManager versionManager;
    public ImageIcon linorgIcon;
    public ImageIcon serverIcon;
    public ImageIcon directoryIcon;
    public ImageIcon computerIcon;
    public ImageIcon loadingIcon;
    private ImageIcon localicon;
    private ImageIcon remoteicon;
    private ImageIcon localWithArchiveHandle;
    private ImageIcon writtenresourceIcon;
    private ImageIcon videoIcon;
    private ImageIcon audioIcon;
    public ImageIcon corpusnodeColorIcon;
    private ImageIcon missingRedIcon;
    private ImageIcon picturesIcon;
    private ImageIcon questionRedIcon;
    public ImageIcon dataIcon;
    public ImageIcon dataCollectionIcon;
    public ImageIcon fieldIcon;
    private ImageIcon dataemptyIcon;
    public ImageIcon sessionColorIcon;
    public ImageIcon clarinIcon;
    public ImageIcon kinOathIcon;
    public ImageIcon catalogueColorIcon;
    private ImageIcon exclamationBlueIcon;
    private ImageIcon exclamationRedIcon;
    public ImageIcon languageIcon;
    private ImageIcon tickBlueIcon;
    private ImageIcon fileIcon;
    private ImageIcon tickGreenIcon;
    private ImageIcon infofileIcon;
    public ImageIcon favouriteIcon;
    public ImageIcon lockedIcon;
    public ImageIcon unLockedIcon;
    public ImageIcon vocabularyOpenIcon;
    public ImageIcon vocabularyOpenListIcon;
    public ImageIcon vocabularyClosedIcon;
    public ImageIcon vocabularyClosedListIcon;
    private static BugCatcher bugCatcher;
    private static ArbilIcons singleInstance;

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static synchronized ArbilIcons getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilIcons();
        }
        return singleInstance;
    }

    private ArbilIcons() {
        this.linorgIcon = new ImageIcon(versionManager.getApplicationVersion().getClass().getResource(ArbilIcons.versionManager.getApplicationVersion().applicationIconName));
        this.serverIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/server16x16.png"));
        this.directoryIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/directory16x16.png"));
        this.computerIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/computer16x16.png"));
        this.loadingIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/loading01.png"));
        this.localicon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/local.png"));
        this.remoteicon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/remote.png"));
        this.localWithArchiveHandle = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/localarchivehandle.png"));
        this.writtenresourceIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/writtenresource.png"));
        this.videoIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/video.png"));
        this.audioIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/audio.png"));
        this.corpusnodeColorIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/corpusnode_color.png"));
        this.missingRedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/notfound.png"));
        this.picturesIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/pictures.png"));
        this.questionRedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/question-red.png"));
        this.dataIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/data.png"));
        this.dataCollectionIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/datacollection.png"));
        this.fieldIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/field.png"));
        this.dataemptyIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/dataempty.png"));
        this.sessionColorIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/session_color.png"));
        this.clarinIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/clarinE.png"));
        this.kinOathIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/KinOath-16.png"));
        this.catalogueColorIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/catalogue.png"));
        this.exclamationBlueIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/exclamation-blue.png"));
        this.exclamationRedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/exclamation-red.png"));
        this.languageIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/language.png"));
        this.tickBlueIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/tick-blue.png"));
        this.fileIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/file.png"));
        this.tickGreenIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/tick-green.png"));
        this.infofileIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/infofile.png"));
        this.favouriteIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/favourite.png"));
        this.lockedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/lock.png"));
        this.unLockedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/unlock.png"));
        this.vocabularyOpenIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_open.png"));
        this.vocabularyOpenListIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_open_list.png"));
        this.vocabularyClosedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_closed.png"));
        this.vocabularyClosedListIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_closed_list.png"));
    }

    public ImageIcon getIconForNode(ArbilDataNode[] arbilNodeArray) {
        int currentIconXPosition = 0;
        int width = 0;
        int heightMax = 0;
        for (ArbilDataNode currentNode : arbilNodeArray) {
            width += currentNode.getIcon().getIconWidth();
            int height = currentNode.getIcon().getIconHeight();
            if (heightMax >= height) continue;
            heightMax = height;
        }
        BufferedImage bufferedImage = new BufferedImage(width, heightMax, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics().create();
        for (ArbilDataNode childNode : arbilNodeArray) {
            ImageIcon currentIcon = childNode.getIcon();
            currentIcon.paintIcon(null, g2d, currentIconXPosition, 0);
            currentIconXPosition += currentIcon.getIconWidth();
        }
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageIcon compositIcons(Object[] iconArray) {
        int widthTotal = 0;
        int heightMax = 0;
        for (Object currentIcon : iconArray) {
            int width = ((Icon)currentIcon).getIconWidth();
            int height = ((Icon)currentIcon).getIconHeight();
            if (currentIcon != this.missingRedIcon) {
                widthTotal += width;
            }
            if (heightMax >= height) continue;
            heightMax = height;
        }
        int currentIconXPosition = 0;
        BufferedImage bufferedImage = new BufferedImage(widthTotal, heightMax, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics().create();
        for (Object currentIcon : iconArray) {
            int yPos = (heightMax - ((Icon)currentIcon).getIconHeight()) / 2;
            if (currentIcon != this.missingRedIcon) {
                ((Icon)currentIcon).paintIcon(null, g2d, currentIconXPosition, yPos);
                currentIconXPosition += ((Icon)currentIcon).getIconWidth();
                continue;
            }
            ((Icon)currentIcon).paintIcon(null, g2d, currentIconXPosition - this.missingRedIcon.getIconWidth(), yPos);
        }
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }

    public Icon getIconForVocabulary(ArbilField cellObject) {
        if (cellObject.hasVocabulary()) {
            if (cellObject.isVocabularyOpen()) {
                if (cellObject.isVocabularyList()) {
                    return this.vocabularyOpenListIcon;
                }
                return this.vocabularyOpenIcon;
            }
            if (cellObject.isVocabularyList()) {
                return this.vocabularyClosedListIcon;
            }
            return this.vocabularyClosedIcon;
        }
        return null;
    }

    public Icon getIconForField(ArbilField field) {
        if (field.hasVocabulary()) {
            return this.getIconForVocabulary(field);
        }
        if (field.getLanguageId() != null) {
            return this.languageIcon;
        }
        return null;
    }

    public ImageIcon getIconForNode(ArbilDataNode arbilNode) {
        Vector<Icon> iconsVector = new Vector<Icon>();
        if (arbilNode.isLoading() || arbilNode.getParentDomNode().isMetaDataNode() && !arbilNode.getParentDomNode().isDataLoaded()) {
            iconsVector.add(this.loadingIcon);
        }
        if (arbilNode.isLocal()) {
            if (arbilNode.isMetaDataNode()) {
                if (arbilNode.matchesRemote == 0) {
                    if (arbilNode.archiveHandle == null) {
                        iconsVector.add(this.localicon);
                    } else {
                        iconsVector.add(this.localWithArchiveHandle);
                    }
                } else {
                    iconsVector.add(this.remoteicon);
                }
            }
        } else {
            iconsVector.add(this.remoteicon);
        }
        if (arbilNode.resourceFileServerResponse == 200) {
            iconsVector.add(this.unLockedIcon);
        } else if (arbilNode.resourceFileServerResponse == 302) {
            iconsVector.add(this.lockedIcon);
        }
        String mimeTypeForNode = arbilNode.getAnyMimeType();
        if (arbilNode.isMetaDataNode()) {
            if (arbilNode.isChildNode()) {
                if (arbilNode.isContainerNode()) {
                    iconsVector.add(this.dataCollectionIcon);
                } else if (arbilNode.isEmptyMetaNode()) {
                    iconsVector.add(this.dataemptyIcon);
                } else {
                    iconsVector.add(this.dataIcon);
                }
            } else if (arbilNode.isSession()) {
                iconsVector.add(this.sessionColorIcon);
            } else if (arbilNode.isCatalogue()) {
                iconsVector.add(this.catalogueColorIcon);
            } else if (arbilNode.isCorpus()) {
                iconsVector.add(this.corpusnodeColorIcon);
            } else if (arbilNode.isCmdiMetaDataNode()) {
                iconsVector.add(MetadataFormat.getFormatIcon(arbilNode.getURI().getPath()));
            } else if (arbilNode.isDataLoaded()) {
                iconsVector.add(this.fileIcon);
            }
        } else if (mimeTypeForNode != null) {
            if ((mimeTypeForNode = mimeTypeForNode.toLowerCase()).contains("audio")) {
                iconsVector.add(this.audioIcon);
            } else if (mimeTypeForNode.contains("video")) {
                iconsVector.add(this.videoIcon);
            } else if (mimeTypeForNode.contains("image")) {
                iconsVector.add(this.picturesIcon);
            } else if (mimeTypeForNode.contains("text")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("xml")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("chat")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("pdf")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("kml")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("manual/mediafile")) {
                iconsVector.add(this.picturesIcon);
            } else if (mimeTypeForNode.contains("manual/writtenresource")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("unspecified") || mimeTypeForNode.length() == 0) {
                iconsVector.add(this.fileIcon);
            } else if (mimeTypeForNode.contains("unknown")) {
                iconsVector.add(this.questionRedIcon);
            } else if (mimeTypeForNode.length() > 0) {
                iconsVector.add(this.questionRedIcon);
                bugCatcher.logError(mimeTypeForNode, new Exception("Icon not found for file type: " + mimeTypeForNode));
            }
        } else if (arbilNode.isInfoLink) {
            iconsVector.add(this.infofileIcon);
        } else if (arbilNode.hasResource()) {
            iconsVector.add(this.fileIcon);
        } else if (arbilNode.isDirectory()) {
            iconsVector.add(UIManager.getIcon("FileView.directoryIcon"));
        } else {
            iconsVector.add(this.fileIcon);
        }
        if (arbilNode.fileNotFound || arbilNode.resourceFileNotFound()) {
            if (arbilNode.isResourceSet()) {
                iconsVector.add(this.missingRedIcon);
            } else {
                iconsVector.add(this.questionRedIcon);
            }
        }
        if (!arbilNode.isMetaDataNode() && arbilNode.matchesInCache + arbilNode.matchesRemote > 0) {
            if (arbilNode.matchesRemote > 0) {
                iconsVector.add(this.tickGreenIcon);
            } else {
                iconsVector.add(this.tickBlueIcon);
            }
        }
        if (arbilNode.isFavorite()) {
            iconsVector.add(this.favouriteIcon);
        }
        return this.compositIcons(iconsVector.toArray());
    }

    static {
        singleInstance = null;
    }
}

