/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.Serializable;
import java.net.URI;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.ArbilVocabularies;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.DocumentationLanguages;
import nl.mpi.arbil.data.FieldChangeTriggers;
import nl.mpi.arbil.userstorage.SessionStorage;

public class ArbilField
implements Serializable {
    private transient ArbilDataNode parentDataNode;
    private URI parentDataNodeURI;
    public String xmlPath;
    private String translatedPath = null;
    private String fieldValue;
    public String originalFieldValue = this.fieldValue = "";
    private String cvUrlString;
    private int fieldOrder = -1;
    private ArbilVocabulary fieldVocabulary = null;
    private boolean hasVocabularyType = false;
    private boolean vocabularyIsOpen;
    private boolean vocabularyIsList;
    private String keyName = null;
    private String originalKeyName = null;
    private String languageId = null;
    private String originalLanguageId = null;
    private int isRequiredField = -1;
    private int canValidateField = -1;
    private int siblingCount;
    private static SessionStorage sessionStorage;
    private static DataNodeLoader dataNodeLoader;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public ArbilField(int fieldOrderLocal, ArbilDataNode localParentDataNode, String tempPath, String tempValue, int tempSiblingCount) {
        this.fieldOrder = fieldOrderLocal;
        this.setParentDataNode(localParentDataNode);
        this.originalFieldValue = this.fieldValue = tempValue;
        this.xmlPath = tempPath;
        this.siblingCount = tempSiblingCount;
    }

    public boolean isRequiredField() {
        if (this.isRequiredField < 0) {
            this.isRequiredField = 0;
            String fullXmlPath = this.getGenericFullXmlPath();
            for (String currentRequiredField : this.getParentDataNode().getNodeTemplate().requiredFields) {
                if (!fullXmlPath.matches(currentRequiredField)) continue;
                this.isRequiredField = 1;
                break;
            }
        }
        return this.isRequiredField == 1;
    }

    public boolean fieldValueValidates() {
        return this.fieldValueValidatesToTemplate() && this.fieldValueValidatesToVocabulary();
    }

    private boolean fieldValueValidatesToVocabulary() {
        if (this.hasVocabulary() && !this.isVocabularyOpen()) {
            return null != this.getVocabulary().findVocabularyItem(this.fieldValue);
        }
        return true;
    }

    private boolean fieldValueValidatesToTemplate() {
        boolean isValidValue = true;
        if (this.canValidateField != 0) {
            this.canValidateField = 0;
            String fullXmlPath = this.getGenericFullXmlPath();
            for (String[] currentRequiredField : this.getParentDataNode().getNodeTemplate().fieldConstraints) {
                if (!fullXmlPath.matches(currentRequiredField[0])) continue;
                this.canValidateField = 1;
                isValidValue = this.fieldValue.matches(currentRequiredField[1]);
                break;
            }
        }
        return isValidValue;
    }

    private boolean valuesDiffer(String leftString, String rightString) {
        if (leftString == null) {
            return rightString != null;
        }
        return !leftString.equals(rightString);
    }

    public boolean fieldNeedsSaveToDisk() {
        if (this.valuesDiffer(this.originalFieldValue, this.fieldValue)) {
            return true;
        }
        if (this.valuesDiffer(this.originalLanguageId, this.languageId)) {
            return true;
        }
        return this.valuesDiffer(this.originalKeyName, this.keyName);
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public String getFieldValueForXml() {
        ArbilVocabularyItem vocabularyItem;
        if (this.hasVocabulary() && (vocabularyItem = this.getVocabulary().findVocabularyItem(this.getFieldValue())) != null) {
            return vocabularyItem.getValue();
        }
        return this.getFieldValue();
    }

    public String getGenericFullXmlPath() {
        return this.getFullXmlPath().replaceAll("\\(\\d*?\\)", "(x)").replaceFirst("\\(x\\)$", "");
    }

    public String getFullXmlPath() {
        String[] pathStringArray = this.getParentDataNode().getUrlString().split("#");
        String returnValue = pathStringArray.length > 1 ? pathStringArray[1] + this.xmlPath : this.xmlPath;
        if (this.siblingCount > 0) {
            returnValue = returnValue + "(" + (this.siblingCount + 1) + ")";
        }
        return returnValue;
    }

    public void setFieldValue(String fieldValueToBe, boolean updateUI, boolean excludeFromUndoHistory) {
        if (!this.fieldValue.equals(fieldValueToBe = fieldValueToBe.trim())) {
            if (!excludeFromUndoHistory) {
                ArbilJournal.getSingleInstance().recordFieldChange(this, this.fieldValue, fieldValueToBe, ArbilJournal.UndoType.Value);
            }
            ArbilJournal.getSingleInstance().saveJournalEntry(this.getParentDataNode().getUrlString(), this.getFullXmlPath(), this.fieldValue, fieldValueToBe, "edit");
            this.fieldValue = fieldValueToBe;
            new FieldChangeTriggers().actOnChange(this);
            this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
        }
    }

    public boolean hasVocabulary() {
        return this.fieldVocabulary != null;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageIdLocal, boolean updateUI, boolean excludeFromUndoHistory) {
        String oldLanguageId = this.getLanguageId();
        boolean valueChanged = false;
        if (languageIdLocal == null) {
            valueChanged = oldLanguageId != null;
        } else if (!languageIdLocal.equals(oldLanguageId)) {
            valueChanged = true;
        }
        if (valueChanged) {
            if (!excludeFromUndoHistory) {
                ArbilJournal.getSingleInstance().recordFieldChange(this, this.getLanguageId(), languageIdLocal, ArbilJournal.UndoType.LanguageId);
            }
            ArbilJournal.getSingleInstance().saveJournalEntry(this.getParentDataNode().getUrlString(), this.getFullXmlPath() + ":LanguageId", oldLanguageId, languageIdLocal, "edit");
            this.languageId = languageIdLocal;
            this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
        }
    }

    public ArbilVocabulary getVocabulary() {
        return this.fieldVocabulary;
    }

    public ArbilField[] getSiblingField(String pathString) {
        for (ArbilField[] tempField : (ArbilField[][])this.getParentDataNode().getFields().values().toArray((T[])new ArbilField[0][])) {
            if (!tempField[0].getFullXmlPath().equals(pathString) && !tempField[0].getGenericFullXmlPath().equals(pathString)) continue;
            return tempField;
        }
        return null;
    }

    public boolean isDisplayable() {
        return this.fieldValue != null && !this.xmlPath.contains("CorpusLink") && !this.xmlPath.endsWith(".Keys") && !this.xmlPath.endsWith(".History");
    }

    public void finishLoading() {
    }

    public void revertChanges() {
        this.setFieldValue(this.originalFieldValue, false, false);
        this.setLanguageId(this.originalLanguageId, false, false);
        this.setKeyName(this.originalKeyName, false, false);
        boolean updateUI = true;
        this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
    }

    public void setFieldAttribute(String cvType, String cvUrlString, String languageIdLocal, String keyNameLocal) {
        this.originalLanguageId = this.languageId = languageIdLocal;
        this.originalKeyName = this.keyName = keyNameLocal;
        this.cvUrlString = cvUrlString;
        this.hasVocabularyType = false;
        if (cvType != null) {
            if (cvType.equals("OpenVocabularyList")) {
                this.vocabularyIsList = true;
                this.vocabularyIsOpen = true;
                this.hasVocabularyType = true;
            } else if (cvType.equals("OpenVocabulary")) {
                this.vocabularyIsList = false;
                this.vocabularyIsOpen = true;
                this.hasVocabularyType = true;
            } else if (cvType.equals("ClosedVocabularyList")) {
                this.vocabularyIsList = true;
                this.vocabularyIsOpen = false;
                this.hasVocabularyType = true;
            } else if (cvType.equals("ClosedVocabulary")) {
                this.vocabularyIsList = false;
                this.vocabularyIsOpen = false;
                this.hasVocabularyType = true;
            }
        }
        this.loadVocabulary();
    }

    public void loadVocabulary() {
        ArbilVocabularyItem vocabItem;
        if (this.hasVocabularyType) {
            if (this.cvUrlString != null && this.cvUrlString.length() > 0) {
                this.fieldVocabulary = ArbilVocabularies.getSingleInstance().getVocabulary(this, this.cvUrlString);
                if (this.cvUrlString.equals(DocumentationLanguages.getLanguageVocabularyUrl())) {
                    this.fieldVocabulary.setFilter(DocumentationLanguages.getSingleInstance());
                }
            }
        } else if (this.getParentDataNode().getParentDomNode().nodeTemplate != null) {
            String strippedXmlPath = this.getGenericFullXmlPath().replaceAll("\\(x\\)", "");
            this.fieldVocabulary = this.getParentDataNode().getParentDomNode().nodeTemplate.getFieldVocabulary(strippedXmlPath);
        }
        if (this.fieldVocabulary != null && (vocabItem = this.fieldVocabulary.getVocabularyItemByCode(this.fieldValue)) != null) {
            this.fieldValue = vocabItem.getDisplayValue();
        }
    }

    public String toString() {
        return this.getFieldValue();
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean setKeyName(String keyNameLocal, boolean updateUI, boolean excludeFromUndoHistory) {
        System.out.println("setKeyName: " + keyNameLocal);
        String lastValue = this.getKeyName();
        System.out.println("lastValue: " + lastValue);
        if (lastValue != null && !lastValue.equals(keyNameLocal)) {
            if (!excludeFromUndoHistory) {
                ArbilJournal.getSingleInstance().recordFieldChange(this, this.getKeyName(), keyNameLocal, ArbilJournal.UndoType.KeyName);
            }
            ArbilJournal.getSingleInstance().saveJournalEntry(this.getParentDataNode().getUrlString(), this.getFullXmlPath(), lastValue, keyNameLocal, "editkeyname");
            this.keyName = keyNameLocal;
            this.translatedPath = null;
            this.getTranslateFieldName();
            this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
            if (this.getParentDataNode().getNeedsSaveToDisk(false)) {
                this.getParentDataNode().saveChangesToCache(true);
            }
            this.getParentDataNode().reloadNode();
            return true;
        }
        return false;
    }

    public String getTranslateFieldName() {
        if (this.translatedPath == null) {
            String fieldName = this.xmlPath;
            fieldName = fieldName.replace(".METATRANSCRIPT.Session.MDGroup", "");
            fieldName = fieldName.replace(".METATRANSCRIPT.Session", "");
            fieldName = fieldName.replace(".METATRANSCRIPT.Corpus", "");
            fieldName = fieldName.replace(".METATRANSCRIPT.Catalogue", "");
            if ((fieldName = fieldName.replaceFirst("^\\.CMD\\.Components\\.[^\\.]+\\.", "")).endsWith("Keys.Key") && this.keyName != null) {
                fieldName = fieldName + "." + this.keyName;
            }
            if (fieldName.startsWith(".")) {
                fieldName = fieldName.substring(1);
            }
            if (sessionStorage.isUseLanguageIdInColumnName() && this.getLanguageId() != null && this.getLanguageId().length() > 0) {
                fieldName = fieldName + " [" + this.getLanguageId() + "]";
            }
            this.translatedPath = fieldName;
        }
        return this.translatedPath;
    }

    public boolean isVocabularyOpen() {
        return this.vocabularyIsOpen;
    }

    public boolean isVocabularyList() {
        return this.vocabularyIsList;
    }

    public synchronized ArbilDataNode getParentDataNode() {
        if (this.parentDataNode == null && this.parentDataNodeURI != null) {
            this.parentDataNode = dataNodeLoader.getArbilDataNode(null, this.parentDataNodeURI);
        }
        return this.parentDataNode;
    }

    public final synchronized void setParentDataNode(ArbilDataNode parentDataNode) {
        this.parentDataNode = parentDataNode;
        this.parentDataNodeURI = parentDataNode != null ? parentDataNode.getURI() : null;
    }
}

