/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilWindowManager;

public class PreviewSplitPanel
extends JSplitPane {
    private static PreviewSplitPanel instance;
    private ArbilTable previewTable = null;
    private boolean previewTableShown = false;
    private JScrollPane rightScrollPane;
    private JLabel previewHiddenColumnLabel;
    private JPanel previewPanel;
    private Container parentComponent;

    public static synchronized PreviewSplitPanel getInstance() {
        if (instance == null) {
            instance = new PreviewSplitPanel();
        }
        return instance;
    }

    private PreviewSplitPanel() {
        this.setDividerSize(5);
        this.setOrientation(0);
        this.setName("rightSplitPane");
        this.previewHiddenColumnLabel = new JLabel(" ");
        this.previewTable = new ArbilTable(new ArbilTableModel(), "Preview");
        this.previewTable.getArbilTableModel().setHiddenColumnsLabel(this.previewHiddenColumnLabel);
        this.rightScrollPane = new JScrollPane(this.previewTable);
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.add((Component)this.rightScrollPane, "Center");
        this.previewPanel.add((Component)this.previewHiddenColumnLabel, "South");
    }

    public void setPreviewPanel(boolean showPreview) {
        TableCellEditor currentCellEditor;
        JComponent selectedComponent;
        if (this.parentComponent == null) {
            this.parentComponent = this.getParent();
        }
        if (!showPreview) {
            this.parentComponent.remove(this);
            selectedComponent = ArbilWindowManager.getSingleInstance().desktopPane;
            currentCellEditor = this.previewTable.getCellEditor();
            if (currentCellEditor != null) {
                currentCellEditor.stopCellEditing();
            }
            this.previewTable.getArbilTableModel().removeAllArbilDataNodeRows();
        } else {
            this.remove(ArbilWindowManager.getSingleInstance().desktopPane);
            this.setDividerLocation(0.25);
            this.setTopComponent(this.previewPanel);
            this.setBottomComponent(ArbilWindowManager.getSingleInstance().desktopPane);
            currentCellEditor = this.previewTable.getCellEditor();
            if (currentCellEditor != null) {
                currentCellEditor.stopCellEditing();
            }
            this.previewTable.getArbilTableModel().removeAllArbilDataNodeRows();
            selectedComponent = this;
        }
        if (this.parentComponent instanceof JSplitPane) {
            int parentDividerLocation = ((JSplitPane)this.parentComponent).getDividerLocation();
            ((JSplitPane)this.parentComponent).setBottomComponent(selectedComponent);
            ((JSplitPane)this.parentComponent).setDividerLocation(parentDividerLocation);
        } else {
            this.parentComponent.add(selectedComponent);
        }
        this.previewTableShown = showPreview;
    }

    public static boolean isPreviewTableShown() {
        return PreviewSplitPanel.getInstance().previewTableShown;
    }

    public ArbilTable getPreviewTable() {
        return this.previewTable;
    }
}

