/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.ArbilVocabularies;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.ui.ArbilHelp;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.LanguageListDialogue;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.arbil.util.ArbilMimeHashQueue;

public class ArbilMenuBar
extends JMenuBar {
    public static final JMenu windowMenu = new JMenu();
    private boolean macOsMenu = false;
    private JMenuItem saveFileMenuItem = new JMenuItem();
    private JMenuItem showChangedNodesMenuItem = new JMenuItem();
    private JCheckBoxMenuItem saveWindowsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem shortCutKeysjMenuItem = new JMenuItem();
    private JMenuItem arbilForumMenuItem = new JMenuItem();
    private JMenuItem checkForUpdatesMenuItem = new JMenuItem();
    private JMenuItem viewErrorLogMenuItem = new JMenuItem();
    private JCheckBoxMenuItem showSelectionPreviewCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem templatesMenu = new JMenuItem();
    private JCheckBoxMenuItem trackTableSelectionCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem useLanguageIdInColumnNameCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem undoMenuItem = new JMenuItem();
    private JMenu setCacheDirectoryMenu = new JMenu();
    private JMenu viewMenu = new JMenu();
    private JMenuItem resetWindowsMenuItem = new JMenuItem();
    private JMenuItem closeWindowsMenuItem = new JMenuItem();
    private JMenu optionsMenu = new JMenu();
    private JMenuItem pasteMenuItem = new JMenuItem();
    private JMenuItem printHelpMenuItem = new JMenuItem();
    private JMenuItem redoMenuItem = new JMenuItem();
    public JCheckBoxMenuItem checkNewVersionAtStartCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem copyMenuItem = new JMenuItem();
    private JCheckBoxMenuItem copyNewResourcesCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem checkResourcePermissionsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem schemaCheckLocalFiles = new JCheckBoxMenuItem();
    private JMenuItem editPreferredLanguagesMenuItem = new JMenuItem();
    private JMenuItem editFieldViewsMenuItem = new JMenuItem();
    private JMenuItem updateAllLoadedVocabulariesMenuItem = new JMenuItem();
    private JMenu editMenu = new JMenu();
    private JMenu fileMenu = new JMenu();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuItem = new JMenuItem();
    private JMenuItem importMenuItem = new JMenuItem();
    private PreviewSplitPanel previewSplitPanel;
    private JApplet containerApplet = null;
    private JMenuItem exitMenuItem = new JMenuItem(){

        public boolean isVisible() {
            return !ArbilMenuBar.this.isMacOsMenu();
        }
    };
    private JMenuItem aboutMenuItem = new JMenuItem(){

        public boolean isVisible() {
            return !ArbilMenuBar.this.isMacOsMenu();
        }
    };
    private static ApplicationVersionManager versionManager;

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public ArbilMenuBar(PreviewSplitPanel previewSplitPanelLocal, JApplet containerAppletLocal) {
        this.containerApplet = containerAppletLocal;
        this.previewSplitPanel = previewSplitPanelLocal;
        this.initFileMenu();
        this.initEditMenu();
        this.initOptionsMenu();
        this.initWindowMenu();
        this.initHelpMenu();
        this.setUpHotKeys();
    }

    private void initFileMenu() {
        this.fileMenu.setText("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.saveFileMenuItem.setEnabled(ArbilDataNodeLoader.getSingleInstance().nodesNeedSave());
                ArbilMenuBar.this.showChangedNodesMenuItem.setEnabled(ArbilDataNodeLoader.getSingleInstance().nodesNeedSave());
            }
        });
        this.saveFileMenuItem.setText("Save Changes");
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilWindowManager.getSingleInstance().stopEditingInCurrentWindow();
                    ArbilDataNodeLoader.getSingleInstance().saveNodesNeedingSave(true);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.fileMenu.add(this.saveFileMenuItem);
        this.showChangedNodesMenuItem.setText("Show Modified Nodes");
        this.showChangedNodesMenuItem.setEnabled(false);
        this.showChangedNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArrayList<ArbilDataNode> individualChangedNodes = new ArrayList<ArbilDataNode>();
                    for (ArbilDataNode currentTestable : ArbilDataNodeLoader.getSingleInstance().getNodesNeedSave()) {
                        if (currentTestable.hasChangedFields()) {
                            individualChangedNodes.add(currentTestable);
                        }
                        for (ArbilDataNode currentChildSaveable : currentTestable.getAllChildren()) {
                            if (!currentChildSaveable.hasChangedFields()) continue;
                            individualChangedNodes.add(currentChildSaveable);
                        }
                    }
                    ArbilWindowManager.getSingleInstance().openFloatingTable(individualChangedNodes.toArray(new ArbilDataNode[0]), "Modified Nodes");
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.fileMenu.add(this.showChangedNodesMenuItem);
        this.importMenuItem.setText("Import...");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.importMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.exitMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        if (this.containerApplet == null) {
            this.fileMenu.add(this.exitMenuItem);
        } else {
            String loggedInUserName = this.containerApplet.getParameter("UserName");
            if (loggedInUserName == null) {
                loggedInUserName = "unknown user";
            }
            JMenuItem logoutButton = new JMenuItem("Log Out (" + loggedInUserName + ")");
            logoutButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String logoutUrl = ArbilMenuBar.this.containerApplet.getParameter("LogoutUrl");
                    try {
                        if (ArbilMenuBar.this.containerApplet != null) {
                            ArbilMenuBar.this.containerApplet.getAppletContext().showDocument(new URL(logoutUrl));
                        }
                    }
                    catch (MalformedURLException ex) {
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Invalid logout url:\n" + logoutUrl, "Logout Error");
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            this.fileMenu.add(logoutButton);
        }
        this.add(this.fileMenu);
    }

    private void initEditMenu() {
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.undoMenuItem.setEnabled(ArbilJournal.getSingleInstance().canUndo());
                ArbilMenuBar.this.redoMenuItem.setEnabled(ArbilJournal.getSingleInstance().canRedo());
            }
        });
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setEnabled(false);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.setEnabled(false);
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilJournal.getSingleInstance().undoFromFieldChangeHistory();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilJournal.getSingleInstance().redoFromFieldChangeHistory();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.add(this.editMenu);
    }

    private void initOptionsMenu() {
        this.optionsMenu.setText("Options");
        this.templatesMenu.setText("Templates & Profiles...");
        this.templatesMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TemplateDialogue.showTemplatesDialogue();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.templatesMenu);
        this.setCacheDirectoryMenu.setText("Local Corpus Storage Directory");
        this.setCacheDirectoryMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.setCacheDirectoryMenu.removeAll();
                JMenuItem cacheDirectoryMenuItem = new JMenuItem();
                cacheDirectoryMenuItem.setText(ArbilSessionStorage.getSingleInstance().getCacheDirectory().getAbsolutePath());
                cacheDirectoryMenuItem.setEnabled(false);
                JMenuItem changeCacheDirectoryMenuItem = new JMenuItem();
                changeCacheDirectoryMenuItem.setText("Move Local Corpus Storage Directory...");
                changeCacheDirectoryMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            ArbilWindowManager.getSingleInstance().offerUserToSaveChanges();
                            File[] selectedFiles = ArbilWindowManager.getSingleInstance().showFileSelectBox("Move Local Corpus Storage Directory", true, false, false);
                            if (selectedFiles != null && selectedFiles.length > 0) {
                                ArbilSessionStorage.getSingleInstance().changeCacheDirectory(selectedFiles[0], true);
                            }
                        }
                        catch (Exception ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                        }
                    }
                });
                ArbilMenuBar.this.setCacheDirectoryMenu.add(cacheDirectoryMenuItem);
                ArbilMenuBar.this.setCacheDirectoryMenu.add(changeCacheDirectoryMenuItem);
            }
        });
        this.optionsMenu.add(this.setCacheDirectoryMenu);
        this.editPreferredLanguagesMenuItem.setText("Edit Language List...");
        this.editPreferredLanguagesMenuItem.setEnabled(true);
        this.editPreferredLanguagesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LanguageListDialogue.showLanguageDialogue();
            }
        });
        this.optionsMenu.add(this.editPreferredLanguagesMenuItem);
        this.updateAllLoadedVocabulariesMenuItem.setText("Re-download Current Vocabularies");
        this.updateAllLoadedVocabulariesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArbilVocabularies.getSingleInstance().redownloadCurrentlyLoadedVocabularies();
            }
        });
        this.optionsMenu.add(this.updateAllLoadedVocabulariesMenuItem);
        this.saveWindowsCheckBoxMenuItem.setSelected(ArbilSessionStorage.getSingleInstance().loadBoolean("saveWindows", true));
        this.saveWindowsCheckBoxMenuItem.setText("Save Windows on Exit");
        this.optionsMenu.add(this.saveWindowsCheckBoxMenuItem);
        this.showSelectionPreviewCheckBoxMenuItem.setSelected(ArbilSessionStorage.getSingleInstance().loadBoolean("showSelectionPreview", true));
        this.previewSplitPanel.setPreviewPanel(this.showSelectionPreviewCheckBoxMenuItem.getState());
        this.showSelectionPreviewCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.showSelectionPreviewCheckBoxMenuItem.setText("Show Selection Preview");
        this.showSelectionPreviewCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.previewSplitPanel.setPreviewPanel(ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItem.getState());
                    ArbilSessionStorage.getSingleInstance().saveBoolean("showSelectionPreview", ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.showSelectionPreviewCheckBoxMenuItem);
        this.checkNewVersionAtStartCheckBoxMenuItem.setSelected(ArbilSessionStorage.getSingleInstance().loadBoolean("checkNewVersionAtStart", true));
        this.checkNewVersionAtStartCheckBoxMenuItem.setText("Check for new version on start");
        this.optionsMenu.add(this.checkNewVersionAtStartCheckBoxMenuItem);
        this.copyNewResourcesCheckBoxMenuItem.setSelected(MetadataReader.getSingleInstance().copyNewResourcesToCache);
        this.copyNewResourcesCheckBoxMenuItem.setText("Copy new resources into cache");
        this.copyNewResourcesCheckBoxMenuItem.setToolTipText("When adding a new resource to a session this options will copy the file into the local cache rather than linking to its current location. This option can make a considerable difference to disk use if you are handling large files.");
        this.copyNewResourcesCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MetadataReader.getSingleInstance().copyNewResourcesToCache = ArbilMenuBar.this.copyNewResourcesCheckBoxMenuItem.isSelected();
                ArbilSessionStorage.getSingleInstance().saveBoolean("copyNewResources", ArbilMenuBar.this.copyNewResourcesCheckBoxMenuItem.isSelected());
            }
        });
        this.optionsMenu.add(this.copyNewResourcesCheckBoxMenuItem);
        this.checkResourcePermissionsCheckBoxMenuItem.setSelected(ArbilMimeHashQueue.getSingleInstance().isCheckResourcePermissions());
        this.checkResourcePermissionsCheckBoxMenuItem.setText("Check permissions for remote resources");
        this.checkResourcePermissionsCheckBoxMenuItem.setToolTipText("This option checks the server permissions for remote resources and shows icons accordingly.");
        this.checkResourcePermissionsCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ArbilMimeHashQueue.getSingleInstance().setCheckResourcePermissions(ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected());
                ArbilSessionStorage.getSingleInstance().saveBoolean("checkResourcePermissions", ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected());
                ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("The setting change will be effective when Arbil is restarted.", "Check permissions for remote resources");
            }
        });
        this.optionsMenu.add(this.checkResourcePermissionsCheckBoxMenuItem);
        this.schemaCheckLocalFiles.setText("Always check local metadata files for XML conformance");
        this.schemaCheckLocalFiles.setSelected(ArbilDataNodeLoader.getSingleInstance().isSchemaCheckLocalFiles());
        this.schemaCheckLocalFiles.setToolTipText("This option checks all local metadata files for XML conformance every time they are loaded. If the metadata file does not validate against the schema it will be highlighted red in the tree.");
        this.schemaCheckLocalFiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ArbilDataNodeLoader.getSingleInstance().setSchemaCheckLocalFiles(ArbilMenuBar.this.schemaCheckLocalFiles.isSelected());
                ArbilSessionStorage.getSingleInstance().saveBoolean("schemaCheckLocalFiles", ArbilMenuBar.this.schemaCheckLocalFiles.isSelected());
            }
        });
        this.optionsMenu.add(this.schemaCheckLocalFiles);
        this.trackTableSelectionCheckBoxMenuItem.setSelected(ArbilSessionStorage.getSingleInstance().isTrackTableSelection());
        this.trackTableSelectionCheckBoxMenuItem.setText("Track Table Selection in Tree");
        this.trackTableSelectionCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilSessionStorage.getSingleInstance().setTrackTableSelection(ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.getState());
                    ArbilSessionStorage.getSingleInstance().saveBoolean("trackTableSelection", ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.trackTableSelectionCheckBoxMenuItem.setEnabled(false);
        this.optionsMenu.add(this.trackTableSelectionCheckBoxMenuItem);
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(ArbilSessionStorage.getSingleInstance().isUseLanguageIdInColumnName());
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setText("Show Language in Column Name");
        this.useLanguageIdInColumnNameCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilWindowManager.getSingleInstance().offerUserToSaveChanges();
                    ArbilSessionStorage.getSingleInstance().setUseLanguageIdInColumnName(ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.getState());
                    ArbilSessionStorage.getSingleInstance().saveBoolean("useLanguageIdInColumnName", ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.isSelected());
                    ArbilDataNodeLoader.getSingleInstance().requestReloadAllNodes();
                }
                catch (Exception ex) {
                    ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(ArbilSessionStorage.getSingleInstance().isUseLanguageIdInColumnName());
                }
            }
        });
        this.optionsMenu.add(this.useLanguageIdInColumnNameCheckBoxMenuItem);
        this.add(this.optionsMenu);
        this.optionsMenu.add(new JSeparator());
        this.viewMenu.setText("Column View for new tables");
        this.viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.viewMenuMenuSelected(evt);
            }
        });
        this.optionsMenu.add(this.viewMenu);
        this.editFieldViewsMenuItem.setText("Edit Column Views");
        this.editFieldViewsMenuItem.setEnabled(false);
        this.optionsMenu.add(this.editFieldViewsMenuItem);
    }

    private void initWindowMenu() {
        windowMenu.setText("Window");
        this.resetWindowsMenuItem.setText("Reset window locations");
        this.resetWindowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ArbilWindowManager.getSingleInstance().showConfirmDialogBox("Reset all windows to default size and location?", "Reset windows")) {
                    ArbilWindowManager.getSingleInstance().resetWindows();
                }
            }
        });
        this.closeWindowsMenuItem.setText("Close all windows");
        this.closeWindowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ArbilWindowManager.getSingleInstance().showConfirmDialogBox("Close all windows?", "Close windows")) {
                    ArbilWindowManager.getSingleInstance().closeAllWindows();
                }
            }
        });
        windowMenu.add(this.closeWindowsMenuItem);
        windowMenu.add(this.resetWindowsMenuItem);
        windowMenu.add(new JSeparator());
        this.add(windowMenu);
    }

    private void initHelpMenu() {
        this.helpMenu.setText("Help");
        this.helpMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.viewErrorLogMenuItem.setEnabled(new ArbilBugCatcher().getLogFile().exists());
            }
        });
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.aboutMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.helpMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.arbilForumMenuItem.setText("Arbil Forum (Website)");
        this.arbilForumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    GuiHelper.getSingleInstance().openFileInExternalApplication(new URI("http://www.lat-mpi.eu/tools/arbil/Arbil-forum/"));
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.arbilForumMenuItem);
        this.viewErrorLogMenuItem.setText("View Error Log");
        this.viewErrorLogMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    GuiHelper.getSingleInstance().openFileInExternalApplication(new ArbilBugCatcher().getLogFile().toURI());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.viewErrorLogMenuItem);
        this.checkForUpdatesMenuItem.setText("Check for Updates");
        this.checkForUpdatesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!versionManager.forceUpdateCheck()) {
                        ApplicationVersion appVersion = versionManager.getApplicationVersion();
                        String versionString = appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision;
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No updates found, current version is " + versionString, "Check for Updates");
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.checkForUpdatesMenuItem);
        this.shortCutKeysjMenuItem.setText("Short Cut Keys");
        this.shortCutKeysjMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.shortCutKeysjMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.shortCutKeysjMenuItem);
        this.printHelpMenuItem.setText("Print Help File");
        this.printHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.printHelpMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.printHelpMenuItem);
        this.add(this.helpMenu);
        this.printHelpMenuItem.setVisible(false);
    }

    private void setUpHotKeys() {
        this.saveFileMenuItem.setMnemonic(83);
        this.saveFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if ((((KeyEvent)event).isMetaDown() || ((KeyEvent)event).isControlDown()) && event.getID() == 402) {
                    for (Component compFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); compFocusOwner != null; compFocusOwner = compFocusOwner.getParent()) {
                        TableCellEditor currentEditor;
                        if (!(compFocusOwner instanceof ArbilTable) || (currentEditor = ((ArbilTable)compFocusOwner).getCellEditor()) == null) continue;
                        currentEditor.stopCellEditing();
                        break;
                    }
                    if (((KeyEvent)event).getKeyCode() == 83) {
                        ArbilWindowManager.getSingleInstance().stopEditingInCurrentWindow();
                        ArbilDataNodeLoader.getSingleInstance().saveNodesNeedingSave(true);
                    }
                    if (((KeyEvent)event).getKeyCode() == 90) {
                        if (((KeyEvent)event).isShiftDown()) {
                            ArbilJournal.getSingleInstance().redoFromFieldChangeHistory();
                        } else {
                            ArbilJournal.getSingleInstance().undoFromFieldChangeHistory();
                        }
                    }
                    if (((KeyEvent)event).getKeyCode() == 89) {
                        ArbilJournal.getSingleInstance().redoFromFieldChangeHistory();
                    }
                }
            }
        }, 8L);
    }

    private void viewMenuMenuSelected(MenuEvent evt) {
        GuiHelper.getSingleInstance().initViewMenu(this.viewMenu);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.performCleanExit();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        ArbilWindowManager.getSingleInstance().openAboutPage();
    }

    private void shortCutKeysjMenuItemActionPerformed(ActionEvent evt) {
        ArbilHelp helpComponent = ArbilHelp.getSingleInstance();
        if (null == ArbilWindowManager.getSingleInstance().focusWindow("Help Viewer")) {
            ArbilWindowManager.getSingleInstance().createWindow("Help Viewer", helpComponent);
        }
        helpComponent.setCurrentPage("Short Cut Keys");
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        if (null == ArbilWindowManager.getSingleInstance().focusWindow("Help Viewer")) {
            ArbilWindowManager.getSingleInstance().createWindow("Help Viewer", ArbilHelp.getSingleInstance());
        }
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        try {
            ImportExportDialog importExportDialog = new ImportExportDialog(ArbilTreeHelper.getSingleInstance().getArbilTreePanel().remoteCorpusTree);
            importExportDialog.importArbilBranch();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void printHelpMenuItemActionPerformed(ActionEvent evt) {
        if (null == ArbilWindowManager.getSingleInstance().focusWindow("Help Viewer")) {
            ArbilWindowManager.getSingleInstance().createWindow("Help Viewer", ArbilHelp.getSingleInstance());
        }
        ArbilHelp.getSingleInstance().printAsOneFile();
    }

    private boolean saveApplicationState() {
        if (ArbilDataNodeLoader.getSingleInstance().nodesNeedSave()) {
            switch (JOptionPane.showConfirmDialog(this, "Save changes before exiting?", "Arbil", 1, -1)) {
                case 1: {
                    break;
                }
                case 0: {
                    ArbilDataNodeLoader.getSingleInstance().saveNodesNeedingSave(false);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        GuiHelper.getSingleInstance().saveState(this.saveWindowsCheckBoxMenuItem.isSelected());
        ArbilSessionStorage.getSingleInstance().saveBoolean("saveWindows", this.saveWindowsCheckBoxMenuItem.isSelected());
        ArbilSessionStorage.getSingleInstance().saveBoolean("checkNewVersionAtStart", this.checkNewVersionAtStartCheckBoxMenuItem.isSelected());
        return true;
    }

    public boolean performCleanExit() {
        if (this.saveApplicationState()) {
            System.exit(0);
            return true;
        }
        return false;
    }

    public boolean isMacOsMenu() {
        return this.macOsMenu;
    }

    public void setMacOsMenu(boolean macOsMenu) {
        this.macOsMenu = macOsMenu;
    }
}

