/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.item.AtomType;
import org.basex.query.item.Date;
import org.basex.query.item.Item;
import org.basex.query.item.Num;
import org.basex.query.item.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class Itr
extends Num {
    private static final Itr[] NUMS = new Itr[128];
    private final long val;

    static {
        int i = 0;
        while (i < NUMS.length) {
            Itr.NUMS[i] = new Itr(i);
            ++i;
        }
    }

    private Itr(long v) {
        this(v, AtomType.ITR);
    }

    public Itr(long v, Type t) {
        super(t);
        this.val = v;
    }

    Itr(Date d) {
        this(d.xc.toGregorianCalendar().getTimeInMillis(), AtomType.LNG);
    }

    public static Itr get(long v) {
        return v >= 0L && v < (long)NUMS.length ? NUMS[(int)v] : new Itr(v);
    }

    public static Itr get(long v, Type t) {
        return t == AtomType.ITR ? Itr.get(v) : new Itr(v, t);
    }

    @Override
    public final byte[] atom(InputInfo ii) {
        return this.val == 0L ? Token.ZERO : Token.token(this.val);
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return this.val != 0L;
    }

    @Override
    public final long itr(InputInfo ii) {
        return this.val;
    }

    @Override
    public final float flt(InputInfo ii) {
        return this.val;
    }

    @Override
    public final double dbl(InputInfo ii) {
        return this.val;
    }

    @Override
    public final BigDecimal dec(InputInfo ii) {
        return BigDecimal.valueOf(this.val);
    }

    @Override
    public final boolean eq(InputInfo ii, Item it) throws QueryException {
        return it instanceof Itr ? this.val == ((Itr)it).val : (double)this.val == it.dbl(ii);
    }

    @Override
    public final int diff(InputInfo ii, Item it) throws QueryException {
        if (it instanceof Itr) {
            long i = ((Itr)it).val;
            return this.val < i ? -1 : (this.val > i ? 1 : 0);
        }
        double n = it.dbl(ii);
        return Double.isNaN(n) ? Integer.MIN_VALUE : ((double)this.val < n ? -1 : ((double)this.val > n ? 1 : 0));
    }

    @Override
    public final Object toJava() {
        switch ((AtomType)this.type) {
            case BYT: {
                return (byte)this.val;
            }
            case SHR: 
            case UBY: {
                return (short)this.val;
            }
            case INT: 
            case USH: {
                return (int)this.val;
            }
            case LNG: 
            case UIN: {
                return this.val;
            }
        }
        return new BigInteger(this.toString());
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Itr)) {
            return false;
        }
        Itr i = (Itr)cmp;
        return this.type == i.type && this.val == i.val;
    }

    static long parse(byte[] val, InputInfo ii) throws QueryException {
        long l = Token.toLong(val);
        if (l != Long.MIN_VALUE) {
            return l;
        }
        try {
            String v = Token.string(Token.trim(val));
            return Long.parseLong(v.startsWith("+") ? v.substring(1) : v);
        }
        catch (NumberFormatException ex) {
            throw NUMS[0].castErr(val, ii);
        }
    }
}

