/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.export;

import java.util.ArrayList;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedigreePackageExport {
    private static UniqueIdentifier orphanId = new UniqueIdentifier("orphan", UniqueIdentifier.IdentifierType.tid);

    private String getSimpleId(ArrayList<UniqueIdentifier> allIdArray, UniqueIdentifier entityIdentifier) {
        if (!allIdArray.contains(entityIdentifier)) {
            allIdArray.add(entityIdentifier);
        }
        return Integer.toString(allIdArray.indexOf(entityIdentifier));
    }

    private UniqueIdentifier getFirstMatchingParent(EntityData entityData, EntityData.SymbolType symbolType) {
        for (EntityRelation entityRelation : entityData.getDistinctRelateNodes()) {
            if (!entityRelation.relationType.equals((Object)DataTypes.RelationType.ancestor) || !entityRelation.getAlterNode().getSymbolType().equals(symbolType.name())) continue;
            return entityRelation.getAlterNode().getUniqueIdentifier();
        }
        return orphanId;
    }

    private int getIntegerGender(EntityData entityData) {
        String symbolName = entityData.getSymbolType();
        if (symbolName.equals(EntityData.SymbolType.triangle.name())) {
            return 1;
        }
        if (symbolName.equals(EntityData.SymbolType.circle.name())) {
            return 2;
        }
        return 3;
    }

    public String createCsvContents(EntityData[] entityDataArray) {
        ArrayList<UniqueIdentifier> allIdArray = new ArrayList<UniqueIdentifier>();
        allIdArray.add(orphanId);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id\tmomid\tdadid\tsex\taffected\n");
        for (EntityData entityData : entityDataArray) {
            this.getSimpleId(allIdArray, entityData.getUniqueIdentifier());
        }
        for (EntityData entityData : entityDataArray) {
            stringBuilder.append(this.getSimpleId(allIdArray, entityData.getUniqueIdentifier()));
            stringBuilder.append("\t");
            stringBuilder.append(this.getSimpleId(allIdArray, this.getFirstMatchingParent(entityData, EntityData.SymbolType.circle)));
            stringBuilder.append("\t");
            stringBuilder.append(this.getSimpleId(allIdArray, this.getFirstMatchingParent(entityData, EntityData.SymbolType.triangle)));
            stringBuilder.append("\t");
            stringBuilder.append(this.getIntegerGender(entityData));
            stringBuilder.append("\t");
            if (entityData.isEgo) {
                stringBuilder.append("2");
            } else {
                stringBuilder.append("1");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] argsArray) {
        KinTypeStringConverter graphData = new KinTypeStringConverter();
        String kinTypes = "EmB|EmZ|EmM|EmF|EmS|EmD";
        String[] kinTypeStrings = kinTypes.split("\\|");
        graphData.readKinTypes(kinTypeStrings, new KinTermGroup[0], new DataStoreSvg(), new ParserHighlight[kinTypeStrings.length]);
        System.out.println(new PedigreePackageExport().createCsvContents(graphData.getDataNodes()));
    }
}

