/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlElement;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.svg.GraphPanelSize;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSorter {
    @XmlElement(name="Entity", namespace="http://mpi.nl/tla/kin")
    private EntityData[] graphDataNodeArray = new EntityData[0];
    HashMap<UniqueIdentifier, SortingEntity> knownSortingEntities;
    public int xPadding = 100;
    public int yPadding = 100;

    public void setPadding(GraphPanelSize graphPanelSize) {
        this.xPadding = graphPanelSize.getHorizontalSpacing();
        this.yPadding = graphPanelSize.getVerticalSpacing();
    }

    public void setEntitys(EntityData[] graphDataNodeArrayLocal) {
        this.graphDataNodeArray = graphDataNodeArrayLocal;
        this.knownSortingEntities = new HashMap();
        for (EntityData currentNode : graphDataNodeArrayLocal) {
            if (!currentNode.isVisible) continue;
            this.knownSortingEntities.put(currentNode.getUniqueIdentifier(), new SortingEntity(currentNode));
        }
        for (SortingEntity currentSorter : this.knownSortingEntities.values()) {
            currentSorter.calculateRelations(this.knownSortingEntities);
        }
    }

    public Rectangle getGraphSize(HashMap<UniqueIdentifier, float[]> entityPositions) {
        int[] minPostion = null;
        int[] maxPostion = null;
        for (float[] currentPosition : entityPositions.values()) {
            if (minPostion == null) {
                minPostion = new int[]{Math.round(currentPosition[0]), Math.round(currentPosition[1])};
                maxPostion = new int[]{Math.round(currentPosition[0]), Math.round(currentPosition[1])};
                continue;
            }
            minPostion[0] = Math.min((int)minPostion[0], Math.round(currentPosition[0]));
            minPostion[1] = Math.min(minPostion[1], Math.round(currentPosition[1]));
            maxPostion[0] = Math.max(maxPostion[0], Math.round(currentPosition[0]));
            maxPostion[1] = Math.max(maxPostion[1], Math.round(currentPosition[1]));
        }
        if (minPostion == null) {
            minPostion = new int[]{0, 0};
            maxPostion = new int[]{0, 0};
        }
        void xOffset = minPostion[0] - this.xPadding;
        void yOffset = minPostion[1] - this.yPadding;
        void graphWidth = maxPostion[0] + this.xPadding;
        int graphHeight = maxPostion[1] + this.yPadding;
        return new Rectangle((int)xOffset, (int)yOffset, (int)graphWidth, graphHeight);
    }

    public void placeAllNodes(HashMap<UniqueIdentifier, float[]> entityPositions) {
        ArrayList<UniqueIdentifier> removeNodeIds = new ArrayList<UniqueIdentifier>(entityPositions.keySet());
        for (EntityData currentNode : this.graphDataNodeArray) {
            removeNodeIds.remove(currentNode.getUniqueIdentifier());
            if (currentNode.isVisible) continue;
            entityPositions.remove(currentNode.getUniqueIdentifier());
        }
        for (UniqueIdentifier currentRemoveId : removeNodeIds) {
            if (currentRemoveId.isGraphicsIdentifier()) continue;
            entityPositions.remove(currentRemoveId);
        }
        if (this.knownSortingEntities != null) {
            for (SortingEntity currentSorter : this.knownSortingEntities.values()) {
                Rectangle rectangle = this.getGraphSize(entityPositions);
                float[] defaultPosition = new float[]{rectangle.width, rectangle.height};
                currentSorter.getPosition(entityPositions, defaultPosition);
                currentSorter.getRelatedPositions(entityPositions);
            }
        }
    }

    public EntityData[] getDataNodes() {
        return this.graphDataNodeArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortingEntity {
        UniqueIdentifier selfEntityId;
        ArrayList<SortingEntity> mustBeBelow;
        ArrayList<SortingEntity> mustBeAbove;
        ArrayList<SortingEntity> mustBeNextTo;
        ArrayList<SortingEntity> couldBeNextTo;
        EntityRelation[] visiblyRelateNodes;
        float[] calculatedPosition = null;

        public SortingEntity(EntityData entityData) {
            this.selfEntityId = entityData.getUniqueIdentifier();
            this.visiblyRelateNodes = entityData.getVisiblyRelateNodes();
            this.mustBeBelow = new ArrayList();
            this.mustBeAbove = new ArrayList();
            this.mustBeNextTo = new ArrayList();
            this.couldBeNextTo = new ArrayList();
        }

        public void calculateRelations(HashMap<UniqueIdentifier, SortingEntity> knownSortingEntities) {
            block6: for (EntityRelation entityRelation : this.visiblyRelateNodes) {
                switch (entityRelation.relationType) {
                    case ancestor: {
                        this.mustBeBelow.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                        continue block6;
                    }
                    case descendant: {
                        this.mustBeAbove.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                        continue block6;
                    }
                    case union: {
                        this.mustBeNextTo.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                    }
                    case sibling: {
                        this.couldBeNextTo.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                    }
                }
            }
        }

        private boolean positionIsFree(UniqueIdentifier currentIdentifier, float[] targetPosition, HashMap<UniqueIdentifier, float[]> entityPositions) {
            float[] entityPosition;
            int useCount = 0;
            for (float[] currentPosition : entityPositions.values()) {
                if (currentPosition[0] != targetPosition[0] || currentPosition[1] != targetPosition[1]) continue;
                ++useCount;
            }
            if (useCount == 0) {
                return true;
            }
            return useCount == 1 && (entityPosition = entityPositions.get(currentIdentifier)) != null && entityPosition[0] == targetPosition[0] && entityPosition[1] == targetPosition[1];
        }

        protected float[] getPosition(HashMap<UniqueIdentifier, float[]> entityPositions, float[] defaultPosition) {
            System.out.println("getPosition: " + this.selfEntityId.getAttributeIdentifier());
            this.calculatedPosition = entityPositions.get(this.selfEntityId);
            if (this.calculatedPosition == null) {
                float[] nextToPos;
                for (SortingEntity sortingEntity : this.mustBeBelow) {
                    float[] nextAbovePos = entityPositions.get(sortingEntity.selfEntityId);
                    if (nextAbovePos == null) continue;
                    if (this.calculatedPosition == null) {
                        this.calculatedPosition = new float[]{nextAbovePos[0], nextAbovePos[1]};
                    }
                    if (!(nextAbovePos[1] > this.calculatedPosition[1] - (float)GraphSorter.this.yPadding)) continue;
                    this.calculatedPosition[1] = nextAbovePos[1] + (float)GraphSorter.this.yPadding;
                    System.out.println("move down: " + this.selfEntityId.getAttributeIdentifier());
                }
                if (this.calculatedPosition == null) {
                    for (SortingEntity sortingEntity : this.couldBeNextTo) {
                        nextToPos = entityPositions.get(sortingEntity.selfEntityId);
                        if (this.calculatedPosition != null || nextToPos == null) continue;
                        this.calculatedPosition = new float[]{nextToPos[0], nextToPos[1]};
                    }
                }
                if (this.calculatedPosition == null) {
                    for (SortingEntity sortingEntity : this.mustBeAbove) {
                        float[] nextBelowPos = entityPositions.get(sortingEntity.selfEntityId);
                        if (nextBelowPos == null) continue;
                        if (this.calculatedPosition == null) {
                            this.calculatedPosition = new float[]{nextBelowPos[0], nextBelowPos[1]};
                        }
                        if (!(nextBelowPos[1] < this.calculatedPosition[1] + (float)GraphSorter.this.yPadding)) continue;
                        this.calculatedPosition[1] = nextBelowPos[1] - (float)GraphSorter.this.yPadding;
                        System.out.println("move up: " + this.selfEntityId.getAttributeIdentifier());
                    }
                }
                if (this.calculatedPosition == null) {
                    this.calculatedPosition = new float[]{defaultPosition[0], 0.0f};
                }
                for (SortingEntity sortingEntity : this.mustBeNextTo) {
                    nextToPos = entityPositions.get(sortingEntity.selfEntityId);
                    if (nextToPos == null || !(nextToPos[1] > this.calculatedPosition[1])) continue;
                    this.calculatedPosition = new float[]{nextToPos[0], nextToPos[1]};
                }
                while (!this.positionIsFree(this.selfEntityId, this.calculatedPosition, entityPositions)) {
                    this.calculatedPosition[0] = this.calculatedPosition[0] + (float)GraphSorter.this.xPadding;
                    System.out.println("move right: " + this.selfEntityId.getAttributeIdentifier());
                }
                entityPositions.put(this.selfEntityId, this.calculatedPosition);
            }
            System.out.println("Position: " + this.selfEntityId.getAttributeIdentifier() + " : " + this.calculatedPosition[0] + " : " + this.calculatedPosition[1]);
            return this.calculatedPosition;
        }

        protected void getRelatedPositions(HashMap<UniqueIdentifier, float[]> entityPositions) {
            ArrayList<SortingEntity> allRelations = new ArrayList<SortingEntity>();
            allRelations.addAll(this.mustBeAbove);
            allRelations.addAll(this.mustBeBelow);
            allRelations.addAll(this.couldBeNextTo);
            for (SortingEntity sortingEntity : allRelations) {
                if (sortingEntity.calculatedPosition != null) continue;
                Rectangle rectangle = GraphSorter.this.getGraphSize(entityPositions);
                float[] defaultPosition = new float[]{rectangle.width, rectangle.height};
                sortingEntity.getPosition(entityPositions, defaultPosition);
                sortingEntity.getRelatedPositions(entityPositions);
            }
        }
    }
}

