/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;

public class KinType {
    protected String codeString;
    protected DataTypes.RelationType relationType;
    protected EntityData.SymbolType symbolType;
    protected String displayString;
    protected static KinType[] referenceKinTypes = new KinType[]{new KinType("Ef", DataTypes.RelationType.none, EntityData.SymbolType.circle, "Ego Female"), new KinType("Em", DataTypes.RelationType.none, EntityData.SymbolType.triangle, "Ego Male"), new KinType("Fa", DataTypes.RelationType.ancestor, EntityData.SymbolType.triangle, "Father"), new KinType("Mo", DataTypes.RelationType.ancestor, EntityData.SymbolType.circle, "Mother"), new KinType("Br", DataTypes.RelationType.sibling, EntityData.SymbolType.triangle, "Brother"), new KinType("Si", DataTypes.RelationType.sibling, EntityData.SymbolType.circle, "Sister"), new KinType("So", DataTypes.RelationType.descendant, EntityData.SymbolType.triangle, "Son"), new KinType("Da", DataTypes.RelationType.descendant, EntityData.SymbolType.circle, "Daughter"), new KinType("Hu", DataTypes.RelationType.union, EntityData.SymbolType.triangle, "Husband"), new KinType("Wi", DataTypes.RelationType.union, EntityData.SymbolType.circle, "Wife"), new KinType("Pa", DataTypes.RelationType.ancestor, EntityData.SymbolType.square, "Parent"), new KinType("Sb", DataTypes.RelationType.sibling, EntityData.SymbolType.square, "Sibling"), new KinType("Sp", DataTypes.RelationType.union, EntityData.SymbolType.square, "Spouse"), new KinType("Ch", DataTypes.RelationType.descendant, EntityData.SymbolType.square, "Child"), new KinType("F", DataTypes.RelationType.ancestor, EntityData.SymbolType.triangle, "Father"), new KinType("M", DataTypes.RelationType.ancestor, EntityData.SymbolType.circle, "Mother"), new KinType("B", DataTypes.RelationType.sibling, EntityData.SymbolType.triangle, "Brother"), new KinType("Z", DataTypes.RelationType.sibling, EntityData.SymbolType.circle, "Sister"), new KinType("S", DataTypes.RelationType.descendant, EntityData.SymbolType.triangle, "Son"), new KinType("D", DataTypes.RelationType.descendant, EntityData.SymbolType.circle, "Daughter"), new KinType("H", DataTypes.RelationType.union, EntityData.SymbolType.triangle, "Husband"), new KinType("W", DataTypes.RelationType.union, EntityData.SymbolType.circle, "Wife"), new KinType("P", DataTypes.RelationType.ancestor, EntityData.SymbolType.square, "Parent"), new KinType("G", DataTypes.RelationType.sibling, EntityData.SymbolType.square, "Sibling"), new KinType("E", DataTypes.RelationType.none, EntityData.SymbolType.square, "Ego"), new KinType("C", DataTypes.RelationType.descendant, EntityData.SymbolType.square, "Child"), new KinType("m", DataTypes.RelationType.none, EntityData.SymbolType.triangle, "Male"), new KinType("f", DataTypes.RelationType.none, EntityData.SymbolType.circle, "Female"), new KinType("x", DataTypes.RelationType.none, EntityData.SymbolType.square, "Undefined")};

    private KinType(String codeStringLocal, DataTypes.RelationType relationTypeLocal, EntityData.SymbolType symbolTypeLocal, String displayStringLocal) {
        this.codeString = codeStringLocal;
        this.relationType = relationTypeLocal;
        this.symbolType = symbolTypeLocal;
        this.displayString = displayStringLocal;
    }

    public String getCodeString() {
        return this.codeString;
    }

    public boolean isEgoType() {
        return this.codeString.contains("E");
    }

    public boolean matchesRelation(EntityRelation entityRelation, String kinTypeModifier) {
        if (entityRelation.getAlterNode().isEgo != this.isEgoType()) {
            return false;
        }
        if (!this.relationType.equals((Object)entityRelation.relationType)) {
            return false;
        }
        if (this.symbolType == EntityData.SymbolType.square) {
            return true;
        }
        return this.symbolType.name().equals(entityRelation.getAlterNode().getSymbolType());
    }

    public boolean matchesEgoEntity(EntityData entityData, String kinTypeModifier) {
        if (!entityData.isEgo || !this.isEgoType()) {
            return false;
        }
        if (this.symbolType == EntityData.SymbolType.square) {
            return true;
        }
        return this.symbolType.name().equals(entityData.getSymbolType());
    }
}

