/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import nl.mpi.kinnate.ui.KinDiagramPanel;

public class DocumentNewMenu
extends JMenu
implements ActionListener {
    JTabbedPane targetPane;

    public DocumentNewMenu(JTabbedPane targetPane) {
        this.targetPane = targetPane;
        for (DocumentType documentType : DocumentType.values()) {
            JMenuItem menuItem = new JMenuItem(documentType.getDisplayName());
            menuItem.setActionCommand(documentType.name());
            menuItem.addActionListener(this);
            this.add(menuItem);
        }
    }

    public void actionPerformed(ActionEvent e) {
        DocumentType documentType = DocumentType.valueOf(e.getActionCommand());
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(documentType);
        this.targetPane.add("Unsaved " + documentType.getDisplayName() + " Diagram", egoSelectionTestPanel);
        this.targetPane.setSelectedComponent(egoSelectionTestPanel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DocumentType {
        KinTypeString("Kin Type String"),
        KinTerms("Kin Terms"),
        Query("Kin Type String Query"),
        ArchiveLinker("Archive Data Linker"),
        EntitySearch("Entity Search"),
        CustomQuery("Custom Metadata"),
        Simple("Standard");

        private String displayName;

        private DocumentType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

