/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.FocusManager;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.MouseListenerSvg;

public class EditMenu
extends JMenu
implements ActionListener {
    JMenuItem selectAllMenu = null;
    JMenuItem selectRelatedMenu = null;
    JMenuItem expandSelectionMenu = null;
    JMenuItem deselectAllMenu = null;
    GraphPanel initialGraphPanel = null;

    public EditMenu() {
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
                EditMenu.this.enableMenuKeys();
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                EditMenu.this.initMenu();
            }
        });
    }

    private void initMenu() {
        this.initialGraphPanel = this.getGraphPanel();
        boolean graphPanelFocused = this.initialGraphPanel != null;
        this.selectAllMenu.setEnabled(graphPanelFocused);
        this.selectRelatedMenu.setEnabled(graphPanelFocused);
        this.expandSelectionMenu.setEnabled(false);
        this.deselectAllMenu.setEnabled(graphPanelFocused);
    }

    protected void enableMenuKeys() {
        this.initialGraphPanel = null;
        if (this.selectAllMenu == null) {
            this.selectAllMenu = new JMenuItem("Select All");
            this.selectAllMenu.setActionCommand(MouseListenerSvg.ActionCode.selectAll.name());
            this.selectAllMenu.addActionListener(this);
            this.selectAllMenu.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.selectRelatedMenu = new JMenuItem("Select Related");
            this.selectRelatedMenu.setActionCommand(MouseListenerSvg.ActionCode.selectRelated.name());
            this.selectRelatedMenu.addActionListener(this);
            this.selectRelatedMenu.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            this.expandSelectionMenu = new JMenuItem("Expand Selection");
            this.expandSelectionMenu.setActionCommand(MouseListenerSvg.ActionCode.expandSelection.name());
            this.expandSelectionMenu.addActionListener(this);
            this.expandSelectionMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.deselectAllMenu = new JMenuItem("Deselect All");
            this.deselectAllMenu.setActionCommand(MouseListenerSvg.ActionCode.deselectAll.name());
            this.deselectAllMenu.addActionListener(this);
            this.deselectAllMenu.setAccelerator(KeyStroke.getKeyStroke(68, 2));
            this.add(this.selectAllMenu);
            this.add(this.selectRelatedMenu);
            this.add(this.expandSelectionMenu);
            this.add(this.deselectAllMenu);
        }
        this.selectAllMenu.setEnabled(true);
        this.selectRelatedMenu.setEnabled(true);
        this.expandSelectionMenu.setEnabled(true);
        this.deselectAllMenu.setEnabled(true);
    }

    private GraphPanel getGraphPanel() {
        GraphPanel graphPanel = null;
        for (Component focusedComponent = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); focusedComponent != null; focusedComponent = focusedComponent.getParent()) {
            if (!(focusedComponent instanceof GraphPanel)) continue;
            graphPanel = (GraphPanel)focusedComponent;
            break;
        }
        return graphPanel;
    }

    public void actionPerformed(ActionEvent e) {
        GraphPanel graphPanel = this.getGraphPanel();
        if (graphPanel == null) {
            graphPanel = this.initialGraphPanel;
        }
        if (graphPanel != null) {
            graphPanel.mouseListenerSvg.performMenuAction(MouseListenerSvg.ActionCode.valueOf(e.getActionCommand()));
        }
        this.enableMenuKeys();
    }
}

