/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import javax.swing.JTabbedPane;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;

public class HidePane
extends JTabbedPane {
    private boolean hiddenState = true;
    private int lastSelectedTab = -1;
    private int defaultShownWidth = 300;
    private int shownWidth;
    private int hiddenWidth = 30;
    private HidePanePosition borderPosition;
    private boolean horizontalDivider;
    private int dragStartPosition = 0;
    private boolean lastWasDrag = false;
    private HashSet<VisiblePanelSetting> registeredPanelSettings = new HashSet();

    public HidePane(HidePanePosition borderPositionLocal, int startWidth) {
        this.shownWidth = startWidth;
        this.borderPosition = borderPositionLocal;
        this.horizontalDivider = !this.borderPosition.equals((Object)HidePanePosition.left) && !this.borderPosition.equals((Object)HidePanePosition.right);
        switch (this.borderPosition) {
            case left: {
                this.setTabPlacement(1);
                break;
            }
            case right: {
                this.setTabPlacement(1);
                break;
            }
            case top: {
                this.setTabPlacement(3);
                break;
            }
            case bottom: {
                this.setTabPlacement(1);
            }
        }
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                HidePane.this.lastWasDrag = true;
                if (HidePane.this.hiddenState) {
                    HidePane.this.hiddenState = false;
                    HidePane.this.shownWidth = HidePane.this.hiddenWidth;
                }
                switch (HidePane.this.borderPosition) {
                    case left: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth - HidePane.this.dragStartPosition + e.getXOnScreen();
                        HidePane.this.dragStartPosition = e.getXOnScreen();
                        break;
                    }
                    case right: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth + HidePane.this.dragStartPosition - e.getXOnScreen();
                        HidePane.this.dragStartPosition = e.getXOnScreen();
                        break;
                    }
                    case top: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth - HidePane.this.dragStartPosition + e.getYOnScreen();
                        HidePane.this.dragStartPosition = e.getYOnScreen();
                        break;
                    }
                    case bottom: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth + HidePane.this.dragStartPosition - e.getYOnScreen();
                        HidePane.this.dragStartPosition = e.getYOnScreen();
                    }
                }
                if (HidePane.this.shownWidth < HidePane.this.hiddenWidth) {
                    HidePane.this.shownWidth = HidePane.this.hiddenWidth;
                    HidePane.this.hiddenState = true;
                }
                if (HidePane.this.horizontalDivider) {
                    HidePane.this.setPreferredSize(new Dimension(HidePane.this.getPreferredSize().width, HidePane.this.shownWidth));
                } else {
                    HidePane.this.setPreferredSize(new Dimension(HidePane.this.shownWidth, HidePane.this.getPreferredSize().height));
                }
                HidePane.this.revalidate();
                HidePane.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (!HidePane.this.hiddenState && HidePane.this.lastSelectedTab != HidePane.this.getSelectedIndex()) {
                    HidePane.this.lastSelectedTab = HidePane.this.getSelectedIndex();
                    return;
                }
                HidePane.this.lastSelectedTab = HidePane.this.getSelectedIndex();
                if (!HidePane.this.lastWasDrag) {
                    HidePane.this.toggleHiddenState();
                } else if (HidePane.this.shownWidth < HidePane.this.hiddenWidth * 2) {
                    HidePane.this.shownWidth = HidePane.this.hiddenWidth;
                    HidePane.this.hiddenState = true;
                    if (HidePane.this.horizontalDivider) {
                        HidePane.this.setPreferredSize(new Dimension(HidePane.this.getPreferredSize().width, HidePane.this.shownWidth));
                    } else {
                        HidePane.this.setPreferredSize(new Dimension(HidePane.this.shownWidth, HidePane.this.getPreferredSize().height));
                    }
                    HidePane.this.revalidate();
                    HidePane.this.repaint();
                }
                for (VisiblePanelSetting panelSetting : HidePane.this.registeredPanelSettings) {
                    panelSetting.setPanelWidth(HidePane.this.shownWidth);
                }
            }

            public void mousePressed(MouseEvent e) {
                HidePane.this.lastWasDrag = false;
                if (HidePane.this.horizontalDivider) {
                    HidePane.this.dragStartPosition = e.getYOnScreen();
                } else {
                    HidePane.this.dragStartPosition = e.getXOnScreen();
                }
                super.mousePressed(e);
            }
        });
        if (this.horizontalDivider) {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.hiddenWidth));
        } else {
            this.setPreferredSize(new Dimension(this.hiddenWidth, this.getPreferredSize().height));
        }
    }

    public void addTab(VisiblePanelSetting panelSetting) {
        super.addTab(panelSetting.getDisplayName(), panelSetting.getTargetPanel());
        this.shownWidth = panelSetting.getPanelWidth();
        this.hiddenState = false;
        if (this.horizontalDivider) {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.shownWidth));
        } else {
            this.setPreferredSize(new Dimension(this.shownWidth, this.getPreferredSize().height));
        }
        this.revalidate();
        this.repaint();
        this.setVisible(true);
        this.registeredPanelSettings.add(panelSetting);
    }

    public void remove(VisiblePanelSetting panelSetting) {
        super.remove(panelSetting.getTargetPanel());
        this.setVisible(this.getComponentCount() > 0);
        this.registeredPanelSettings.remove(panelSetting);
    }

    public void toggleHiddenState() {
        if (!this.hiddenState) {
            if (this.horizontalDivider) {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.hiddenWidth));
            } else {
                this.setPreferredSize(new Dimension(this.hiddenWidth, this.getPreferredSize().height));
            }
        } else {
            if (this.shownWidth < this.hiddenWidth * 2) {
                this.shownWidth = this.defaultShownWidth;
            }
            if (this.horizontalDivider) {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.shownWidth));
            } else {
                this.setPreferredSize(new Dimension(this.shownWidth, this.getPreferredSize().height));
            }
        }
        this.hiddenState = !this.hiddenState;
        this.revalidate();
        this.repaint();
    }

    public boolean isHidden() {
        return this.hiddenState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HidePanePosition {
        left,
        right,
        top,
        bottom;

    }
}

