/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kintypestrings.KinTerm;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;

public class KinTermPanel
extends JPanel {
    JTextField kinTypeGroupName;
    JTextField kinTypeGroupDescription;
    KinTermGroup kinTerms;
    SavePanel savePanel;
    JCheckBox autoGenerateCheckBox;
    JCheckBox showOnGraphCheckBox;
    JComboBox colourSelectBox;
    JPanel outerPanel;
    JTextField addNewKinTerm;
    JTextField addEgoKinType;
    JTextField addKinTermDescription;
    JTextField addAlterKinType;
    JTextField addPropositusKinType;
    JTextField addAnchorKinType;
    String defaultKinType = "";

    public KinTermPanel(SavePanel savePanelLocal, KinTermGroup kinTermsLocal, String defaultKinTypeLocal) {
        this.kinTerms = kinTermsLocal;
        this.savePanel = savePanelLocal;
        this.defaultKinType = defaultKinTypeLocal;
        this.kinTypeGroupName = new JTextField(this.kinTerms.titleString);
        this.kinTypeGroupName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                super.keyReleased(ke);
                KinTermPanel.this.kinTerms.titleString = ((JTextField)ke.getComponent()).getText();
                Container parentComponent = KinTermPanel.this.getParent();
                if (parentComponent instanceof JTabbedPane) {
                    ((JTabbedPane)parentComponent).setTitleAt(((JTabbedPane)parentComponent).getSelectedIndex(), KinTermPanel.this.kinTerms.titleString);
                }
                KinTermPanel.this.savePanel.setRequiresSave();
            }
        });
        this.kinTypeGroupDescription = new JTextField(this.kinTerms.descriptionString);
        this.kinTypeGroupDescription.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                super.keyReleased(ke);
                KinTermPanel.this.kinTerms.descriptionString = ((JTextField)ke.getComponent()).getText();
                KinTermPanel.this.savePanel.setRequiresSave();
            }
        });
        this.colourSelectBox = new JComboBox<String>(new String[]{"red", "blue", "#FF0000", "#FFAA00", "#00FF95", "#62D9A7", "#8000FF", "#FF00D4"});
        this.colourSelectBox.setSelectedItem(this.kinTerms.graphColour);
        this.colourSelectBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTermPanel.this.kinTerms.graphColour = KinTermPanel.this.colourSelectBox.getSelectedItem().toString();
                KinTermPanel.this.savePanel.updateGraph();
            }
        });
        this.showOnGraphCheckBox = new JCheckBox("Show On Graph");
        this.showOnGraphCheckBox.setSelected(this.kinTerms.graphShow);
        this.showOnGraphCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTermPanel.this.kinTerms.graphShow = KinTermPanel.this.showOnGraphCheckBox.isSelected();
                KinTermPanel.this.savePanel.updateGraph();
            }
        });
        this.autoGenerateCheckBox = new JCheckBox("Generate Example Entities");
        this.autoGenerateCheckBox.setSelected(this.kinTerms.graphGenerate);
        this.autoGenerateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTermPanel.this.kinTerms.graphGenerate = KinTermPanel.this.autoGenerateCheckBox.isSelected();
                KinTermPanel.this.savePanel.updateGraph();
            }
        });
        this.setLayout(new BorderLayout());
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BoxLayout(this.outerPanel, 1));
        this.populateKinTermList();
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new BorderLayout());
        paddingPanel.add((Component)this.outerPanel, "First");
        this.add((Component)new JScrollPane(paddingPanel), "Center");
    }

    private void populateKinTermList() {
        this.outerPanel.removeAll();
        this.outerPanel.add(this.kinTypeGroupName);
        this.outerPanel.add(this.kinTypeGroupDescription);
        this.outerPanel.add(this.showOnGraphCheckBox);
        this.outerPanel.add(this.colourSelectBox);
        this.outerPanel.add(this.autoGenerateCheckBox);
        this.populateAddForm();
        for (final KinTerm currentKinTerm : this.kinTerms.getKinTerms()) {
            JTextField kinTypeString;
            JPanel termPanel = new JPanel();
            termPanel.setBorder(BorderFactory.createTitledBorder(currentKinTerm.kinTerm));
            termPanel.setLayout(new BoxLayout(termPanel, 1));
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BorderLayout());
            JButton removeButton = new JButton("x");
            removeButton.setToolTipText("delete kin term");
            int removeButtonSize = removeButton.getFontMetrics(removeButton.getFont()).getHeight();
            removeButton.setPreferredSize(new Dimension(removeButtonSize, removeButtonSize));
            removeButton.setActionCommand(currentKinTerm.kinTerm);
            removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    KinTermPanel.this.kinTerms.removeKinTerm(evt.getActionCommand());
                    KinTermPanel.this.populateKinTermList();
                    KinTermPanel.this.revalidate();
                    KinTermPanel.this.savePanel.updateGraph();
                }
            });
            labelPanel.add((Component)removeButton, "After");
            if (currentKinTerm.kinTermDescription != null) {
                termPanel.add(new JLabel("Description"));
                kinTypeString = new JTextField(currentKinTerm.kinTermDescription);
                kinTypeString.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent ke) {
                        super.keyReleased(ke);
                        currentKinTerm.kinTermDescription = ((JTextField)ke.getComponent()).getText();
                        KinTermPanel.this.savePanel.updateGraph();
                    }
                });
                termPanel.add(kinTypeString);
            }
            if (currentKinTerm.egoType != null) {
                termPanel.add(new JLabel("Ego Kin Type"));
                kinTypeString = new JTextField(currentKinTerm.egoType);
                kinTypeString.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent ke) {
                        super.keyReleased(ke);
                        currentKinTerm.egoType = ((JTextField)ke.getComponent()).getText();
                        KinTermPanel.this.savePanel.updateGraph();
                    }
                });
                termPanel.add(kinTypeString);
            }
            if (currentKinTerm.alterKinTypeStrings != null) {
                termPanel.add(new JLabel("Alter Kin Type Strings"));
                kinTypeString = new JTextField(currentKinTerm.alterKinTypeStrings);
                kinTypeString.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent ke) {
                        super.keyReleased(ke);
                        currentKinTerm.alterKinTypeStrings = ((JTextField)ke.getComponent()).getText();
                        KinTermPanel.this.savePanel.updateGraph();
                    }
                });
                termPanel.add(kinTypeString);
            }
            if (currentKinTerm.propositusKinTypeStrings != null) {
                termPanel.add(new JLabel("Propositus Kin Type Strings"));
                kinTypeString = new JTextField(currentKinTerm.propositusKinTypeStrings);
                kinTypeString.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent ke) {
                        super.keyReleased(ke);
                        currentKinTerm.propositusKinTypeStrings = ((JTextField)ke.getComponent()).getText();
                        KinTermPanel.this.savePanel.updateGraph();
                    }
                });
                termPanel.add(kinTypeString);
            }
            if (currentKinTerm.anchorKinTypeStrings != null) {
                termPanel.add(new JLabel("Anchor Kin Type Strings"));
                kinTypeString = new JTextField(currentKinTerm.anchorKinTypeStrings);
                kinTypeString.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent ke) {
                        super.keyReleased(ke);
                        currentKinTerm.anchorKinTypeStrings = ((JTextField)ke.getComponent()).getText();
                        KinTermPanel.this.savePanel.updateGraph();
                    }
                });
                termPanel.add(kinTypeString);
            }
            termPanel.add(labelPanel);
            this.outerPanel.add(termPanel);
        }
    }

    public void setDefaultKinType(String kinTypeString) {
        this.defaultKinType = kinTypeString;
        this.addAlterKinType.setText(this.defaultKinType);
    }

    private void populateAddForm() {
        this.addNewKinTerm = new JTextField();
        this.addKinTermDescription = new JTextField();
        this.addEgoKinType = new JTextField();
        this.addAlterKinType = new JTextField(this.defaultKinType);
        this.addPropositusKinType = new JTextField();
        this.addAnchorKinType = new JTextField();
        JPanel termPanel = new JPanel();
        termPanel.setBorder(BorderFactory.createTitledBorder("Create New Kin Term"));
        termPanel.setLayout(new BoxLayout(termPanel, 1));
        termPanel.add(new JLabel("Kin Term"));
        termPanel.add(this.addNewKinTerm);
        termPanel.add(new JLabel("Description"));
        termPanel.add(this.addKinTermDescription);
        termPanel.add(new JLabel("Ego Kin Type"));
        termPanel.add(this.addEgoKinType);
        termPanel.add(new JLabel("Alter Kin Type Strings"));
        termPanel.add(this.addAlterKinType);
        termPanel.add(new JLabel("Propositus Kin Type Strings"));
        termPanel.add(this.addPropositusKinType);
        termPanel.add(new JLabel("Anchor Kin Type Strings"));
        termPanel.add(this.addAnchorKinType);
        JButton addButton = new JButton("add");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTerm kinTerm = new KinTerm();
                if (KinTermPanel.this.addNewKinTerm.getText().length() > 0) {
                    kinTerm.kinTerm = KinTermPanel.this.addNewKinTerm.getText();
                }
                kinTerm.kinTermDescription = KinTermPanel.this.addKinTermDescription.getText();
                if (KinTermPanel.this.addEgoKinType.getText().length() > 0) {
                    kinTerm.egoType = KinTermPanel.this.addEgoKinType.getText();
                }
                kinTerm.alterKinTypeStrings = KinTermPanel.this.addAlterKinType.getText();
                if (KinTermPanel.this.addPropositusKinType.getText().length() > 0) {
                    kinTerm.propositusKinTypeStrings = KinTermPanel.this.addPropositusKinType.getText();
                }
                if (KinTermPanel.this.addAnchorKinType.getText().length() > 0) {
                    kinTerm.anchorKinTypeStrings = KinTermPanel.this.addAnchorKinType.getText();
                }
                KinTermPanel.this.kinTerms.addKinTerm(kinTerm);
                KinTermPanel.this.populateKinTermList();
                KinTermPanel.this.revalidate();
                KinTermPanel.this.savePanel.updateGraph();
            }
        });
        termPanel.add(addButton);
        this.outerPanel.add(termPanel);
    }

    public void exportKinTerms() {
        File[] exportFile = ArbilWindowManager.getSingleInstance().showFileSelectBox("Export Kin Terms", false, false, false);
        if (exportFile.length != 1) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Export file not selected", "Export Kin Terms");
        } else {
            if (exportFile[0].exists() && !ArbilWindowManager.getSingleInstance().showConfirmDialogBox("Export file already exists, overwrite?", "Export Kin Terms")) {
                return;
            }
            try {
                FileWriter fileWriter = new FileWriter(exportFile[0]);
                fileWriter.write("wookies are lovely on toast.");
                fileWriter.close();
            }
            catch (IOException exception) {
                new ArbilBugCatcher().logError((Exception)exception);
            }
        }
    }

    public void importKinTerms() {
        File[] importFiles = ArbilWindowManager.getSingleInstance().showFileSelectBox("Import Kin Terms", false, true, false);
        if (importFiles.length == 0) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No files selected for import", "Import Kin Terms");
        }
        for (File currentFile : importFiles) {
            int importCount = 0;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(currentFile));
                String currentLine = null;
                while ((currentLine = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(currentLine, ",");
                    if (stringTokenizer.countTokens() <= 1) continue;
                    String kinTypeStrings = stringTokenizer.nextToken();
                    String kinTermLabel = stringTokenizer.nextToken();
                    kinTypeStrings = kinTypeStrings.trim();
                    kinTermLabel = kinTermLabel.trim();
                    this.kinTerms.addKinTerm(kinTypeStrings, kinTermLabel);
                    ++importCount;
                }
                bufferedReader.close();
                this.populateKinTermList();
                this.revalidate();
                this.savePanel.updateGraph();
            }
            catch (IOException exception) {
                new ArbilBugCatcher().logError((Exception)exception);
            }
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Imported " + importCount + " kin terms", "Import Kin Terms");
        }
    }
}

