/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.net.URI;
import java.net.URISyntaxException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinTree
extends ArbilTree {
    GraphPanel graphPanel;

    public KinTree(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
    }

    protected void putSelectionIntoPreviewTable() {
        ArbilNode arbilNode = this.getLeadSelectionNode();
        if (arbilNode instanceof ArbilDataNode) {
            this.graphPanel.setSelectedIds(new UniqueIdentifier[0]);
            super.putSelectionIntoPreviewTable();
        } else if (arbilNode instanceof KinTreeNode) {
            KinTreeNode kinTreeNode = (KinTreeNode)arbilNode;
            if (kinTreeNode.entityData != null) {
                this.graphPanel.setSelectedIds(new UniqueIdentifier[]{kinTreeNode.entityData.getUniqueIdentifier()});
                ArbilTableModel previewTableModel = this.customPreviewTable.getArbilTableModel();
                try {
                    ArbilDataNode arbilDataNode = ArbilDataNodeLoader.getSingleInstance().getArbilDataNode(null, new URI(((KinTreeNode)arbilNode).entityData.getEntityPath()));
                    if (previewTableModel.getArbilDataNodeCount() != 1 || !previewTableModel.containsArbilDataNode(arbilDataNode)) {
                        previewTableModel.removeAllArbilDataNodeRows();
                        previewTableModel.addSingleArbilDataNode(arbilDataNode);
                    }
                }
                catch (URISyntaxException urise) {
                    GuiHelper.linorgBugCatcher.logError((Exception)urise);
                }
            }
        }
    }
}

