/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.dom;

import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXNList;
import org.basex.api.dom.BXNNode;
import org.basex.io.IO;
import org.basex.query.item.ANode;
import org.basex.query.item.NodeType;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.NodeCache;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class BXNode
implements Node {
    private static final short[] TYPES = new short[]{9, 1, 3, 2, 8, 7, 4, 11};
    private static final String[] NAMES;
    protected final ANode node;

    static {
        String[] stringArray = new String[8];
        stringArray[0] = "#document";
        stringArray[2] = "#text";
        stringArray[4] = "#comment";
        stringArray[6] = "#cdata-section";
        stringArray[7] = "#document-fragment";
        NAMES = stringArray;
    }

    protected BXNode(ANode n) {
        this.node = n;
    }

    @Override
    public String getNodeName() {
        return NAMES[this.kind()];
    }

    @Override
    public final short getNodeType() {
        return TYPES[this.kind()];
    }

    protected int kind() {
        return ANode.kind(this.node.ndType());
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public final BXNode cloneNode(boolean deep) {
        return this.node.copy().toJava();
    }

    @Override
    public final short compareDocumentPosition(Node other) {
        int d = this.node.diff(((BXNode)other).node);
        return (short)(d < 0 ? -1 : (d > 0 ? 1 : 0));
    }

    @Override
    public BXNNode getAttributes() {
        return null;
    }

    @Override
    public final String getBaseURI() {
        return IO.get(Token.string(this.node.base())).url();
    }

    @Override
    public BXNList getChildNodes() {
        return new BXNList(BXNode.finish(this.node.children()));
    }

    @Override
    public BXNode getFirstChild() {
        return this.toJava(this.node.children().next());
    }

    @Override
    public final BXNode getLastChild() {
        ANode t;
        ANode n = null;
        AxisMoreIter ai = this.node.children();
        while ((t = ai.next()) != null) {
            n = t;
        }
        return this.toJava(n);
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public BXNode getNextSibling() {
        return this.toJava(this.node.follSibl().next());
    }

    @Override
    public BXNode getPreviousSibling() {
        return this.toJava(this.node.precSibl().next());
    }

    @Override
    public final BXNode getParentNode() {
        return this.toJava(this.node.parent());
    }

    private BXNode toJava(ANode n) {
        return n != null ? n.toJava() : null;
    }

    @Override
    public final boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public final boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public BXDoc getOwnerDocument() {
        ANode p;
        ANode n = this.node;
        while ((p = n.parent()) != null) {
            n = p;
        }
        return n.type == NodeType.DOC ? (BXDoc)n.toJava() : null;
    }

    @Override
    public final boolean hasAttributes() {
        return this.getAttributes().getLength() != 0;
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public final String getPrefix() {
        return null;
    }

    @Override
    public final String getTextContent() {
        return Token.string(this.node.atom());
    }

    @Override
    public final BXNode appendChild(Node newChild) {
        this.readOnly();
        return null;
    }

    @Override
    public final Object getUserData(String key) {
        return null;
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public final BXNode insertBefore(Node newChild, Node refChild) {
        this.readOnly();
        return null;
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        Util.notimplemented(new Object[0]);
        return false;
    }

    @Override
    public final boolean isEqualNode(Node cmp) {
        Util.notimplemented(new Object[0]);
        return false;
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        Util.notimplemented(new Object[0]);
        return null;
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        Util.notimplemented(new Object[0]);
        return null;
    }

    @Override
    public final void normalize() {
        this.readOnly();
    }

    @Override
    public final BXNode removeChild(Node oldChild) {
        this.readOnly();
        return null;
    }

    @Override
    public final BXNode replaceChild(Node newChild, Node oldChild) {
        this.readOnly();
        return null;
    }

    @Override
    public final void setNodeValue(String nodeValue) {
        this.readOnly();
    }

    @Override
    public final void setPrefix(String prefix) {
        this.readOnly();
    }

    @Override
    public final void setTextContent(String textContent) {
        this.readOnly();
    }

    @Override
    public final Object setUserData(String key, Object dat, UserDataHandler handler) {
        this.readOnly();
        return null;
    }

    public final String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    protected final BXNList getElements(String tag) {
        ANode n;
        NodeCache nb = new NodeCache();
        AxisIter ai = this.node.descendant();
        byte[] nm = tag.equals("*") ? null : Token.token(tag);
        while ((n = ai.next()) != null) {
            if (n.type != NodeType.ELM || nm != null && !Token.eq(nm, n.nname())) continue;
            nb.add(n.copy());
        }
        return new BXNList(nb);
    }

    protected static final NodeCache finish(AxisIter ai) {
        ANode n;
        NodeCache nc = new NodeCache();
        while ((n = ai.next()) != null) {
            nc.add(n.copy());
        }
        return nc;
    }

    public final ANode getNod() {
        return this.node;
    }

    protected final void readOnly() {
        throw new DOMException(7, "DOM implementation is read-only.");
    }
}

