/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.util.MessageDialogHandler;

public class FieldChangeTriggers {
    private static MessageDialogHandler messageDialogHandler;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public void actOnChange(ArbilField changedArbilField) {
        String fieldPath = changedArbilField.getGenericFullXmlPath();
        System.out.println("fieldPath: " + fieldPath);
        for (String[] currentTrigger : changedArbilField.getParentDataNode().getNodeTemplate().fieldTriggersArray) {
            if (!fieldPath.equals(currentTrigger[0])) continue;
            String originalFieldPath = changedArbilField.getFullXmlPath();
            int lastBracketPos = originalFieldPath.lastIndexOf(")");
            int lastTriggerBracket = currentTrigger[1].lastIndexOf(")");
            if (lastTriggerBracket < 0) {
                messageDialogHandler.addMessageDialogToQueue("Error in trigger from template (missing bracket): " + currentTrigger[1], "Field Trigger");
                break;
            }
            String targetFieldPath = originalFieldPath.substring(0, lastBracketPos) + currentTrigger[1].substring(lastTriggerBracket);
            System.out.println("originalFieldPath: " + originalFieldPath);
            System.out.println("targetFieldPath: " + targetFieldPath);
            ArbilField[] targetField = changedArbilField.getSiblingField(targetFieldPath);
            ArbilVocabularyItem vocabItem = changedArbilField.getVocabulary().findVocabularyItem(changedArbilField.getFieldValue());
            if (vocabItem == null) continue;
            String valueForTargetField = null;
            if (currentTrigger[2].equals("Content")) {
                valueForTargetField = vocabItem.descriptionString;
            } else if (currentTrigger[2].equals("Value")) {
                valueForTargetField = vocabItem.itemDisplayName;
            } else if (currentTrigger[2].equals("Code")) {
                valueForTargetField = vocabItem.itemCode;
            } else if (currentTrigger[2].equals("FollowUp")) {
                targetField[0].loadVocabulary();
            }
            if (valueForTargetField == null) continue;
            targetField[0].setFieldValue(valueForTargetField, true, false);
        }
    }
}

