/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.ui.ArbilHyperlinkListener;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilHelp
extends JPanel {
    public static final String SHOTCUT_KEYS_PAGE = "Short Cut Keys";
    public static final String INTRODUCTION_PAGE = "2. Quick Introduction";
    DefaultMutableTreeNode rootContentsNode;
    DefaultTreeModel helpTreeModel;
    private static ArbilHelp singleInstance = null;
    private HelpNodeUserObject[] allHelpNodes;
    public static final String helpWindowTitle = "Help Viewer";
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPane1;
    private JTree jTree1;

    public static synchronized ArbilHelp getSingleInstance() {
        System.out.println("LinorgHelp getSingleInstance");
        if (singleInstance == null) {
            singleInstance = new ArbilHelp();
        }
        return singleInstance;
    }

    private ArbilHelp() {
        this.initComponents();
        this.jTextPane1.setContentType("text/html");
        ((HTMLDocument)this.jTextPane1.getDocument()).setBase(this.getClass().getResource("/nl/mpi/arbil/resources/html/help/"));
        Vector<String> availablePages = new Vector<String>();
        this.jTree1.getSelectionModel().setSelectionMode(1);
        try {
            InputStream fileReader = this.getClass().getResourceAsStream("/nl/mpi/arbil/resources/html/help/index.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileReader));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                availablePages.add(line);
            }
            bufferedReader.close();
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        this.rootContentsNode = new DefaultMutableTreeNode("Contents");
        this.helpTreeModel = new DefaultTreeModel(this.rootContentsNode, true);
        this.jTree1.setModel(this.helpTreeModel);
        this.populateContentsPane(availablePages, this.helpTreeModel, this.rootContentsNode);
        this.jTree1.setSelectionRow(1);
    }

    private void scanDirectory(File helpDirectory, BufferedWriter outFile) throws IOException {
        File[] directoryListingArray;
        for (File currentFile : directoryListingArray = helpDirectory.listFiles()) {
            if (currentFile.isDirectory()) {
                this.scanDirectory(currentFile, outFile);
                continue;
            }
            if (currentFile.getName().endsWith("index.txt")) continue;
            System.out.println("currentFile: " + currentFile.getPath());
            outFile.write(currentFile.getPath().split("/nl/mpi/arbil/resources/html/help/")[1] + "\n");
        }
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode currentNode, String helpPage) {
        System.out.println("currentNode: " + currentNode);
        if (currentNode.getUserObject().toString().equals(helpPage)) {
            return currentNode;
        }
        if (currentNode.getChildCount() >= 0) {
            Enumeration<TreeNode> e = currentNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)e.nextElement();
                DefaultMutableTreeNode foundNode = this.findNode(nextNode, helpPage);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    public void setCurrentPage(String helpPage) {
        DefaultMutableTreeNode foundNode = this.findNode(this.rootContentsNode, helpPage);
        if (foundNode != null) {
            final TreePath targetTreePath = new TreePath(foundNode.getPath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArbilHelp.this.jTree1.scrollPathToVisible(targetTreePath);
                    ArbilHelp.this.jTree1.setSelectionPath(targetTreePath);
                }
            });
        }
    }

    private void populateContentsPane(Vector<String> availablePages, DefaultTreeModel helpTreeModel, DefaultMutableTreeNode currentNode) {
        System.out.println("populateContentsPane: " + availablePages);
        if (availablePages != null) {
            Collections.sort(availablePages, new Comparator(){

                public int compare(Object object1, Object object2) {
                    String string1 = object1.toString();
                    String string2 = object2.toString();
                    return string2.compareToIgnoreCase(string1);
                }
            });
            this.allHelpNodes = new HelpNodeUserObject[availablePages.size()];
            int allHelpNodeCount = availablePages.size() - 1;
            for (String currentFileName : availablePages) {
                DefaultMutableTreeNode currentSearchNode = this.rootContentsNode;
                System.out.println("currentFileName: " + currentFileName);
                for (String pathPartString : currentFileName.split("/")) {
                    boolean foundNode = false;
                    Enumeration<TreeNode> childEnum = currentSearchNode.children();
                    while (childEnum.hasMoreElements()) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childEnum.nextElement();
                        if (!pathPartString.equals(childNode.getUserObject().toString())) continue;
                        currentSearchNode = childNode;
                        foundNode = true;
                        break;
                    }
                    if (foundNode) continue;
                    currentSearchNode.setAllowsChildren(true);
                    DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(pathPartString);
                    helpTreeModel.insertNodeInto(childNode, currentSearchNode, 0);
                    currentSearchNode = childNode;
                }
                URL currentURL = this.getClass().getResource("/nl/mpi/arbil/resources/html/help/" + currentFileName);
                String currentName = currentSearchNode.getUserObject().toString().replaceFirst("\\.html$", "");
                this.allHelpNodes[allHelpNodeCount] = new HelpNodeUserObject(currentName, currentURL);
                currentSearchNode.setUserObject(this.allHelpNodes[allHelpNodeCount]);
                --allHelpNodeCount;
                currentSearchNode.setAllowsChildren(false);
            }
        }
    }

    public void printAsOneFile() {
        HelpTemplate helpTemplate = new HelpTemplate();
        try {
            StringBuilder completeHelpText = new StringBuilder();
            completeHelpText.append(helpTemplate.startHead);
            completeHelpText.append("Arbil Help");
            completeHelpText.append(helpTemplate.startBody);
            completeHelpText.append(helpTemplate.preContentTitle);
            completeHelpText.append("Arbil Help");
            completeHelpText.append(helpTemplate.postContentTitle);
            for (HelpNodeUserObject currentHelpPage : this.allHelpNodes) {
                String sectionHeader;
                URLConnection conn = currentHelpPage.getHelpURL().openConnection();
                BufferedInputStream helpTemplateReader = new BufferedInputStream(conn.getInputStream());
                BufferedReader bufferedHelpReader = new BufferedReader(new InputStreamReader(helpTemplateReader));
                String helpLine = sectionHeader = helpTemplate.preContentSubTitle + currentHelpPage.nameString + helpTemplate.postContentSubTitle;
                while (helpLine != null) {
                    completeHelpText.append(helpLine);
                    helpLine = bufferedHelpReader.readLine();
                }
                bufferedHelpReader.close();
            }
            completeHelpText.append(helpTemplate.endContent);
            completeHelpText.append(helpTemplate.endBody);
            System.out.println(completeHelpText.toString());
            this.jTextPane1.setText(completeHelpText.toString());
            this.jTextPane1.setCaretPosition(0);
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Printing is not yet enabled, however this is roughly what will be printed", helpWindowTitle);
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jTextPane1.addHyperlinkListener(new ArbilHyperlinkListener());
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ArbilHelp.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jTextPane1.setEditable(false);
        this.jScrollPane2.setViewportView(this.jTextPane1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (node != null) {
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                try {
                    if (((HelpNodeUserObject)nodeInfo).getHelpURL() != null) {
                        HelpTemplate helpTemplate = new HelpTemplate();
                        StringBuilder completeHelpText = new StringBuilder();
                        completeHelpText.append(helpTemplate.startHead);
                        completeHelpText.append(((HelpNodeUserObject)nodeInfo).nameString);
                        completeHelpText.append(helpTemplate.startBody);
                        completeHelpText.append(helpTemplate.preContentTitle);
                        completeHelpText.append(((HelpNodeUserObject)nodeInfo).nameString);
                        completeHelpText.append(helpTemplate.postContentTitle);
                        URLConnection conn = ((HelpNodeUserObject)nodeInfo).getHelpURL().openConnection();
                        BufferedInputStream helpTemplateReader = new BufferedInputStream(conn.getInputStream());
                        BufferedReader bufferedHelpReader = new BufferedReader(new InputStreamReader(helpTemplateReader));
                        String helpLine = bufferedHelpReader.readLine();
                        while (helpLine != null) {
                            completeHelpText.append(helpLine);
                            helpLine = bufferedHelpReader.readLine();
                        }
                        bufferedHelpReader.close();
                        completeHelpText.append(helpTemplate.endContent);
                        completeHelpText.append(helpTemplate.endBody);
                        this.jTextPane1.setText(completeHelpText.toString());
                        this.jTextPane1.setCaretPosition(0);
                    } else {
                        this.jTextPane1.setText("Page not found");
                    }
                }
                catch (Exception ex) {
                    this.jTextPane1.setText("Page not found error");
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        }
    }

    private static class HelpTemplate {
        String startHead = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html><head><title>";
        String startBody = "</title><STYLE TYPE=\"text/css\"><!-- .helpTitle { text-align: center; font-size:125%; background: #ede2cd; margin:0; padding:0; } .helpSubTitle { text-align: left; font-size:110%; background: #ede2cd; margin:0; padding:0; } .helpText { color:Black; font-family:Arial,Helvetica,sans-serif; font-size:100%; font-size-adjust:none; font-style:normal; font-variant:normal; font-weight:normal; line-height:1.25em; background: #F4F1EB; } --> </STYLE></head><body class=\"helpText\">";
        String preContentTitle = "<table width=\"100%\" border=\"0\" cellpadding=\"10\" cellspacing=\"0\"><tr width=\"100%\" class=\"helpTitle\"><td width=\"100%\">";
        String postContentTitle = "</td><td><img src=\"../../icons/arbil32x32.png\"></td></tr><tr><td width=\"100%\" height=\"100%\" colspan=\"2\" class=\"helpText\">";
        String preContentSubTitle = "</td></tr><tr width=\"100%\" class=\"helpSubTitle\"><td width=\"100%\" colspan=\"2\">";
        String postContentSubTitle = "</td></tr><tr width=\"100%\"><td width=\"100%\" height=\"100%\" colspan=\"2\" class=\"helpText\">";
        String endContent = "</td></tr></table>";
        String endBody = "</body></html>";

        private HelpTemplate() {
        }
    }

    private static class HelpNodeUserObject {
        String nameString;
        URL helpURL;

        public HelpNodeUserObject(String localNameString, URL localHelpFile) {
            this.nameString = localNameString;
            this.helpURL = localHelpFile;
        }

        public String toString() {
            return this.nameString;
        }

        public URL getHelpURL() {
            return this.helpURL;
        }
    }
}

