/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.GraphLabel;
import nl.mpi.kinnate.kintypestrings.LabelStringsParser;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

@XmlRootElement(name="Entity", namespace="http://mpi.nl/tla/kin")
public class EntityData {
    @XmlElement(name="Identifier", namespace="http://mpi.nl/tla/kin")
    private UniqueIdentifier uniqueIdentifier;
    @XmlElement(name="Path", namespace="http://mpi.nl/tla/kin")
    private String entityPath;
    @XmlElement(name="KinType", namespace="http://mpi.nl/tla/kin")
    private String[] kinTypeArray = new String[0];
    @XmlElement(name="KinTerm", namespace="http://mpi.nl/tla/kin")
    private GraphLabel[] kinTermArray = new GraphLabel[0];
    private SymbolType symbolType;
    @XmlElement(name="Symbol", namespace="http://mpi.nl/tla/kin")
    private String symbolTypeString;
    @XmlElement(name="DateOfBirth", namespace="http://mpi.nl/tla/kin")
    private Date dateOfBirth;
    @XmlElement(name="DateOfDeath", namespace="http://mpi.nl/tla/kin")
    private Date dateOfDeath;
    @XmlTransient
    public boolean isEgo = false;
    @XmlElement(name="Label", namespace="http://mpi.nl/tla/kin")
    private String[] labelStringArray = new String[0];
    @XmlTransient
    ArrayList<String> tempLabelsList = null;
    @XmlElementWrapper(name="Relations", namespace="http://mpi.nl/tla/kin")
    @XmlElement(name="Relation", namespace="http://mpi.nl/tla/kin")
    private EntityRelation[] relatedNodes;
    @XmlElement(name="ArchiveLink", namespace="http://mpi.nl/tla/kin")
    public URI[] archiveLinkArray = null;
    @XmlTransient
    public boolean metadataRequiresSave = false;
    @XmlTransient
    public boolean isVisible = false;
    @XmlTransient
    private EntityRelation[] visiblyRelateNodes = null;
    @XmlTransient
    private EntityRelation[] distinctRelateNodes = null;

    private EntityData() {
    }

    public EntityData(LabelStringsParser labelStringsParser, String kinTypeStringLocal, SymbolType symbolIndex, boolean isEgoLocal) {
        this.uniqueIdentifier = labelStringsParser.uniqueIdentifier;
        this.entityPath = null;
        this.kinTypeArray = new String[]{kinTypeStringLocal};
        this.symbolType = symbolIndex;
        this.labelStringArray = labelStringsParser.labelsStrings;
        this.isEgo = isEgoLocal;
        this.dateOfBirth = labelStringsParser.dateOfBirth;
        this.dateOfDeath = labelStringsParser.dateOfDeath;
    }

    public EntityData(UniqueIdentifier uniqueIdentifierLocal, String[] errorMessage) {
        this.uniqueIdentifier = uniqueIdentifierLocal;
        this.entityPath = null;
        this.symbolType = SymbolType.error;
        this.symbolTypeString = null;
        this.labelStringArray = errorMessage;
        this.isEgo = false;
    }

    public EntityData(UniqueIdentifier uniqueIdentifierLocal) {
        this.uniqueIdentifier = uniqueIdentifierLocal;
        this.entityPath = null;
        this.symbolType = null;
        this.symbolTypeString = null;
        this.labelStringArray = null;
        this.isEgo = false;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfDeath(Date dateOfDeath) {
        this.dateOfDeath = dateOfDeath;
    }

    public void addArchiveLink(URI resourceUri) {
        ArrayList<Object> linksList = this.archiveLinkArray != null ? new ArrayList<URI>(Arrays.asList(this.archiveLinkArray)) : new ArrayList<URI>();
        linksList.add(resourceUri);
        this.archiveLinkArray = linksList.toArray(new URI[0]);
    }

    public String getSymbolType() {
        if (this.symbolType != null) {
            return this.symbolType.name();
        }
        return this.symbolTypeString;
    }

    @XmlTransient
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @XmlTransient
    public Date getDateOfDeath() {
        return this.dateOfDeath;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public void addKinTypeString(String kinTypeString) {
        ArrayList<String> tempList = new ArrayList<String>(Arrays.asList(this.kinTypeArray));
        if (!tempList.contains(kinTypeString)) {
            tempList.add(kinTypeString);
            this.kinTypeArray = tempList.toArray(new String[0]);
        }
    }

    public String[] getKinTypeStringArray() {
        return this.kinTypeArray;
    }

    public String getKinTypeString() {
        String returnString = "";
        if (this.kinTypeArray.length > 0) {
            for (String kinType : this.kinTypeArray) {
                returnString = returnString + kinType + "|";
            }
            returnString = returnString.substring(0, returnString.length() - 1);
        }
        return returnString;
    }

    public void addKinTermString(String kinTermString, String colourString) {
        for (GraphLabel currentLabel : this.kinTermArray) {
            if (!currentLabel.getLabelString().equals(kinTermString) || !currentLabel.getColourString().equals(colourString)) continue;
            return;
        }
        ArrayList<GraphLabel> tempList = new ArrayList<GraphLabel>(Arrays.asList(this.kinTermArray));
        tempList.add(new GraphLabel(kinTermString, colourString));
        this.kinTermArray = tempList.toArray(new GraphLabel[0]);
    }

    public GraphLabel[] getKinTermStrings() {
        return this.kinTermArray;
    }

    public String[] getLabel() {
        if (this.tempLabelsList != null) {
            return this.tempLabelsList.toArray(new String[0]);
        }
        return this.labelStringArray;
    }

    public void clearTempLabels() {
        this.tempLabelsList = null;
    }

    public void appendTempLabel(String labelString) {
        if (this.tempLabelsList == null) {
            this.tempLabelsList = new ArrayList<String>(Arrays.asList(this.labelStringArray));
        }
        if (!this.tempLabelsList.contains(labelString)) {
            this.tempLabelsList.add(labelString);
        }
    }

    private void insertSiblingRelations(EntityData parentEntity) {
        for (EntityRelation entityRelation : parentEntity.getAllRelations()) {
            if (!entityRelation.relationType.equals((Object)DataTypes.RelationType.descendant) || entityRelation.getAlterNode().equals(this)) continue;
            entityRelation.getAlterNode().addRelatedNode(this, DataTypes.RelationType.sibling, DataTypes.RelationLineType.sanguineLine, null, null);
            this.addRelatedNode(entityRelation.getAlterNode(), DataTypes.RelationType.sibling, DataTypes.RelationLineType.sanguineLine, null, null);
        }
    }

    public void removeRelationsWithNode(EntityData alterNodeLocal) {
        ArrayList<EntityRelation> uniqueNodes = new ArrayList<EntityRelation>();
        if (this.relatedNodes != null) {
            for (EntityRelation nodeRelation : this.relatedNodes) {
                if (alterNodeLocal.uniqueIdentifier.equals(nodeRelation.alterUniqueIdentifier)) continue;
                uniqueNodes.add(nodeRelation);
            }
        }
        this.relatedNodes = uniqueNodes.toArray(new EntityRelation[0]);
        this.distinctRelateNodes = null;
    }

    public void addRelatedNode(EntityData alterNodeLocal, DataTypes.RelationType relationType, DataTypes.RelationLineType relationLineType, String lineColourLocal, String labelString) {
        EntityRelation nodeRelation = new EntityRelation();
        nodeRelation.setAlterNode(alterNodeLocal);
        nodeRelation.relationType = relationType;
        nodeRelation.relationLineType = relationLineType;
        nodeRelation.labelString = labelString;
        nodeRelation.lineColour = lineColourLocal;
        if (this.relatedNodes != null) {
            for (EntityRelation entityRelation : this.relatedNodes) {
                if (entityRelation.compareTo(nodeRelation) != 0) continue;
                return;
            }
            ArrayList<EntityRelation> relatedNodesList = new ArrayList<EntityRelation>();
            relatedNodesList.addAll(Arrays.asList(this.relatedNodes));
            relatedNodesList.add(nodeRelation);
            this.relatedNodes = relatedNodesList.toArray(new EntityRelation[0]);
        } else {
            this.relatedNodes = new EntityRelation[]{nodeRelation};
        }
        this.distinctRelateNodes = null;
        if (!relationType.equals((Object)DataTypes.RelationType.none)) {
            DataTypes.RelationType opposingRelationType = DataTypes.getOpposingRelationType(relationType);
            alterNodeLocal.addRelatedNode(this, opposingRelationType, relationLineType, null, null);
            if (relationType.equals((Object)DataTypes.RelationType.ancestor)) {
                this.insertSiblingRelations(alterNodeLocal);
            } else if (relationType.equals((Object)DataTypes.RelationType.descendant)) {
                alterNodeLocal.insertSiblingRelations(this);
            }
        }
    }

    public void clearVisibility() {
        this.isVisible = false;
        this.isEgo = false;
        this.visiblyRelateNodes = null;
        this.distinctRelateNodes = null;
    }

    public EntityRelation[] getVisiblyRelateNodes() {
        if (this.visiblyRelateNodes == null) {
            ArrayList<EntityRelation> visiblyRelatedNodes = new ArrayList<EntityRelation>();
            for (EntityRelation nodeRelation : this.getDistinctRelateNodes()) {
                if (nodeRelation.getAlterNode() == null || !nodeRelation.getAlterNode().isVisible) continue;
                visiblyRelatedNodes.add(nodeRelation);
            }
            this.visiblyRelateNodes = visiblyRelatedNodes.toArray(new EntityRelation[0]);
        }
        return this.visiblyRelateNodes;
    }

    public EntityRelation[] getAllRelations() {
        if (this.relatedNodes == null) {
            return new EntityRelation[0];
        }
        return this.relatedNodes;
    }

    public EntityRelation[] getDistinctRelateNodes() {
        if (this.distinctRelateNodes == null) {
            ArrayList<UniqueIdentifier> processedIds = new ArrayList<UniqueIdentifier>();
            ArrayList<EntityRelation> uniqueNodes = new ArrayList<EntityRelation>();
            if (this.relatedNodes != null) {
                for (EntityRelation nodeRelation : this.relatedNodes) {
                    if (processedIds.contains(nodeRelation.alterUniqueIdentifier)) continue;
                    uniqueNodes.add(nodeRelation);
                    processedIds.add(nodeRelation.alterUniqueIdentifier);
                }
            }
            this.distinctRelateNodes = uniqueNodes.toArray(new EntityRelation[0]);
        }
        return this.distinctRelateNodes;
    }

    public EntityRelation[] getRelatedNodesToBeLoaded() {
        ArrayList<EntityRelation> entityRelationsToLoad = new ArrayList<EntityRelation>();
        for (EntityRelation relatedNode : this.getDistinctRelateNodes()) {
            if (relatedNode.getAlterNode() != null) continue;
            entityRelationsToLoad.add(relatedNode);
        }
        return entityRelationsToLoad.toArray(new EntityRelation[0]);
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SymbolType {
        square,
        triangle,
        circle,
        union,
        resource,
        none,
        error;

    }
}

