/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntityDocument {
    File entityFile = null;
    Document metadataDom = null;
    Node kinnateNode = null;
    Element metadataNode = null;
    Node currentDomNode = null;
    public EntityData entityData = null;
    private ImportTranslator importTranslator;

    public EntityDocument(ImportTranslator importTranslator) {
        this.importTranslator = importTranslator;
        this.entityData = new EntityData(new UniqueIdentifier(UniqueIdentifier.IdentifierType.lid));
        String idString = this.entityData.getUniqueIdentifier().getQueryIdentifier() + ".kmdi";
        File subDirectory = new File(ArbilSessionStorage.getSingleInstance().getCacheDirectory(), idString.substring(0, 2));
        subDirectory.mkdir();
        this.entityFile = new File(subDirectory, idString);
    }

    public EntityDocument(File destinationDirectory, String nameString, ImportTranslator importTranslator) {
        this.importTranslator = importTranslator;
        this.entityData = new EntityData(new UniqueIdentifier(UniqueIdentifier.IdentifierType.lid));
        if (nameString != null) {
            String idString = nameString;
            this.entityFile = new File(destinationDirectory, nameString);
        } else {
            String idString = this.entityData.getUniqueIdentifier().getQueryIdentifier() + ".kmdi";
            File subDirectory = new File(destinationDirectory, idString.substring(0, 2));
            subDirectory.mkdir();
            this.entityFile = new File(subDirectory, idString);
        }
    }

    public EntityDocument(URI entityUri, ImportTranslator importTranslator) throws ImportException {
        this.importTranslator = importTranslator;
        try {
            this.entityFile = new File(entityUri);
            this.metadataDom = ArbilComponentBuilder.getDocument((URI)entityUri);
            this.kinnateNode = this.metadataDom.getDocumentElement();
            NodeList metadataNodeList = ((Element)this.kinnateNode).getElementsByTagName("Metadata");
            if (metadataNodeList.getLength() < 1) {
                throw new ImportException("Metadata node not found");
            }
            this.metadataNode = (Element)metadataNodeList.item(0);
            NodeList entityNodeList = ((Element)this.kinnateNode).getElementsByTagNameNS("http://mpi.nl/tla/kin", "Entity");
            for (int entityCounter = 0; entityCounter < entityNodeList.getLength(); ++entityCounter) {
                if (this.entityData == null) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityData.class});
                    Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                    this.entityData = (EntityData)unmarshaller.unmarshal(entityNodeList.item(entityCounter), EntityData.class).getValue();
                }
                this.kinnateNode.removeChild(entityNodeList.item(entityCounter));
            }
            this.currentDomNode = this.metadataNode;
            if (this.entityData == null) {
                throw new ImportException("Entity node not found");
            }
        }
        catch (JAXBException exception) {
            new ArbilBugCatcher().logError((Exception)((Object)exception));
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (ParserConfigurationException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (SAXException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (IOException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
    }

    public String getFileName() {
        return this.entityFile.getName();
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.entityData.getUniqueIdentifier();
    }

    public URI createDocument(boolean overwriteExisting) throws ImportException {
        URI entityUri;
        if (this.metadataDom != null) {
            throw new ImportException("The document already exists");
        }
        String gedcomXsdLocation = "/xsd/StandardEntity.xsd";
        if (!overwriteExisting && this.entityFile.exists()) {
            throw new ImportException("Skipping existing entity file");
        }
        try {
            entityUri = this.entityFile.toURI();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            String templateXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Kinnate xmlns:kin=\"http://mpi.nl/tla/kin\" xmlns=\"http://www.clarin.eu/cmd/\" version=\"1.0\" CMDVersion=\"1.1\" />";
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.metadataDom = documentBuilder.parse(new InputSource(new StringReader(templateXml)));
            this.metadataNode = this.metadataDom.createElementNS("http://www.clarin.eu/cmd/", "Metadata");
            this.currentDomNode = this.metadataNode;
            this.kinnateNode = this.metadataDom.getDocumentElement();
        }
        catch (DOMException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (ParserConfigurationException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (IOException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (SAXException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        return entityUri;
    }

    public Node getMetadataNode() {
        return this.metadataNode;
    }

    public void insertValue(String nodeName, String valueString) {
        ImportTranslator.TranslationElement translationElement = this.importTranslator.translate(nodeName, valueString);
        System.out.println("insertValue: " + translationElement.fieldName + " : " + translationElement.fieldValue);
        for (Node currentNode = this.metadataNode.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (!translationElement.fieldName.equals(currentNode.getLocalName())) continue;
            if (currentNode.getTextContent() == null || currentNode.getTextContent().length() == 0) {
                currentNode.setTextContent(translationElement.fieldValue);
                return;
            }
            if (!currentNode.getTextContent().equals(translationElement.fieldValue)) continue;
            return;
        }
        Element valueElement = this.metadataDom.createElementNS("http://www.clarin.eu/cmd/", translationElement.fieldName);
        valueElement.setTextContent(translationElement.fieldValue);
        this.metadataNode.appendChild(valueElement);
    }

    public void importNode(Node foreignNode) {
        Node importedNode = this.metadataDom.importNode(foreignNode, true);
        while (importedNode.hasChildNodes()) {
            Node currentChild = importedNode.getFirstChild();
            this.currentDomNode.appendChild(currentChild);
        }
    }

    public Node insertNode(String nodeName, String valueString) {
        ImportTranslator.TranslationElement translationElement = this.importTranslator.translate(nodeName, valueString);
        System.out.println("nodeName: " + translationElement.fieldName + " : " + translationElement.fieldValue);
        Element valueElement = this.metadataDom.createElementNS("http://www.clarin.eu/cmd/", translationElement.fieldName);
        valueElement.setTextContent(translationElement.fieldValue);
        this.currentDomNode.appendChild(valueElement);
        return valueElement;
    }

    public void assendToLevel(int nodeLevel) {
        int levelCount = 0;
        for (Node counterNode = this.currentDomNode; counterNode != null; counterNode = counterNode.getParentNode()) {
            ++levelCount;
        }
        --levelCount;
        while (levelCount > nodeLevel) {
            --levelCount;
            this.currentDomNode = this.currentDomNode.getParentNode();
        }
    }

    public void appendValueToLast(String valueString) {
        System.out.println("appendValueToLast: " + valueString);
        this.currentDomNode.setTextContent(this.currentDomNode.getTextContent() + valueString);
    }

    public void appendValue(String nodeName, String valueString, int targetLevel) {
        String currentValue;
        System.out.println("appendValue: " + nodeName + " : " + valueString + " : " + targetLevel);
        this.assendToLevel(targetLevel);
        NodeList childNodes = this.currentDomNode.getChildNodes();
        if (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && (currentValue = this.currentDomNode.getTextContent()) != null && currentValue.trim().length() > 0) {
            Element spacerElement = this.metadataDom.createElementNS("http://www.clarin.eu/cmd/", this.currentDomNode.getLocalName());
            Node parentNode = this.currentDomNode.getParentNode();
            parentNode.removeChild(this.currentDomNode);
            spacerElement.appendChild(this.currentDomNode);
            parentNode.appendChild(spacerElement);
            this.currentDomNode = spacerElement;
        }
        this.currentDomNode = this.insertNode(nodeName, valueString);
    }

    public void insertDefaultMetadata() {
        this.insertValue("Gender", "unspecified");
        this.insertValue("Name", "unspecified");
    }

    public File getFile() {
        return this.entityFile;
    }

    public String getFilePath() {
        return this.entityFile.getAbsolutePath();
    }

    public void setAsDeletedDocument() throws ImportException {
    }

    public void saveDocument() throws ImportException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityData.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)this.entityData, this.kinnateNode);
        }
        catch (JAXBException exception) {
            new ArbilBugCatcher().logError((Exception)((Object)exception));
            throw new ImportException("Error: " + exception.getMessage());
        }
        this.kinnateNode.appendChild(this.metadataNode);
        ArbilComponentBuilder.savePrettyFormatting((Document)this.metadataDom, (File)this.entityFile);
    }
}

