/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

@XmlRootElement(name="KinDiagramData", namespace="http://mpi.nl/tla/kin")
public class DataStoreSvg {
    protected static String kinDataNameSpace = "kin";
    protected static String kinDataNameSpaceLocation = "http://mpi.nl/tla/kin";
    @XmlElement(name="EgoId", namespace="http://mpi.nl/tla/kin")
    public HashSet<UniqueIdentifier> egoEntities = new HashSet();
    @XmlElement(name="RequiredEntities", namespace="http://mpi.nl/tla/kin")
    public HashSet<UniqueIdentifier> requiredEntities = new HashSet();
    @XmlElement(name="KinTypeString", namespace="http://mpi.nl/tla/kin")
    protected String[] kinTypeStrings = new String[0];
    @XmlElement(name="IndexParameters", namespace="http://mpi.nl/tla/kin")
    protected IndexerParameters indexParameters;
    @XmlElement(name="KinTermGroup", namespace="http://mpi.nl/tla/kin")
    protected KinTermGroup[] kinTermGroups = new KinTermGroup[0];
    @XmlElement(name="ShowLabels", namespace="http://mpi.nl/tla/kin")
    public boolean showLabels = true;
    @XmlElement(name="ShowKinTypeLabels", namespace="http://mpi.nl/tla/kin")
    public boolean showKinTypeLabels = false;
    @XmlElement(name="ShowKinTermLabels", namespace="http://mpi.nl/tla/kin")
    public boolean showKinTermLabels = false;
    @XmlElement(name="ShowKinTermLines", namespace="http://mpi.nl/tla/kin")
    public boolean showKinTermLines = true;
    @XmlElement(name="SnapToGrid", namespace="http://mpi.nl/tla/kin")
    public boolean snapToGrid = true;
    @XmlElement(name="ShowSanguineLines", namespace="http://mpi.nl/tla/kin")
    public boolean showSanguineLines = true;
    @XmlElement(name="ShowArchiveLinks", namespace="http://mpi.nl/tla/kin")
    public boolean showArchiveLinks = true;
    @XmlElement(name="HighlightRelationLines", namespace="http://mpi.nl/tla/kin")
    public boolean highlightRelationLines = true;
    @XmlElement(name="ShowDiagramBorder", namespace="http://mpi.nl/tla/kin")
    public boolean showDiagramBorder = true;
    @XmlElement(name="EntityData", namespace="http://mpi.nl/tla/kin")
    protected GraphSorter graphData;
    @XmlElement(name="DiagramPanel", namespace="http://mpi.nl/tla/kin")
    private HashSet<VisiblePanelSetting> visiblePanels;

    public void setDefaults() {
        this.kinTermGroups = new KinTermGroup[0];
        this.indexParameters = new IndexerParameters();
    }

    public VisiblePanelSetting[] getVisiblePanels() {
        if (this.visiblePanels == null) {
            return null;
        }
        return this.visiblePanels.toArray(new VisiblePanelSetting[0]);
    }

    public void setPanelState(VisiblePanelSetting.PanelType panelType, int panelWidth, boolean panelVisible) {
        if (this.visiblePanels == null) {
            this.visiblePanels = new HashSet();
        }
        this.visiblePanels.add(new VisiblePanelSetting(panelType, panelVisible, panelWidth));
    }

    public GraphRelationData getEntitiesForRelations(Node relationGroup) throws IdentifierException {
        for (Node currentChild = relationGroup.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!"RelationEntities".equals(currentChild.getLocalName())) continue;
            GraphRelationData graphRelationData = new GraphRelationData();
            graphRelationData.egoNodeId = new UniqueIdentifier(currentChild.getAttributes().getNamedItemNS(kinDataNameSpace, "ego").getNodeValue());
            graphRelationData.alterNodeId = new UniqueIdentifier(currentChild.getAttributes().getNamedItemNS(kinDataNameSpace, "alter").getNodeValue());
            graphRelationData.relationType = DataTypes.RelationType.valueOf(currentChild.getAttributes().getNamedItemNS(kinDataNameSpace, "relationType").getNodeValue());
            graphRelationData.relationLineType = DataTypes.RelationLineType.valueOf(currentChild.getAttributes().getNamedItemNS(kinDataNameSpace, "lineType").getNodeValue());
            return graphRelationData;
        }
        return null;
    }

    public void storeRelationParameters(SVGDocument doc, Element relationGroup, DataTypes.RelationType relationType, DataTypes.RelationLineType relationLineType, UniqueIdentifier egoEntity, UniqueIdentifier alterEntity) {
        Element dataRecordNode = doc.createElementNS(kinDataNameSpace, "kin:RelationEntities");
        dataRecordNode.setAttributeNS(kinDataNameSpace, "kin:lineType", relationLineType.name());
        dataRecordNode.setAttributeNS(kinDataNameSpace, "kin:relationType", relationType.name());
        dataRecordNode.setAttributeNS(kinDataNameSpace, "kin:ego", egoEntity.getAttributeIdentifier());
        dataRecordNode.setAttributeNS(kinDataNameSpace, "kin:alter", alterEntity.getAttributeIdentifier());
        relationGroup.appendChild(dataRecordNode);
    }

    protected void storeAllData(SVGDocument doc) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataStoreSvg.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)this, (Node)doc.getRootElement());
        }
        catch (JAXBException exception) {
            new ArbilBugCatcher().logError((Exception)((Object)exception));
        }
    }

    protected static DataStoreSvg loadDataFromSvg(SVGDocument doc) {
        DataStoreSvg dataStoreSvg = new DataStoreSvg();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataStoreSvg.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            NodeList dataStoreNodeList = doc.getElementsByTagNameNS("http://mpi.nl/tla/kin", "KinDiagramData");
            if (dataStoreNodeList.getLength() > 0) {
                dataStoreSvg = (DataStoreSvg)unmarshaller.unmarshal(dataStoreNodeList.item(0), DataStoreSvg.class).getValue();
            }
        }
        catch (JAXBException exception) {
            new ArbilBugCatcher().logError((Exception)((Object)exception));
        }
        return dataStoreSvg;
    }

    public class GraphRelationData {
        public UniqueIdentifier egoNodeId;
        public UniqueIdentifier alterNodeId;
        public DataTypes.RelationType relationType;
        public DataTypes.RelationLineType relationLineType;
    }
}

