/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.ui.MainFrame;

public class DiagramPanelsMenu
extends JMenu
implements ActionListener {
    MainFrame mainFrame;

    public DiagramPanelsMenu(MainFrame mainFrameLocal) {
        this.mainFrame = mainFrameLocal;
        this.setText("View");
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                DiagramPanelsMenu.this.setupMenuItems();
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void setupMenuItems() {
        this.removeAll();
        boolean menuItemsAdded = false;
        KinTermSavePanel kinTermPanel = this.mainFrame.getKinTermPanel();
        if (kinTermPanel != null) {
            for (VisiblePanelSetting panelSetting : kinTermPanel.getVisiblePanels()) {
                menuItemsAdded = true;
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(panelSetting.getDisplayName());
                menuItem.setSelected(panelSetting.isPanelShown());
                menuItem.setActionCommand(panelSetting.getPanelType().name());
                menuItem.addActionListener(this);
                this.add(menuItem);
            }
        }
        if (!menuItemsAdded) {
            JMenuItem noItemsMenu = new JMenuItem("<no items available in this context>");
            noItemsMenu.setEnabled(false);
            this.add(noItemsMenu);
        }
    }

    public void actionPerformed(ActionEvent e) {
        VisiblePanelSetting.PanelType selectedPanelType = VisiblePanelSetting.PanelType.valueOf(e.getActionCommand());
        KinTermSavePanel kinTermPanel = this.mainFrame.getKinTermPanel();
        if (kinTermPanel != null) {
            for (VisiblePanelSetting panelSetting : kinTermPanel.getVisiblePanels()) {
                if (!panelSetting.getPanelType().equals((Object)selectedPanelType)) continue;
                panelSetting.setPanelShown(!panelSetting.isPanelShown());
            }
        }
    }
}

