/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kintypestrings.KinTerm;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTermTableModel
extends AbstractTableModel
implements TableModelListener {
    SavePanel savePanel;
    KinTermGroup kinTerms;
    HashSet<KinTerm> checkBoxSet = new HashSet();
    String defaultKinType = "";

    public KinTermTableModel(SavePanel savePanel, KinTermGroup kinTerms) {
        this.savePanel = savePanel;
        this.kinTerms = kinTerms;
    }

    public void setDefaultKinType(String defaultKinType) {
        this.defaultKinType = defaultKinType;
        this.setValueAt(defaultKinType, this.kinTerms.getKinTerms().length, 1);
        this.fireTableCellUpdated(this.kinTerms.getKinTerms().length, 1);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = (TableModel)e.getSource();
        String columnName = model.getColumnName(column);
        Object data = model.getValueAt(row, column);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Kin Term";
            }
            case 1: {
                return "Alter Kin Type Strings";
            }
            case 2: {
                return "Propositus Kin Type Strings";
            }
            case 3: {
                return "Anchor Kin Type Strings";
            }
            case 4: {
                return "Description";
            }
            case 5: {
                return "";
            }
        }
        throw new UnsupportedOperationException("Too many columns");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 5: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.kinTerms.getKinTerms().length + 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.kinTerms.getKinTerms().length <= rowIndex) {
            switch (columnIndex) {
                case 1: {
                    return this.defaultKinType;
                }
                case 5: {
                    return false;
                }
            }
            return "";
        }
        KinTerm kinTerm = this.kinTerms.getKinTerms()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return kinTerm.kinTerm;
            }
            case 1: {
                return kinTerm.alterKinTypeStrings;
            }
            case 2: {
                return kinTerm.propositusKinTypeStrings;
            }
            case 3: {
                return kinTerm.anchorKinTypeStrings;
            }
            case 4: {
                return kinTerm.kinTermDescription;
            }
            case 5: {
                return this.checkBoxSet.contains(kinTerm);
            }
        }
        throw new UnsupportedOperationException("Too many columns");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        KinTerm kinTerm;
        if (this.kinTerms.getKinTerms().length <= rowIndex) {
            switch (columnIndex) {
                case 1: 
                case 5: {
                    return;
                }
            }
            kinTerm = new KinTerm();
            kinTerm.alterKinTypeStrings = this.defaultKinType;
            this.kinTerms.addKinTerm(kinTerm);
        } else {
            kinTerm = this.kinTerms.getKinTerms()[rowIndex];
        }
        switch (columnIndex) {
            case 0: {
                kinTerm.kinTerm = aValue.toString();
                break;
            }
            case 1: {
                kinTerm.alterKinTypeStrings = aValue.toString();
                break;
            }
            case 2: {
                kinTerm.propositusKinTypeStrings = aValue.toString();
                break;
            }
            case 3: {
                kinTerm.anchorKinTypeStrings = aValue.toString();
                break;
            }
            case 4: {
                kinTerm.kinTermDescription = aValue.toString();
                break;
            }
            case 5: {
                if (((Boolean)aValue).booleanValue()) {
                    this.checkBoxSet.add(kinTerm);
                    break;
                }
                this.checkBoxSet.remove(kinTerm);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Too many columns");
            }
        }
        super.setValueAt(aValue, rowIndex, columnIndex);
        this.savePanel.updateGraph();
    }
}

